/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.controller;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class APCminiControlSurface
extends AbstractControlSurface<APCminiConfiguration> {
    public static final int APC_BUTTON_TRACK_BUTTON1 = 64;
    public static final int APC_BUTTON_TRACK_BUTTON2 = 65;
    public static final int APC_BUTTON_TRACK_BUTTON3 = 66;
    public static final int APC_BUTTON_TRACK_BUTTON4 = 67;
    public static final int APC_BUTTON_TRACK_BUTTON5 = 68;
    public static final int APC_BUTTON_TRACK_BUTTON6 = 69;
    public static final int APC_BUTTON_TRACK_BUTTON7 = 70;
    public static final int APC_BUTTON_TRACK_BUTTON8 = 71;
    public static final int APC_BUTTON_SCENE_BUTTON1 = 82;
    public static final int APC_BUTTON_SCENE_BUTTON2 = 83;
    public static final int APC_BUTTON_SCENE_BUTTON3 = 84;
    public static final int APC_BUTTON_SCENE_BUTTON4 = 85;
    public static final int APC_BUTTON_SCENE_BUTTON5 = 86;
    public static final int APC_BUTTON_SCENE_BUTTON6 = 87;
    public static final int APC_BUTTON_SCENE_BUTTON7 = 88;
    public static final int APC_BUTTON_SCENE_BUTTON8 = 89;
    public static final int APC_BUTTON_SHIFT = 98;
    public static final int APC_KNOB_TRACK_LEVEL1 = 48;
    public static final int APC_KNOB_TRACK_LEVEL2 = 49;
    public static final int APC_KNOB_TRACK_LEVEL3 = 50;
    public static final int APC_KNOB_TRACK_LEVEL4 = 51;
    public static final int APC_KNOB_TRACK_LEVEL5 = 52;
    public static final int APC_KNOB_TRACK_LEVEL6 = 53;
    public static final int APC_KNOB_TRACK_LEVEL7 = 54;
    public static final int APC_KNOB_TRACK_LEVEL8 = 55;
    public static final int APC_KNOB_MASTER_LEVEL = 56;
    public static final int[] APC_BUTTONS_ALL = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 82, 83, 84, 85, 86, 87, 88, 89, 98};
    public static final int APC_BUTTON_STATE_OFF = 0;
    public static final int APC_BUTTON_STATE_ON = 1;
    public static final int APC_BUTTON_STATE_BLINK = 2;
    public static final int TRACK_STATE_CLIP_STOP = 0;
    public static final int TRACK_STATE_SOLO = 1;
    public static final int TRACK_STATE_REC_ARM = 2;
    public static final int TRACK_STATE_MUTE = 3;
    public static final int TRACK_STATE_SELECT = 4;
    private int trackState = 0;

    public APCminiControlSurface(IHost host, ColorManager colorManager, APCminiConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, APC_BUTTONS_ALL);
        this.shiftButtonId = 98;
        for (int i = 0; i < 64; ++i) {
            this.gridNotes[i] = i;
        }
        this.pads = new APCminiPadGrid(colorManager, this);
    }

    @Override
    public void shutdown() {
        for (int button : this.getButtons()) {
            this.setButton(button, 0);
        }
        this.pads.turnOff();
    }

    @Override
    public void setButton(int button, int state) {
        this.output.sendNote(button, state);
    }

    @Override
    public void setButtonEx(int button, int channel, int state) {
        this.output.sendNoteEx(channel, button, state);
    }

    @Override
    protected void handleGridNote(int note, int velocity) {
        super.handleGridNote(this.pads.translateToGrid(note), velocity);
    }

    public int getTrackState() {
        return this.trackState;
    }

    public void setTrackState(int trackState) {
        this.trackState = trackState;
    }
}

