/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.command.trigger.ShiftCommand;
import de.mossgrabers.controller.apcmini.command.trigger.TrackSelectCommand;
import de.mossgrabers.controller.apcmini.controller.APCminiColors;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.controller.APCminiScales;
import de.mossgrabers.controller.apcmini.mode.DeviceMode;
import de.mossgrabers.controller.apcmini.mode.Modes;
import de.mossgrabers.controller.apcmini.mode.PanMode;
import de.mossgrabers.controller.apcmini.mode.SendMode;
import de.mossgrabers.controller.apcmini.mode.VolumeMode;
import de.mossgrabers.controller.apcmini.view.BrowserView;
import de.mossgrabers.controller.apcmini.view.DrumView;
import de.mossgrabers.controller.apcmini.view.PlayView;
import de.mossgrabers.controller.apcmini.view.RaindropsView;
import de.mossgrabers.controller.apcmini.view.SequencerView;
import de.mossgrabers.controller.apcmini.view.SessionView;
import de.mossgrabers.controller.apcmini.view.ShiftView;
import de.mossgrabers.controller.apcmini.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.SceneCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.continuous.MasterFaderAbsoluteCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class APCminiControllerSetup
extends AbstractControllerSetup<APCminiControlSurface, APCminiConfiguration> {
    public APCminiControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings) {
        super(factory, host, settings);
        this.colorManager = new ColorManager();
        APCminiColors.addColors(this.colorManager);
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new APCminiConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateButtons();
    }

    @Override
    protected void createScales() {
        this.scales = new APCminiScales(this.valueChanger, 36, 100, 8, 8);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, true, -1, -1, -1, -1);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addTrackSelectionObserver(this::handleTrackChange);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Akai APCmini", new String[0]);
        APCminiControlSurface surface = new APCminiControlSurface(this.model.getHost(), this.colorManager, (APCminiConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
        surface.setDisplay(new DummyDisplay(this.host));
    }

    @Override
    protected void createObservers() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        surface.getViewManager().addViewChangeListener((previousViewId, activeViewId) -> this.updateMode(null));
        surface.getModeManager().addModeListener((previousModeId, activeModeId) -> this.updateMode(activeModeId));
        this.createScaleObservers(this.configuration);
        ((APCminiConfiguration)this.configuration).addSettingObserver(APCminiConfiguration.FADER_CTRL, () -> {
            ModeManager modeManager = surface.getModeManager();
            switch (((APCminiConfiguration)this.configuration).getFaderCtrl()) {
                case "Volume": {
                    modeManager.setActiveMode(Modes.MODE_VOLUME);
                    break;
                }
                case "Pan": {
                    modeManager.setActiveMode(Modes.MODE_PAN);
                    break;
                }
                case "Send 1": {
                    modeManager.setActiveMode(Modes.MODE_SEND1);
                    break;
                }
                case "Send 2": {
                    modeManager.setActiveMode(Modes.MODE_SEND2);
                    break;
                }
                case "Send 3": {
                    modeManager.setActiveMode(Modes.MODE_SEND3);
                    break;
                }
                case "Send 4": {
                    modeManager.setActiveMode(Modes.MODE_SEND4);
                    break;
                }
                case "Send 5": {
                    modeManager.setActiveMode(Modes.MODE_SEND5);
                    break;
                }
                case "Send 6": {
                    modeManager.setActiveMode(Modes.MODE_SEND6);
                    break;
                }
                case "Send 7": {
                    modeManager.setActiveMode(Modes.MODE_SEND7);
                    break;
                }
                case "Send 8": {
                    modeManager.setActiveMode(Modes.MODE_SEND8);
                    break;
                }
                case "Device": {
                    modeManager.setActiveMode(Modes.MODE_DEVICE);
                }
            }
        });
        ((APCminiConfiguration)this.configuration).addSettingObserver(APCminiConfiguration.SOFT_KEYS, () -> {
            for (int i = 0; i < APCminiConfiguration.SOFT_KEYS_OPTIONS.length; ++i) {
                String opt = APCminiConfiguration.SOFT_KEYS_OPTIONS[i];
                if (!opt.equals(((APCminiConfiguration)this.configuration).getSoftKeys())) continue;
                surface.setTrackState(i);
            }
        });
    }

    @Override
    protected void createModes() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PAN, new PanMode(surface, this.model));
        for (int i = 0; i < 8; ++i) {
            modeManager.registerMode(Modes.MODE_SEND1 + i, new SendMode(i, surface, this.model));
        }
        modeManager.registerMode(Modes.MODE_DEVICE, new DeviceMode(surface, this.model));
        modeManager.setDefaultMode(Modes.MODE_VOLUME);
    }

    @Override
    protected void createViews() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        viewManager.registerView(Views.VIEW_SHIFT, new ShiftView(surface, this.model));
        viewManager.registerView(Views.VIEW_BROWSER, new BrowserView(surface, this.model));
        if (this.host.hasClips()) {
            viewManager.registerView(Views.VIEW_SESSION, new SessionView(surface, this.model));
            viewManager.registerView(Views.VIEW_SEQUENCER, new SequencerView(surface, this.model));
            viewManager.registerView(Views.VIEW_DRUM, new DrumView(surface, this.model));
            viewManager.registerView(Views.VIEW_RAINDROPS, new RaindropsView(surface, this.model));
        }
    }

    @Override
    protected void registerTriggerCommands() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        this.addNoteCommand(Commands.COMMAND_SHIFT, 98, new ShiftCommand(this.model, surface));
        for (int i = 0; i < 8; ++i) {
            this.addNoteCommand(Commands.COMMAND_ROW_SELECT_1 + i, 64 + i, new TrackSelectCommand(i, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE1 + i, 82 + i, new SceneCommand(7 - i, this.model, surface));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        this.addContinuousCommand(Commands.CONT_COMMAND_MASTER_KNOB, 56, new MasterFaderAbsoluteCommand(this.model, surface));
        for (int i = 0; i < 8; ++i) {
            Integer knobCommand = Commands.CONT_COMMAND_FADER1 + i;
            this.addContinuousCommand(knobCommand, 48 + i, new KnobRowModeCommand(i, this.model, surface));
        }
    }

    @Override
    public void startup() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        surface.getModeManager().setActiveMode(Modes.MODE_VOLUME);
        surface.getViewManager().setActiveView(Views.VIEW_PLAY);
    }

    private void updateButtons() {
        View activeView = ((APCminiControlSurface)this.getSurface()).getViewManager().getActiveView();
        if (activeView != null) {
            ((SceneView)((Object)activeView)).updateSceneButtons();
        }
    }

    private void updateMode(Integer mode) {
        this.updateIndication(mode == null ? ((APCminiControlSurface)this.getSurface()).getModeManager().getActiveModeId() : mode);
    }

    private void updateIndication(Integer mode) {
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        boolean isShiftView = viewManager.isActiveView(Views.VIEW_SHIFT);
        boolean isSession = viewManager.isActiveView(Views.VIEW_SESSION) || isShiftView;
        boolean isEffect = this.model.isEffectTrackBankActive();
        boolean isPan = Modes.MODE_PAN.equals(mode);
        boolean isDevice = Modes.MODE_DEVICE.equals(mode);
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect);
            track.setPanIndication(!isEffect && isPan);
            for (int j = 0; j < 8; ++j) {
                track.getSend(j).setIndication(!isEffect && (Modes.MODE_SEND1.equals(mode) && j == 0 || Modes.MODE_SEND2.equals(mode) && j == 1 || Modes.MODE_SEND3.equals(mode) && j == 2 || Modes.MODE_SEND4.equals(mode) && j == 3 || Modes.MODE_SEND5.equals(mode) && j == 4 || Modes.MODE_SEND6.equals(mode) && j == 5 || Modes.MODE_SEND7.equals(mode) && j == 6 || Modes.MODE_SEND8.equals(mode) && j == 7));
            }
            if (tbe != null) {
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect);
                fxTrack.setPanIndication(isEffect && isPan);
            }
            cursorDevice.indicateParameter(i, isDevice || isShiftView);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        this.scales.setDrumOctave(0);
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.getView(Views.VIEW_DRUM).updateNoteMapping();
        }
    }
}

