/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IValueChanger;

public class APCminiConfiguration
extends AbstractConfiguration {
    public static final Integer FADER_CTRL = 30;
    public static final Integer SOFT_KEYS = 31;
    private static final String[] FADER_CTRL_OPTIONS = new String[]{"Volume", "Pan", "Send 1", "Send 2", "Send 3", "Send 4", "Send 5", "Send 6", "Send 7", "Send 8", "Device"};
    public static final String[] SOFT_KEYS_OPTIONS = new String[]{"Clip Stop", "Solo", "Rec Arm", "Mute", "Select"};
    private String faderCtrl = FADER_CTRL_OPTIONS[0];
    private String softKeys = SOFT_KEYS_OPTIONS[0];
    private IEnumSetting faderCtrlSetting;
    private IEnumSetting softKeysSetting;

    public APCminiConfiguration(IValueChanger valueChanger) {
        super(valueChanger);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        this.activateQuantizeAmountSetting(settingsUI);
        this.activateScaleSetting(settingsUI);
        this.activateScaleBaseSetting(settingsUI);
        this.activateScaleInScaleSetting(settingsUI);
        this.activateScaleLayoutSetting(settingsUI);
        this.activateBehaviourOnStopSetting(settingsUI);
        this.activateSelectClipOnLaunchSetting(settingsUI);
        this.activateNewClipLengthSetting(settingsUI);
        this.faderCtrlSetting = settingsUI.getEnumSetting("Fader Ctrl", "Button Control", FADER_CTRL_OPTIONS, FADER_CTRL_OPTIONS[0]);
        this.faderCtrlSetting.addValueObserver(value -> {
            this.faderCtrl = value;
            this.notifyObservers(FADER_CTRL);
        });
        this.softKeysSetting = settingsUI.getEnumSetting("Soft Keys", "Button Control", SOFT_KEYS_OPTIONS, SOFT_KEYS_OPTIONS[0]);
        this.softKeysSetting.addValueObserver(value -> {
            this.softKeys = value;
            this.notifyObservers(SOFT_KEYS);
        });
    }

    public void setFaderCtrl(String faderCtrl) {
        this.faderCtrlSetting.set(faderCtrl);
    }

    public void setSoftKeys(String softKeys) {
        this.softKeysSetting.set(softKeys);
    }

    public String getFaderCtrl() {
        return this.faderCtrl;
    }

    public String getSoftKeys() {
        return this.softKeys;
    }
}

