/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.view;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.command.trigger.APCBrowserCommand;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.ViewManager;

public class ShiftView
extends AbstractView<APCControlSurface, APCConfiguration>
implements SceneView {
    private static final int[] TRANSLATE = new int[]{0, 2, 4, 6, 1, 3, 5, -1, -1, 10, 8, -1, 11, 9, 7, -1};

    public ShiftView(APCControlSurface surface, IModel model) {
        super("Shift", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        PadGrid padGrid = ((APCControlSurface)this.surface).getPadGrid();
        for (i = 7; i < 64; ++i) {
            padGrid.light(36 + i, 0);
        }
        for (i = 0; i < 3; ++i) {
            padGrid.light(68 + i, "COLOR_KEY_WHITE");
        }
        padGrid.light(71, "COLOR_KEY_SELECTED");
        padGrid.light(72, "COLOR_KEY_SELECTED");
        padGrid.light(74, "COLOR_KEY_BLACK");
        padGrid.light(75, "COLOR_KEY_BLACK");
        int scaleOffset = this.model.getScales().getScaleOffset();
        padGrid.light(36, scaleOffset == 0 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(37, scaleOffset == 2 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(38, scaleOffset == 4 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(39, scaleOffset == 6 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(40, scaleOffset == 1 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(41, scaleOffset == 3 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(42, scaleOffset == 5 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(45, scaleOffset == 10 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(46, scaleOffset == 8 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(48, scaleOffset == 11 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(49, scaleOffset == 9 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(50, scaleOffset == 7 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        if (index > 15) {
            switch (index) {
                case 32: {
                    this.model.getApplication().addInstrumentTrack();
                    break;
                }
                case 33: {
                    this.model.getApplication().addAudioTrack();
                    break;
                }
                case 34: {
                    this.model.getApplication().addEffectTrack();
                    break;
                }
                case 35: 
                case 36: {
                    APCBrowserCommand browseCommand = (APCBrowserCommand)((APCControlSurface)this.surface).getViewManager().getActiveView().getTriggerCommand(Commands.COMMAND_BROWSE);
                    browseCommand.startBrowser(true, index == 35);
                    break;
                }
                case 38: {
                    this.model.getApplication().undo();
                    break;
                }
                case 39: {
                    this.model.getApplication().redo();
                }
            }
            return;
        }
        int pos = TRANSLATE[index];
        if (pos == -1) {
            return;
        }
        this.model.getScales().setScaleOffset(pos);
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleBase(Scales.BASES[pos]);
        ((APCControlSurface)this.surface).getDisplay().notify(Scales.BASES[pos]);
        ((APCControlSurface)this.surface).getViewManager().getActiveView().updateNoteMapping();
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (!this.model.getHost().hasClips()) {
            return;
        }
        Integer viewID = Views.VIEW_SESSION + scene;
        ViewManager viewManager = ((APCControlSurface)this.surface).getViewManager();
        viewManager.setActiveView(viewID);
        ((APCControlSurface)this.surface).getDisplay().notify(viewManager.getView(viewID).getName());
        if (Views.VIEW_SESSION.equals(viewID)) {
            return;
        }
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack != null) {
            viewManager.setPreferredView(selectedTrack.getPosition(), viewID);
        }
    }

    @Override
    public void updateSceneButtons() {
        if (!this.model.getHost().hasClips()) {
            ((APCControlSurface)this.surface).updateButton(82, 0);
            ((APCControlSurface)this.surface).updateButton(83, 0);
            ((APCControlSurface)this.surface).updateButton(84, 0);
            ((APCControlSurface)this.surface).updateButton(85, 0);
            ((APCControlSurface)this.surface).updateButton(86, 0);
            return;
        }
        Integer previousViewId = ((APCControlSurface)this.surface).getViewManager().getPreviousViewId();
        ((APCControlSurface)this.surface).updateButton(82, previousViewId == Views.VIEW_SESSION ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED");
        ((APCControlSurface)this.surface).updateButton(83, previousViewId == Views.VIEW_PLAY ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED");
        ((APCControlSurface)this.surface).updateButton(84, previousViewId == Views.VIEW_DRUM ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED");
        ((APCControlSurface)this.surface).updateButton(85, previousViewId == Views.VIEW_SEQUENCER ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED");
        ((APCControlSurface)this.surface).updateButton(86, previousViewId == Views.VIEW_RAINDROPS ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED");
    }
}

