/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.view;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.SessionColor;

public class SessionView
extends AbstractSessionView<APCControlSurface, APCConfiguration> {
    public SessionView(APCControlSurface surface, IModel model) {
        super("Session", surface, model, 5, 8, surface.isMkII());
        if (surface.isMkII()) {
            SessionColor isRecording = new SessionColor(5, 5, false);
            SessionColor isRecordingQueued = new SessionColor(5, 5, true);
            SessionColor isPlaying = new SessionColor(21, 21, false);
            SessionColor isPlayingQueued = new SessionColor(21, 21, true);
            SessionColor hasContent = new SessionColor(10, -1, false);
            SessionColor noContent = new SessionColor(0, -1, false);
            SessionColor recArmed = new SessionColor(7, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
        } else {
            SessionColor isRecording = new SessionColor(3, -1, false);
            SessionColor isRecordingQueued = new SessionColor(3, 4, false);
            SessionColor isPlaying = new SessionColor(1, -1, false);
            SessionColor isPlayingQueued = new SessionColor(1, 2, false);
            SessionColor hasContent = new SessionColor(5, -1, false);
            SessionColor noContent = new SessionColor(0, -1, false);
            SessionColor recArmed = new SessionColor(0, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getCurrentTrackBank().launchScene(scene);
            ((APCControlSurface)this.surface).updateButton(82 + scene, "BUTTON_STATE_ON");
        } else if (event == ButtonEvent.UP) {
            ((APCControlSurface)this.surface).updateButton(82 + scene, "BUTTON_STATE_OFF");
        }
    }

    @Override
    public void updateSceneButtons() {
        int green = ((APCControlSurface)this.surface).isMkII() ? 22 : 1;
        ((APCControlSurface)this.surface).updateButton(82, green);
        ((APCControlSurface)this.surface).updateButton(83, green);
        ((APCControlSurface)this.surface).updateButton(84, green);
        ((APCControlSurface)this.surface).updateButton(85, green);
        ((APCControlSurface)this.surface).updateButton(86, green);
    }
}

