/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.view;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<APCControlSurface, APCConfiguration> {
    public SequencerView(APCControlSurface surface, IModel model) {
        super("Sequencer", surface, model, surface.isMkII());
        this.numDisplayRows = 5;
        this.numSequencerRows = 4;
    }

    @Override
    public void updateSceneButtons() {
        ((APCControlSurface)this.surface).updateButton(82, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(83, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(84, "BUTTON_STATE_OFF");
        ((APCControlSurface)this.surface).updateButton(85, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(86, "BUTTON_STATE_ON");
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (scene) {
            case 0: {
                Scales scales = this.model.getScales();
                scales.nextScale();
                String name = scales.getScale().getName();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScale(name);
                ((APCControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case 1: {
                Scales scales = this.model.getScales();
                scales.prevScale();
                String name = scales.getScale().getName();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScale(name);
                ((APCControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case 2: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case 3: {
                this.onOctaveUp(event);
                break;
            }
            case 4: {
                this.onOctaveDown(event);
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }
}

