/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.view;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.SceneView;

public class PlayView
extends AbstractPlayView<APCControlSurface, APCConfiguration>
implements SceneView {
    public PlayView(APCControlSurface surface, IModel model) {
        super("Play", surface, model, surface.isMkII());
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || this.noteMap[note] == -1) {
            return;
        }
        this.setPressedKeys(this.noteMap[note], velocity);
        ((APCControlSurface)this.surface).sendMidiEvent(144, this.noteMap[note], velocity);
    }

    @Override
    public void updateSceneButtons() {
        ((APCControlSurface)this.surface).updateButton(82, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(83, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(84, "BUTTON_STATE_OFF");
        ((APCControlSurface)this.surface).updateButton(85, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(86, "BUTTON_STATE_ON");
    }

    @Override
    public void updateArrows() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack sel = tb.getSelectedTrack();
        this.canScrollLeft = sel != null && sel.getIndex() > 0 || tb.canScrollTracksUp();
        this.canScrollRight = sel != null && sel.getIndex() < 7 || tb.canScrollTracksDown();
        super.updateArrows();
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (scene) {
            case 0: {
                this.scales.nextScale();
                this.updateScale();
                break;
            }
            case 1: {
                this.scales.prevScale();
                this.updateScale();
                break;
            }
            case 2: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case 3: {
                this.onOctaveUp(event);
                break;
            }
            case 4: {
                this.onOctaveDown(event);
            }
        }
        this.updateNoteMapping();
    }

    private void updateScale() {
        String name = this.scales.getScale().getName();
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScale(name);
        ((APCControlSurface)this.surface).getDisplay().notify(name);
    }
}

