/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.view;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrumView;

public class DrumView
extends AbstractDrumView<APCControlSurface, APCConfiguration> {
    public DrumView(APCControlSurface surface, IModel model) {
        super("Drum", surface, model, 2, 3);
    }

    @Override
    protected String getPadContentColor(IChannel drumPad) {
        return ((APCControlSurface)this.surface).isMkII() ? DAWColors.getColorIndex(drumPad.getColor()) : "COLOR_PAD_HAS_CONTENT";
    }

    @Override
    public void playNote(int note, int velocity) {
        ((APCControlSurface)this.surface).sendMidiEvent(144, note, velocity);
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 3: {
                this.onOctaveUp(event);
                break;
            }
            case 4: {
                this.onOctaveDown(event);
                break;
            }
        }
    }

    @Override
    public void updateSceneButtons() {
        ((APCControlSurface)this.surface).updateButton(82, "BUTTON_STATE_OFF");
        ((APCControlSurface)this.surface).updateButton(83, "BUTTON_STATE_OFF");
        ((APCControlSurface)this.surface).updateButton(84, "BUTTON_STATE_OFF");
        ((APCControlSurface)this.surface).updateButton(85, "BUTTON_STATE_ON");
        ((APCControlSurface)this.surface).updateButton(86, "BUTTON_STATE_ON");
    }
}

