/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.mode;

import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.mode.BaseMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class CrossfadeMode
extends BaseMode {
    public CrossfadeMode(APCControlSurface surface, IModel model) {
        super(surface, model, 3, 64);
    }

    @Override
    public void setValue(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).setPan(value);
    }

    @Override
    public Integer getValue(int index) {
        ITrack track = this.model.getCurrentTrackBank().getTrack(index);
        if (!track.doesExist()) {
            return null;
        }
        String crossfadeMode = track.getCrossfadeMode();
        if ("A".equals(crossfadeMode)) {
            return 0;
        }
        if ("B".equals(crossfadeMode)) {
            return 127;
        }
        return 64;
    }
}

