/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.mode;

import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.mode.BaseMode;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;

public class BrowserMode
extends BaseMode {
    private static final int[] COLUMN_ORDER = new int[]{0, 6, 1, 2, 3, 4, 5};
    private int lastValue;

    public BrowserMode(APCControlSurface surface, IModel model) {
        super(surface, model, 0, 0);
    }

    @Override
    public void setValue(int index, int value) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        int diff = value - this.lastValue;
        boolean isLeft = value == 0 || diff < 0;
        this.lastValue = value;
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (isLeft) {
                    browser.selectPreviousFilterItem(COLUMN_ORDER[index]);
                    break;
                }
                browser.selectNextFilterItem(COLUMN_ORDER[index]);
                break;
            }
            case 7: {
                if (isLeft) {
                    browser.selectPreviousResult();
                    break;
                }
                browser.selectNextResult();
            }
        }
    }
}

