/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.mode;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Date;

public abstract class BaseMode
extends AbstractMode<APCControlSurface, APCConfiguration> {
    private boolean isKnobMoving;
    private long moveStartTime;
    private int defaultValue;
    private int ledMode;

    public BaseMode(APCControlSurface surface, IModel model, int ledMode, int defaultValue) {
        super(surface, model);
        this.isTemporary = false;
        this.ledMode = ledMode;
        this.defaultValue = defaultValue;
        this.isKnobMoving = false;
        this.moveStartTime = 0L;
    }

    public abstract void setValue(int var1, int var2);

    public Integer getValue(int index) {
        return null;
    }

    @Override
    public void onActivate() {
        for (int i = 0; i < 8; ++i) {
            ((APCControlSurface)this.surface).setLED(56 + i, this.ledMode);
        }
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.setValue(index, value);
        this.moveStartTime = new Date().getTime();
        if (this.isKnobMoving) {
            return;
        }
        this.isKnobMoving = true;
        this.startCheckKnobMovement();
    }

    @Override
    public void updateDisplay() {
        if (this.isKnobMoving) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Integer value = this.getValue(i);
            ((APCControlSurface)this.surface).setLED(48 + i, value == null ? this.defaultValue : value);
        }
    }

    protected void startCheckKnobMovement() {
        ((APCControlSurface)this.surface).scheduleTask(this::checkKnobMovement, 100L);
    }

    protected void checkKnobMovement() {
        if (!this.isKnobMoving) {
            return;
        }
        if (new Date().getTime() - this.moveStartTime > 200L) {
            this.isKnobMoving = false;
        } else {
            this.startCheckKnobMovement();
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

