/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.controller;

import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;

public class APCPadGrid
extends PadGridImpl {
    private final APCControlSurface surface;

    public APCPadGrid(ColorManager colorManager, APCControlSurface surface) {
        super(colorManager, surface.getOutput());
        this.surface = surface;
    }

    @Override
    public void lightEx(int x, int y, int color, int blinkColor, boolean fast) {
        this.setLight(68 + x - 8 * y, color, blinkColor, fast);
    }

    @Override
    protected void sendNoteState(int note, int color) {
        int i = note - 36;
        if (this.surface.isMkII()) {
            this.output.sendNote(i, color);
        } else {
            int x = i % 8;
            int y = 4 - i / 8;
            this.output.sendNoteEx(x, 53 + y, color);
        }
    }

    @Override
    protected void sendBlinkState(int note, int blinkColor, boolean fast) {
        int i = note - 36;
        if (this.surface.isMkII()) {
            this.output.sendNoteEx(fast ? 12 : 10, i, blinkColor);
        } else {
            int x = i % 8;
            int y = 4 - i / 8;
            this.output.sendNoteEx(x, 53 + y, blinkColor);
        }
    }
}

