/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.controller;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;
import java.util.Arrays;

public class APCControlSurface
extends AbstractControlSurface<APCConfiguration> {
    public static final int APC_BUTTON_RECORD_ARM = 48;
    public static final int APC_BUTTON_SOLO = 49;
    public static final int APC_BUTTON_ACTIVATOR = 50;
    public static final int APC_BUTTON_TRACK_SELECTION = 51;
    public static final int APC_BUTTON_CLIP_STOP = 52;
    public static final int APC_BUTTON_CLIP_LAUNCH_1 = 53;
    public static final int APC_BUTTON_CLIP_LAUNCH_2 = 54;
    public static final int APC_BUTTON_CLIP_LAUNCH_3 = 55;
    public static final int APC_BUTTON_CLIP_LAUNCH_4 = 56;
    public static final int APC_BUTTON_CLIP_LAUNCH_5 = 57;
    public static final int APC_BUTTON_CLIP_TRACK = 58;
    public static final int APC_BUTTON_DEVICE_ON_OFF = 59;
    public static final int APC_BUTTON_DEVICE_LEFT = 60;
    public static final int APC_BUTTON_DEVICE_RIGHT = 61;
    public static final int APC_BUTTON_DETAIL_VIEW = 62;
    public static final int APC_BUTTON_REC_QUANT = 63;
    public static final int APC_BUTTON_MIDI_OVERDUB = 64;
    public static final int APC_BUTTON_METRONOME = 65;
    public static final int APC_BUTTON_A_B = 66;
    public static final int APC_BUTTON_MASTER = 80;
    public static final int APC_BUTTON_STOP_ALL_CLIPS = 81;
    public static final int APC_BUTTON_SCENE_LAUNCH_1 = 82;
    public static final int APC_BUTTON_SCENE_LAUNCH_2 = 83;
    public static final int APC_BUTTON_SCENE_LAUNCH_3 = 84;
    public static final int APC_BUTTON_SCENE_LAUNCH_4 = 85;
    public static final int APC_BUTTON_SCENE_LAUNCH_5 = 86;
    public static final int APC_BUTTON_PAN = 87;
    public static final int APC_BUTTON_SEND_A = 88;
    public static final int APC_BUTTON_SEND_B = 89;
    public static final int APC_BUTTON_SEND_C = 90;
    public static final int APC_BUTTON_PLAY = 91;
    public static final int APC_BUTTON_STOP = 92;
    public static final int APC_BUTTON_RECORD = 93;
    public static final int APC_BUTTON_UP = 94;
    public static final int APC_BUTTON_DOWN = 95;
    public static final int APC_BUTTON_RIGHT = 96;
    public static final int APC_BUTTON_LEFT = 97;
    public static final int APC_BUTTON_SHIFT = 98;
    public static final int APC_BUTTON_TAP_TEMPO = 99;
    public static final int APC_BUTTON_NUDGE_PLUS = 100;
    public static final int APC_BUTTON_NUDGE_MINUS = 101;
    public static final int APC_BUTTON_SESSION = 102;
    public static final int APC_BUTTON_BANK = 103;
    public static final int APC_KNOB_TRACK_LEVEL = 7;
    public static final int APC_KNOB_TEMPO = 13;
    public static final int APC_KNOB_MASTER_LEVEL = 14;
    public static final int APC_KNOB_CROSSFADER = 15;
    public static final int APC_KNOB_DEVICE_KNOB_1 = 16;
    public static final int APC_KNOB_DEVICE_KNOB_2 = 17;
    public static final int APC_KNOB_DEVICE_KNOB_3 = 18;
    public static final int APC_KNOB_DEVICE_KNOB_4 = 19;
    public static final int APC_KNOB_DEVICE_KNOB_5 = 20;
    public static final int APC_KNOB_DEVICE_KNOB_6 = 21;
    public static final int APC_KNOB_DEVICE_KNOB_7 = 22;
    public static final int APC_KNOB_DEVICE_KNOB_8 = 23;
    public static final int APC_KNOB_DEVICE_KNOB_LED_1 = 24;
    public static final int APC_KNOB_DEVICE_KNOB_LED_2 = 25;
    public static final int APC_KNOB_DEVICE_KNOB_LED_3 = 26;
    public static final int APC_KNOB_DEVICE_KNOB_LED_4 = 27;
    public static final int APC_KNOB_DEVICE_KNOB_LED_5 = 28;
    public static final int APC_KNOB_DEVICE_KNOB_LED_6 = 29;
    public static final int APC_KNOB_DEVICE_KNOB_LED_7 = 30;
    public static final int APC_KNOB_DEVICE_KNOB_LED_8 = 31;
    public static final int APC_KNOB_CUE_LEVEL = 47;
    public static final int APC_KNOB_TRACK_KNOB_1 = 48;
    public static final int APC_KNOB_TRACK_KNOB_2 = 49;
    public static final int APC_KNOB_TRACK_KNOB_3 = 50;
    public static final int APC_KNOB_TRACK_KNOB_4 = 51;
    public static final int APC_KNOB_TRACK_KNOB_5 = 52;
    public static final int APC_KNOB_TRACK_KNOB_6 = 53;
    public static final int APC_KNOB_TRACK_KNOB_7 = 54;
    public static final int APC_KNOB_TRACK_KNOB_8 = 55;
    public static final int APC_KNOB_TRACK_KNOB_LED_1 = 56;
    public static final int APC_KNOB_TRACK_KNOB_LED_2 = 57;
    public static final int APC_KNOB_TRACK_KNOB_LED_3 = 58;
    public static final int APC_KNOB_TRACK_KNOB_LED_4 = 59;
    public static final int APC_KNOB_TRACK_KNOB_LED_5 = 60;
    public static final int APC_KNOB_TRACK_KNOB_LED_6 = 61;
    public static final int APC_KNOB_TRACK_KNOB_LED_7 = 62;
    public static final int APC_KNOB_TRACK_KNOB_LED_8 = 63;
    public static final int APC_FOOTSWITCH_1 = 64;
    public static final int APC_FOOTSWITCH_2 = 67;
    public static final int[] APC_BUTTONS_ALL = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final boolean[] APC_BUTTON_UPDATE = new boolean[128];
    private static final String ID_APC_40 = "73";
    private static final String ID_APC_40_MKII = "29";
    private boolean isMkII;

    public APCControlSurface(IHost host, ColorManager colorManager, APCConfiguration configuration, IMidiOutput output, IMidiInput input, boolean isMkII) {
        super(host, configuration, colorManager, output, input, APC_BUTTONS_ALL);
        this.isMkII = isMkII;
        this.shiftButtonId = 98;
        this.leftButtonId = 97;
        this.rightButtonId = 96;
        this.upButtonId = 94;
        this.downButtonId = 95;
        this.pads = new APCPadGrid(colorManager, this);
        this.output.sendSysex("F0 47 7F " + (isMkII ? ID_APC_40_MKII : ID_APC_40) + " 60 00 04 41 08 02 01 F7");
    }

    public boolean isMkII() {
        return this.isMkII;
    }

    @Override
    public boolean isGridNote(int note) {
        return note <= 39 && super.isGridNote(36 + note);
    }

    @Override
    protected void handleGridNote(int note, int velocity) {
        super.handleGridNote(36 + note, velocity);
    }

    @Override
    public int getSceneButton(int index) {
        return 82 + index;
    }

    @Override
    public void shutdown() {
        for (int button : this.getButtons()) {
            this.setButton(button, 0);
        }
        this.pads.turnOff();
    }

    @Override
    public void setButton(int button, int state) {
        this.output.sendNote(button, state);
    }

    @Override
    public void setButtonEx(int button, int channel, int state) {
        this.output.sendNoteEx(channel, button, state);
    }

    public void setLED(int knob, int value) {
        this.output.sendCC(knob, value);
    }

    public boolean shouldUpdateButton(int button) {
        return APC_BUTTON_UPDATE[button];
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 128: 
            case 144: {
                int note = data1;
                if (!this.isMkII && data1 >= 53 && data1 <= 57) {
                    note = (4 - (data1 - 53)) * 8 + channel;
                }
                if (this.isGridNote(note)) {
                    this.handleGridNote(note, code == 128 ? 0 : data2);
                    break;
                }
                this.handleCC(channel, note, code == 128 ? 0 : data2);
                break;
            }
            case 176: {
                View view = this.viewManager.getActiveView();
                if (view == null) {
                    return;
                }
                Integer commandID = this.getContinuousCommand(data1, channel);
                if (commandID != null) {
                    view.executeContinuousCommand(commandID, data2);
                }
                if (data1 != 67) break;
                view.executeTriggerCommand(this.getTriggerCommand(67), data2 > 0 ? ButtonEvent.DOWN : ButtonEvent.UP);
                break;
            }
            default: {
                this.host.println("Unhandled midi status: " + status);
            }
        }
    }

    static {
        Arrays.fill(APC_BUTTON_UPDATE, true);
        APCControlSurface.APC_BUTTON_UPDATE[48] = false;
        APCControlSurface.APC_BUTTON_UPDATE[49] = false;
        APCControlSurface.APC_BUTTON_UPDATE[50] = false;
        APCControlSurface.APC_BUTTON_UPDATE[51] = false;
        APCControlSurface.APC_BUTTON_UPDATE[58] = false;
        APCControlSurface.APC_BUTTON_UPDATE[59] = false;
        APCControlSurface.APC_BUTTON_UPDATE[60] = false;
        APCControlSurface.APC_BUTTON_UPDATE[61] = false;
        APCControlSurface.APC_BUTTON_UPDATE[62] = false;
        APCControlSurface.APC_BUTTON_UPDATE[63] = false;
        APCControlSurface.APC_BUTTON_UPDATE[64] = false;
        APCControlSurface.APC_BUTTON_UPDATE[65] = false;
        APCControlSurface.APC_BUTTON_UPDATE[66] = false;
        APCControlSurface.APC_BUTTON_UPDATE[80] = false;
        APCControlSurface.APC_BUTTON_UPDATE[87] = false;
        APCControlSurface.APC_BUTTON_UPDATE[88] = false;
        APCControlSurface.APC_BUTTON_UPDATE[89] = false;
        APCControlSurface.APC_BUTTON_UPDATE[90] = false;
        APCControlSurface.APC_BUTTON_UPDATE[91] = false;
        APCControlSurface.APC_BUTTON_UPDATE[93] = false;
        APCControlSurface.APC_BUTTON_UPDATE[102] = false;
        APCControlSurface.APC_BUTTON_UPDATE[103] = false;
    }
}

