/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.command.trigger;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SendCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    private int sendIndex;

    public SendCommand(int sendIndex, IModel model, APCControlSurface surface) {
        super(model, surface);
        this.sendIndex = sendIndex;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        this.handleExecute(event, this.sendIndex);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        this.handleExecute(event, this.sendIndex + 3);
    }

    private void handleExecute(ButtonEvent event, int index) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.model.isEffectTrackBankActive()) {
            return;
        }
        ((APCControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SEND1 + index);
        ((APCControlSurface)this.surface).getDisplay().notify("Send " + (index + 1));
    }
}

