/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.command.trigger;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SelectCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    private int index;

    public SelectCommand(int index, IModel model, APCControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((APCControlSurface)this.surface).isPressed(88)) {
            ((APCControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SEND1 + this.index);
            ((APCControlSurface)this.surface).getDisplay().notify("Send " + (this.index + 1));
            return;
        }
        this.model.getCurrentTrackBank().getTrack(this.index).selectAndMakeVisible();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ((APCControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[this.index]);
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setNewClipLength(this.index);
    }
}

