/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.command.trigger;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DeviceRightCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    public DeviceRightCommand(IModel model, APCControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel sel = cd.getSelectedLayer();
        if (!cd.hasLayers() || sel == null) {
            cd.selectNext();
        } else {
            int index = sel.getIndex() + 1;
            cd.selectLayer(index > 7 ? 7 : index);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasLayers()) {
            return;
        }
        IChannel layer = cd.getSelectedLayerOrDrumPad();
        if (layer == null) {
            cd.selectLayerOrDrumPad(0);
        } else {
            IChannel dl = cd.getSelectedLayer();
            if (dl != null) {
                int index = dl.getIndex();
                cd.enterLayer(index);
                cd.selectFirstDeviceInLayer(index);
            }
        }
    }
}

