/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.command.trigger;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DeviceLeftCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    public DeviceLeftCommand(IModel model, APCControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getSelectedLayerOrDrumPad();
        if (!cd.hasLayers() || layer == null) {
            cd.selectPrevious();
        } else {
            cd.selectLayer(layer.getIndex() == 0 ? 0 : layer.getIndex() - 1);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        IChannel layer = cd.getSelectedLayerOrDrumPad();
        if (!cd.hasLayers() || layer == null) {
            if (cd.isNested()) {
                cd.selectParent();
                cd.selectChannel();
            }
        } else {
            layer.setSelected(false);
        }
    }
}

