/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc.command.continuous;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import java.util.Date;

public class DeviceKnobRowCommand
extends AbstractContinuousCommand<APCControlSurface, APCConfiguration> {
    private int index;
    private long moveStartTime;
    private boolean isKnobMoving;

    public DeviceKnobRowCommand(int index, IModel model, APCControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.doesExist()) {
            return;
        }
        cd.setParameter(this.index, value);
        this.moveStartTime = new Date().getTime();
        if (this.isKnobMoving) {
            return;
        }
        this.isKnobMoving = true;
        this.startCheckKnobMovement();
    }

    public boolean isKnobMoving() {
        return this.isKnobMoving;
    }

    private void checkKnobMovement() {
        if (!this.isKnobMoving) {
            return;
        }
        if (new Date().getTime() - this.moveStartTime > 200L) {
            this.isKnobMoving = false;
        } else {
            this.startCheckKnobMovement();
        }
    }

    private void startCheckKnobMovement() {
        ((APCControlSurface)this.surface).scheduleTask(this::checkKnobMovement, 100L);
    }
}

