/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apc;

import de.mossgrabers.controller.apc.APCConfiguration;
import de.mossgrabers.controller.apc.command.continuous.DeviceKnobRowCommand;
import de.mossgrabers.controller.apc.command.trigger.APCBrowserCommand;
import de.mossgrabers.controller.apc.command.trigger.APCCursorCommand;
import de.mossgrabers.controller.apc.command.trigger.APCQuantizeCommand;
import de.mossgrabers.controller.apc.command.trigger.APCRecordCommand;
import de.mossgrabers.controller.apc.command.trigger.BankLeftCommand;
import de.mossgrabers.controller.apc.command.trigger.BankRightCommand;
import de.mossgrabers.controller.apc.command.trigger.DeviceLeftCommand;
import de.mossgrabers.controller.apc.command.trigger.DeviceRightCommand;
import de.mossgrabers.controller.apc.command.trigger.MasterCommand;
import de.mossgrabers.controller.apc.command.trigger.NudgeCommand;
import de.mossgrabers.controller.apc.command.trigger.PanelLayoutCommand;
import de.mossgrabers.controller.apc.command.trigger.RecArmCommand;
import de.mossgrabers.controller.apc.command.trigger.SelectCommand;
import de.mossgrabers.controller.apc.command.trigger.SendCommand;
import de.mossgrabers.controller.apc.command.trigger.SessionRecordCommand;
import de.mossgrabers.controller.apc.command.trigger.ShiftCommand;
import de.mossgrabers.controller.apc.command.trigger.StopAllClipsCommand;
import de.mossgrabers.controller.apc.command.trigger.StopClipCommand;
import de.mossgrabers.controller.apc.controller.APCColors;
import de.mossgrabers.controller.apc.controller.APCControlSurface;
import de.mossgrabers.controller.apc.mode.BrowserMode;
import de.mossgrabers.controller.apc.mode.Modes;
import de.mossgrabers.controller.apc.mode.PanMode;
import de.mossgrabers.controller.apc.mode.SendMode;
import de.mossgrabers.controller.apc.view.DrumView;
import de.mossgrabers.controller.apc.view.PlayView;
import de.mossgrabers.controller.apc.view.RaindropsView;
import de.mossgrabers.controller.apc.view.SequencerView;
import de.mossgrabers.controller.apc.view.SessionView;
import de.mossgrabers.controller.apc.view.ShiftView;
import de.mossgrabers.controller.apc.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.SceneCommand;
import de.mossgrabers.framework.command.continuous.CrossfaderCommand;
import de.mossgrabers.framework.command.continuous.FaderAbsoluteCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.continuous.MasterFaderAbsoluteCommand;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.command.continuous.TempoCommand;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.command.trigger.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.device.DeviceOnOffCommand;
import de.mossgrabers.framework.command.trigger.track.CrossfadeModeCommand;
import de.mossgrabers.framework.command.trigger.track.MuteCommand;
import de.mossgrabers.framework.command.trigger.track.SoloCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class APCControllerSetup
extends AbstractControllerSetup<APCControlSurface, APCConfiguration> {
    private static final int COMMAND_SELECT = 100;
    private static final int COMMAND_SOLO = 110;
    private static final int COMMAND_MUTE = 120;
    private static final int COMMAND_REC_ARM = 130;
    private static final int COMMAND_CROSSFADER = 140;
    private static final int COMMAND_SEND = 150;
    private static final int COMMAND_STOP_CLIP = 160;
    private static final Integer COMMAND_DEVICE_LEFT = 200;
    private static final Integer COMMAND_DEVICE_RIGHT = 201;
    private static final Integer COMMAND_BANK_LEFT = 202;
    private static final Integer COMMAND_BANK_RIGHT = 203;
    private static final Integer COMMAND_TOGGLE_DEVICES = 204;
    private final boolean isMkII;

    public APCControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settingsUI, boolean isMkII) {
        super(factory, host, settingsUI);
        this.isMkII = isMkII;
        this.colorManager = new ColorManager();
        APCColors.addColors(this.colorManager, isMkII);
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new APCConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateButtons();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 76, 8, 5);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 5, 8, 16, 16, true, -1, -1, -1, -1);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addTrackSelectionObserver(this::handleTrackChange);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(this.isMkII ? "Akai APC40 mkII" : "Akai APC40", "B040??");
        APCControlSurface surface = new APCControlSurface(this.model.getHost(), this.colorManager, (APCConfiguration)this.configuration, output, input, this.isMkII);
        this.surfaces.add(surface);
        surface.setDisplay(new DummyDisplay(this.host));
        for (int i = 0; i < 8; ++i) {
            surface.setLED(24 + i, 1);
        }
    }

    @Override
    protected void createObservers() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        surface.getViewManager().addViewChangeListener((previousViewId, activeViewId) -> this.updateMode(null));
        surface.getModeManager().addModeListener((previousModeId, activeModeId) -> this.updateMode(activeModeId));
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void createModes() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_PAN, new PanMode(surface, this.model));
        for (int i = 0; i < 8; ++i) {
            modeManager.registerMode(Modes.MODE_SEND1 + i, new SendMode(surface, this.model, i));
        }
        modeManager.registerMode(Modes.MODE_BROWSER, new BrowserMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        viewManager.registerView(Views.VIEW_SESSION, new SessionView(surface, this.model));
        viewManager.registerView(Views.VIEW_SEQUENCER, new SequencerView(surface, this.model));
        viewManager.registerView(Views.VIEW_DRUM, new DrumView(surface, this.model));
        viewManager.registerView(Views.VIEW_RAINDROPS, new RaindropsView(surface, this.model));
        viewManager.registerView(Views.VIEW_SHIFT, new ShiftView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        this.addTriggerCommand(Commands.COMMAND_SHIFT, 98, new ShiftCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PLAY, 91, new PlayCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 93, new APCRecordCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TAP_TEMPO, 99, new TapTempoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_QUANTIZE, 63, new APCQuantizeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAN_SEND, 87, new ModeSelectCommand(Modes.MODE_PAN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MASTERTRACK, 80, new MasterCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_STOP_ALL_CLIPS, 81, new StopAllClipsCommand(this.model, surface));
        this.addTriggerCommand(150, 88, new SendCommand(0, this.model, surface));
        this.addTriggerCommand(151, 89, new SendCommand(1, this.model, surface));
        for (int i = 0; i < 8; ++i) {
            Integer selectCommand = 100 + i;
            Integer soloCommand = 110 + i;
            Integer muteCommand = 120 + i;
            Integer recArmCommand = 130 + i;
            Integer crossfadeCommand = 140 + i;
            Integer stopClipCommand = 160 + i;
            viewManager.registerTriggerCommand(selectCommand, new SelectCommand(i, this.model, surface));
            viewManager.registerTriggerCommand(soloCommand, new SoloCommand(i, this.model, surface));
            viewManager.registerTriggerCommand(muteCommand, new MuteCommand(i, this.model, surface));
            viewManager.registerTriggerCommand(recArmCommand, new RecArmCommand(i, this.model, surface));
            viewManager.registerTriggerCommand(crossfadeCommand, new CrossfadeModeCommand(i, this.model, surface));
            viewManager.registerTriggerCommand(stopClipCommand, new StopClipCommand(i, this.model, surface));
            surface.assignTriggerCommand(51, i, selectCommand);
            surface.assignTriggerCommand(49, i, soloCommand);
            surface.assignTriggerCommand(50, i, muteCommand);
            surface.assignTriggerCommand(48, i, recArmCommand);
            surface.assignTriggerCommand(66, i, crossfadeCommand);
            surface.assignTriggerCommand(52, i, stopClipCommand);
        }
        viewManager.registerTriggerCommand(COMMAND_DEVICE_LEFT, new DeviceLeftCommand(this.model, surface));
        viewManager.registerTriggerCommand(COMMAND_DEVICE_RIGHT, new DeviceRightCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_CLIP, new SessionRecordCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_METRONOME, new MetronomeCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_NUDGE_MINUS, new NudgeCommand(true, this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_NUDGE_PLUS, new NudgeCommand(false, this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_LAYOUT, new PanelLayoutCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_DEVICE_ON_OFF, new DeviceOnOffCommand(this.model, surface));
        viewManager.registerTriggerCommand(COMMAND_TOGGLE_DEVICES, new PaneCommand(PaneCommand.Panels.DEVICE, this.model, surface));
        if (this.isMkII) {
            surface.assignTriggerCommand(102, Commands.COMMAND_CLIP);
            surface.assignTriggerCommand(90, Commands.COMMAND_METRONOME);
            surface.assignTriggerCommand(101, Commands.COMMAND_NUDGE_MINUS);
            surface.assignTriggerCommand(100, Commands.COMMAND_NUDGE_PLUS);
            surface.assignTriggerCommand(65, Commands.COMMAND_LAYOUT);
            surface.assignTriggerCommand(62, Commands.COMMAND_DEVICE_ON_OFF);
            surface.assignTriggerCommand(58, COMMAND_DEVICE_LEFT);
            surface.assignTriggerCommand(59, COMMAND_DEVICE_RIGHT);
            surface.assignTriggerCommand(64, COMMAND_TOGGLE_DEVICES);
        } else {
            surface.assignTriggerCommand(64, Commands.COMMAND_CLIP);
            surface.assignTriggerCommand(65, Commands.COMMAND_METRONOME);
            surface.assignTriggerCommand(100, Commands.COMMAND_NUDGE_MINUS);
            surface.assignTriggerCommand(101, Commands.COMMAND_NUDGE_PLUS);
            surface.assignTriggerCommand(62, Commands.COMMAND_LAYOUT);
            surface.assignTriggerCommand(59, Commands.COMMAND_DEVICE_ON_OFF);
            surface.assignTriggerCommand(58, COMMAND_TOGGLE_DEVICES);
            this.addTriggerCommand(Commands.COMMAND_STOP, 92, new StopCommand(this.model, surface));
            this.addTriggerCommand(152, 90, new SendCommand(2, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_NEW, 67, new NewCommand(this.model, surface));
        }
        this.addTriggerCommand(Commands.COMMAND_BROWSE, 103, new APCBrowserCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_BANK_LEFT, 60, new BankLeftCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_BANK_RIGHT, 61, new BankRightCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, surface.getDownButtonId(), new APCCursorCommand(CursorCommand.Direction.DOWN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, surface.getUpButtonId(), new APCCursorCommand(CursorCommand.Direction.UP, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, surface.getLeftButtonId(), new APCCursorCommand(CursorCommand.Direction.LEFT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, surface.getRightButtonId(), new APCCursorCommand(CursorCommand.Direction.RIGHT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCENE1, 82, new SceneCommand(7, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCENE2, 83, new SceneCommand(6, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCENE3, 84, new SceneCommand(5, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCENE4, 85, new SceneCommand(4, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCENE5, 86, new SceneCommand(3, this.model, surface));
    }

    @Override
    protected void registerContinuousCommands() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        this.addContinuousCommand(Commands.CONT_COMMAND_MASTER_KNOB, 14, new MasterFaderAbsoluteCommand(this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_PLAY_POSITION, 47, new PlayPositionCommand(this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_CROSSFADER, 15, new CrossfaderCommand(this.model, surface));
        for (int i = 0; i < 8; ++i) {
            Integer faderCommand = Commands.CONT_COMMAND_FADER1 + i;
            viewManager.registerContinuousCommand(faderCommand, new FaderAbsoluteCommand(i, this.model, surface));
            surface.assignContinuousCommand(7, i, faderCommand);
            Integer knobCommand = Commands.CONT_COMMAND_KNOB1 + i;
            viewManager.registerContinuousCommand(knobCommand, new KnobRowModeCommand(i, this.model, surface));
            surface.assignContinuousCommand(48 + i, knobCommand);
            Integer deviceKnobCommand = Commands.CONT_COMMAND_DEVICE_KNOB1 + i;
            viewManager.registerContinuousCommand(deviceKnobCommand, new DeviceKnobRowCommand(i, this.model, surface));
            surface.assignContinuousCommand(16 + i, deviceKnobCommand);
        }
        if (this.isMkII) {
            this.addContinuousCommand(Commands.CONT_COMMAND_TEMPO, 13, new TempoCommand(this.model, surface));
        }
    }

    @Override
    public void startup() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        surface.getModeManager().setActiveMode(Modes.MODE_PAN);
        surface.getViewManager().setActiveView(Views.VIEW_PLAY);
    }

    private void updateButtons() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        View activeView = viewManager.getActiveView();
        if (activeView != null) {
            ((APCCursorCommand)activeView.getTriggerCommand(Commands.COMMAND_ARROW_DOWN)).updateArrows();
            ((SceneView)((Object)activeView)).updateSceneButtons();
        }
        boolean isShift = surface.isShiftPressed();
        boolean isSendA = surface.isPressed(88);
        ITransport t = this.model.getTransport();
        surface.updateButton(91, t.isPlaying() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        surface.updateButton(93, t.isRecording() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selTrack = tb.getSelectedTrack();
        int selIndex = selTrack == null ? -1 : selTrack.getIndex();
        int clipLength = ((APCConfiguration)surface.getConfiguration()).getNewClipLength();
        ModeManager modeManager = surface.getModeManager();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            boolean isOn = isShift ? i == clipLength : (isSendA ? modeManager.isActiveMode(Modes.MODE_SEND1 + i) : i == selIndex);
            surface.updateButtonEx(51, i, isOn ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButtonEx(49, i, track.doesExist() && (isShift ? track.isAutoMonitor() : track.isSolo()) ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButtonEx(50, i, track.doesExist() && (isShift ? track.isMonitor() : !track.isMute()) ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            if (this.isMkII) {
                surface.updateButtonEx(66, i, track.doesExist() && !"AB".equals(track.getCrossfadeMode()) ? ("A".equals(track.getCrossfadeMode()) ? "BUTTON_STATE_ON" : "BUTTON_STATE_BLINK") : "BUTTON_STATE_OFF");
                surface.updateButtonEx(48, i, track.doesExist() && track.isRecArm() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
                continue;
            }
            if (isShift) {
                surface.updateButtonEx(48, i, track.doesExist() && !"AB".equals(track.getCrossfadeMode()) ? ("A".equals(track.getCrossfadeMode()) ? "BUTTON_STATE_ON" : "BUTTON_STATE_BLINK") : "BUTTON_STATE_OFF");
                continue;
            }
            surface.updateButtonEx(48, i, track.doesExist() && track.isRecArm() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        }
        surface.updateButton(80, this.model.getMasterTrack().isSelected() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        ICursorDevice device = this.model.getCursorDevice();
        if (this.isMkII) {
            surface.updateButton(102, t.isLauncherOverdub() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(90, t.isMetronomeOn() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(62, device.isEnabled() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(63, "BUTTON_STATE_OFF");
            surface.updateButton(64, "BUTTON_STATE_OFF");
            surface.updateButton(65, "BUTTON_STATE_OFF");
            surface.updateButton(58, "BUTTON_STATE_OFF");
            surface.updateButton(59, "BUTTON_STATE_OFF");
            surface.updateButton(60, "BUTTON_STATE_OFF");
            surface.updateButton(61, "BUTTON_STATE_OFF");
            surface.updateButton(103, this.model.getBrowser().isActive() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        } else {
            surface.updateButton(62, "BUTTON_STATE_OFF");
            surface.updateButton(63, "BUTTON_STATE_OFF");
            surface.updateButton(64, t.isLauncherOverdub() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(65, t.isMetronomeOn() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(58, "BUTTON_STATE_OFF");
            surface.updateButton(59, device.isEnabled() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(60, "BUTTON_STATE_OFF");
            surface.updateButton(61, "BUTTON_STATE_OFF");
        }
        this.updateDeviceKnobs();
    }

    private void updateMode(Integer mode) {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        Integer m = mode == null ? surface.getModeManager().getActiveModeId() : mode;
        this.updateIndication(m);
        surface.updateButton(87, m == Modes.MODE_PAN ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        if (surface.isMkII()) {
            surface.updateButton(88, m == Modes.MODE_SEND1 || m == Modes.MODE_SEND3 || m == Modes.MODE_SEND5 || m == Modes.MODE_SEND7 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(89, m == Modes.MODE_SEND2 || m == Modes.MODE_SEND4 || m == Modes.MODE_SEND6 || m == Modes.MODE_SEND8 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        } else {
            surface.updateButton(88, m == Modes.MODE_SEND1 || m == Modes.MODE_SEND4 || m == Modes.MODE_SEND7 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(89, m == Modes.MODE_SEND2 || m == Modes.MODE_SEND5 || m == Modes.MODE_SEND8 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            surface.updateButton(90, m == Modes.MODE_SEND3 || m == Modes.MODE_SEND6 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        }
    }

    private void updateDeviceKnobs() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        View view = surface.getViewManager().getActiveView();
        if (view == null) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        for (int i = 0; i < 8; ++i) {
            Integer deviceKnobCommand = Commands.CONT_COMMAND_DEVICE_KNOB1 + i;
            if (((DeviceKnobRowCommand)view.getContinuousCommand(deviceKnobCommand)).isKnobMoving()) continue;
            surface.setLED(16 + i, cd.getFXParam(i).getValue());
        }
    }

    private void updateIndication(Integer mode) {
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        boolean isSession = surface.getViewManager().isActiveView(Views.VIEW_SESSION);
        boolean isEffect = this.model.isEffectTrackBankActive();
        boolean isPan = mode == Modes.MODE_PAN;
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect);
            track.setPanIndication(!isEffect && isPan);
            for (int j = 0; j < 8; ++j) {
                track.getSend(j).setIndication(!isEffect && (mode == Modes.MODE_SEND1 && j == 0 || mode == Modes.MODE_SEND2 && j == 1 || mode == Modes.MODE_SEND3 && j == 2 || mode == Modes.MODE_SEND4 && j == 3 || mode == Modes.MODE_SEND5 && j == 4 || mode == Modes.MODE_SEND6 && j == 5 || mode == Modes.MODE_SEND7 && j == 6 || mode == Modes.MODE_SEND8 && j == 7));
            }
            if (tbe != null) {
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect);
                fxTrack.setPanIndication(isEffect && isPan);
            }
            cursorDevice.indicateParameter(i, true);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        ITrack selectedTrack;
        if (!isSelected) {
            return;
        }
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        if (!viewManager.isActiveView(Views.VIEW_SESSION) && (selectedTrack = this.model.getSelectedTrack()) != null) {
            Integer preferredView = viewManager.getPreferredView(selectedTrack.getPosition());
            viewManager.setActiveView(preferredView == null ? Views.VIEW_PLAY : preferredView);
        }
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        this.scales.setDrumOctave(0);
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.getView(Views.VIEW_DRUM).updateNoteMapping();
        }
    }
}

