/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.AddressSelector;
import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSCPacketDispatcher {
    private final Map<AddressSelector, OSCListener> selectorToListener = new HashMap<AddressSelector, OSCListener>();

    public void addListener(AddressSelector addressSelector, OSCListener listener) {
        this.selectorToListener.put(addressSelector, listener);
    }

    public void dispatchPacket(OSCPacket packet) {
        this.dispatchPacket(packet, null);
    }

    public void dispatchPacket(OSCPacket packet, Date timestamp) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)packet);
        } else {
            this.dispatchMessage((OSCMessage)packet, timestamp);
        }
    }

    private void dispatchBundle(OSCBundle bundle) {
        Date timestamp = bundle.getTimestamp();
        List<OSCPacket> packets = bundle.getPackets();
        for (OSCPacket packet : packets) {
            this.dispatchPacket(packet, timestamp);
        }
    }

    private void dispatchMessage(OSCMessage message, Date time) {
        for (Map.Entry<AddressSelector, OSCListener> addrList : this.selectorToListener.entrySet()) {
            if (!addrList.getKey().matches(message.getAddress())) continue;
            addrList.getValue().acceptMessage(time, message);
        }
    }
}

