/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCImpulse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;

public class OSCJavaToByteArrayConverter {
    protected static final long MSB_0_BASE_TIME = 2085978496000L;
    protected static final long MSB_1_BASE_TIME = -2208988800000L;
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private Charset charset = Charset.defaultCharset();
    private final byte[] intBytes = new byte[4];
    private final byte[] longintBytes = new byte[8];

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private void alignStream() {
        int alignmentOverlap = this.stream.size() % 4;
        int padLen = (4 - alignmentOverlap) % 4;
        for (int pci = 0; pci < padLen; ++pci) {
            this.stream.write(0);
        }
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public void write(byte[] bytes) {
        this.writeInteger32ToByteArray(bytes.length);
        this.writeUnderHandler(bytes);
        this.alignStream();
    }

    public void write(int anInt) {
        this.writeInteger32ToByteArray(anInt);
    }

    public void write(Float aFloat) {
        this.writeInteger32ToByteArray(Float.floatToIntBits(aFloat.floatValue()));
    }

    public void write(Double aDouble) {
        this.writeInteger64ToByteArray(Double.doubleToRawLongBits(aDouble));
    }

    public void write(Integer anInt) {
        this.writeInteger32ToByteArray(anInt);
    }

    public void write(Long aLong) {
        this.writeInteger64ToByteArray(aLong);
    }

    public void write(Date timestamp) {
        this.writeInteger64ToByteArray(OSCJavaToByteArrayConverter.javaToNtpTimeStamp(timestamp.getTime()));
    }

    protected static long javaToNtpTimeStamp(long javaTime) {
        boolean useBase1 = javaTime < 2085978496000L;
        long baseTime = useBase1 ? javaTime - -2208988800000L : javaTime - 2085978496000L;
        long seconds = baseTime / 1000L;
        long fraction = baseTime % 1000L * 0x100000000L / 1000L;
        if (useBase1) {
            seconds |= 0x80000000L;
        }
        long ntpTime = seconds << 32 | fraction;
        return ntpTime;
    }

    public void write(String aString) {
        byte[] stringBytes = aString.getBytes(this.charset);
        this.writeUnderHandler(stringBytes);
        this.stream.write(0);
        this.alignStream();
    }

    public void write(Character aChar) {
        this.stream.write(aChar.charValue());
        this.alignStream();
    }

    public void write(char aChar) {
        this.stream.write(aChar);
    }

    private boolean isNoDataObject(Object anObject) {
        return anObject instanceof OSCImpulse || anObject instanceof Boolean || anObject == null;
    }

    public void write(Object anObject) {
        if (anObject instanceof Collection) {
            Collection theArray = (Collection)anObject;
            for (Object entry : theArray) {
                this.write(entry);
            }
        } else if (anObject instanceof Float) {
            this.write((Float)anObject);
        } else if (anObject instanceof Double) {
            this.write((Double)anObject);
        } else if (anObject instanceof String) {
            this.write((String)anObject);
        } else if (anObject instanceof byte[]) {
            this.write((byte[])anObject);
        } else if (anObject instanceof Character) {
            this.write((Character)anObject);
        } else if (anObject instanceof Integer) {
            this.write((Integer)anObject);
        } else if (anObject instanceof Long) {
            this.write((Long)anObject);
        } else if (anObject instanceof Date) {
            this.write((Date)anObject);
        } else if (!this.isNoDataObject(anObject)) {
            throw new UnsupportedOperationException("Do not know how to write an object of class: " + anObject.getClass());
        }
    }

    public void writeType(Class typeClass) {
        if (Integer.class.equals((Object)typeClass)) {
            this.stream.write(105);
        } else if (Long.class.equals((Object)typeClass)) {
            this.stream.write(104);
        } else if (Date.class.equals((Object)typeClass)) {
            this.stream.write(116);
        } else if (Float.class.equals((Object)typeClass)) {
            this.stream.write(102);
        } else if (Double.class.equals((Object)typeClass)) {
            this.stream.write(100);
        } else if (String.class.equals((Object)typeClass)) {
            this.stream.write(115);
        } else if (byte[].class.equals((Object)typeClass)) {
            this.stream.write(98);
        } else if (Character.class.equals((Object)typeClass)) {
            this.stream.write(99);
        } else if (OSCImpulse.class.equals((Object)typeClass)) {
            this.stream.write(73);
        } else {
            throw new UnsupportedOperationException("Do not know the OSC type for the java class: " + typeClass);
        }
    }

    private void writeTypesArray(Collection<Object> arguments) {
        for (Object argument : arguments) {
            if (null == argument) {
                this.stream.write(78);
                continue;
            }
            if (argument instanceof Collection) {
                this.stream.write(91);
                Collection collArg = (Collection)argument;
                this.writeTypesArray(collArg);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(argument)) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(argument)) {
                this.stream.write(70);
                continue;
            }
            this.writeType(argument.getClass());
        }
    }

    public void writeTypes(Collection<Object> arguments) {
        this.writeTypesArray(arguments);
        this.stream.write(0);
        this.alignStream();
    }

    private void writeUnderHandler(byte[] bytes) {
        try {
            this.stream.write(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream", ex);
        }
    }

    private void writeInteger32ToByteArray(int value) {
        this.intBytes[3] = (byte)value;
        this.intBytes[2] = (byte)(value >>>= 8);
        this.intBytes[1] = (byte)(value >>>= 8);
        this.intBytes[0] = (byte)(value >>>= 8);
        this.writeUnderHandler(this.intBytes);
    }

    private void writeInteger64ToByteArray(long value) {
        this.longintBytes[7] = (byte)value;
        this.longintBytes[6] = (byte)(value >>>= 8);
        this.longintBytes[5] = (byte)(value >>>= 8);
        this.longintBytes[4] = (byte)(value >>>= 8);
        this.longintBytes[3] = (byte)(value >>>= 8);
        this.longintBytes[2] = (byte)(value >>>= 8);
        this.longintBytes[1] = (byte)(value >>>= 8);
        this.longintBytes[0] = (byte)(value >>>= 8);
        this.writeUnderHandler(this.longintBytes);
    }
}

