/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.AbstractOSCPacket;
import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCImpulse;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OSCByteArrayToJavaConverter {
    private static final String BUNDLE_START = "#bundle";
    private static final char BUNDLE_IDENTIFIER = "#bundle".charAt(0);
    private static final String NO_ARGUMENT_TYPES = "";
    private Charset charset = Charset.defaultCharset();

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public OSCPacket convert(byte[] bytes, int bytesLength) {
        Input rawInput = new Input(bytes, bytesLength);
        AbstractOSCPacket packet = this.isBundle(rawInput) ? this.convertBundle(rawInput) : this.convertMessage(rawInput);
        return packet;
    }

    private boolean isBundle(Input rawInput) {
        return rawInput.getBytes()[0] == BUNDLE_IDENTIFIER;
    }

    private OSCBundle convertBundle(Input rawInput) {
        rawInput.addToStreamPosition(BUNDLE_START.length() + 1);
        Date timestamp = this.readTimeTag(rawInput);
        OSCBundle bundle = new OSCBundle(timestamp);
        OSCByteArrayToJavaConverter myConverter = new OSCByteArrayToJavaConverter();
        myConverter.setCharset(this.charset);
        while (rawInput.getStreamPosition() < rawInput.getBytesLength()) {
            int packetLength = this.readInteger(rawInput);
            if (packetLength == 0) {
                throw new IllegalArgumentException("Packet length may not be 0");
            }
            if (packetLength % 4 != 0) {
                throw new IllegalArgumentException("Packet length has to be a multiple of 4, is:" + packetLength);
            }
            byte[] packetBytes = new byte[packetLength];
            System.arraycopy(rawInput.getBytes(), rawInput.getStreamPosition(), packetBytes, 0, packetLength);
            rawInput.addToStreamPosition(packetLength);
            OSCPacket packet = myConverter.convert(packetBytes, packetLength);
            bundle.addPacket(packet);
        }
        return bundle;
    }

    private OSCMessage convertMessage(Input rawInput) {
        OSCMessage message = new OSCMessage();
        message.setAddress(this.readString(rawInput));
        CharSequence types = this.readTypes(rawInput);
        for (int ti = 0; ti < types.length(); ++ti) {
            if ('[' == types.charAt(ti)) {
                message.addArgument(this.readArray(rawInput, types, ++ti));
                while (types.charAt(ti) != ']') {
                    ++ti;
                }
                continue;
            }
            message.addArgument(this.readArgument(rawInput, types.charAt(ti)));
        }
        return message;
    }

    private String readString(Input rawInput) {
        int strLen = this.lengthOfCurrentString(rawInput);
        String res = new String(rawInput.getBytes(), rawInput.getStreamPosition(), strLen, this.charset);
        rawInput.addToStreamPosition(strLen);
        this.moveToFourByteBoundry(rawInput);
        return res;
    }

    private byte[] readBlob(Input rawInput) {
        int blobLen = this.readInteger(rawInput);
        byte[] res = new byte[blobLen];
        System.arraycopy(rawInput.getBytes(), rawInput.getStreamPosition(), res, 0, blobLen);
        rawInput.addToStreamPosition(blobLen);
        this.moveToFourByteBoundry(rawInput);
        return res;
    }

    private CharSequence readTypes(Input rawInput) {
        String typesStr;
        if (rawInput.getBytes().length <= rawInput.getStreamPosition()) {
            typesStr = NO_ARGUMENT_TYPES;
        } else if (rawInput.getBytes()[rawInput.getStreamPosition()] != 44) {
            typesStr = NO_ARGUMENT_TYPES;
        } else {
            rawInput.getAndIncreaseStreamPositionByOne();
            typesStr = this.readString(rawInput);
        }
        return typesStr;
    }

    private Object readArgument(Input rawInput, char type) {
        switch (type) {
            case 'u': {
                return this.readUnsignedInteger(rawInput);
            }
            case 'i': {
                return this.readInteger(rawInput);
            }
            case 'h': {
                return this.readLong(rawInput);
            }
            case 'f': {
                return this.readFloat(rawInput);
            }
            case 'd': {
                return this.readDouble(rawInput);
            }
            case 's': {
                return this.readString(rawInput);
            }
            case 'b': {
                return this.readBlob(rawInput);
            }
            case 'c': {
                return this.readChar(rawInput);
            }
            case 'N': {
                return null;
            }
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
            case 'I': {
                return OSCImpulse.INSTANCE;
            }
            case 't': {
                return this.readTimeTag(rawInput);
            }
        }
        return null;
    }

    private Character readChar(Input rawInput) {
        return Character.valueOf((char)rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()]);
    }

    private BigInteger readBigInteger(Input rawInput, int numBytes) {
        byte[] myBytes = new byte[numBytes];
        System.arraycopy(rawInput.getBytes(), rawInput.getStreamPosition(), myBytes, 0, numBytes);
        rawInput.addToStreamPosition(numBytes);
        return new BigInteger(myBytes);
    }

    private Object readDouble(Input rawInput) {
        BigInteger doubleBits = this.readBigInteger(rawInput, 8);
        return Double.longBitsToDouble(doubleBits.longValue());
    }

    private Float readFloat(Input rawInput) {
        BigInteger floatBits = this.readBigInteger(rawInput, 4);
        return Float.valueOf(Float.intBitsToFloat(floatBits.intValue()));
    }

    private Long readLong(Input rawInput) {
        BigInteger longintBytes = this.readBigInteger(rawInput, 8);
        return longintBytes.longValue();
    }

    private Integer readInteger(Input rawInput) {
        BigInteger intBits = this.readBigInteger(rawInput, 4);
        return intBits.intValue();
    }

    private Long readUnsignedInteger(Input rawInput) {
        int firstByte = 0xFF & rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
        int secondByte = 0xFF & rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
        int thirdByte = 0xFF & rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
        int fourthByte = 0xFF & rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
        return (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
    }

    private Date readTimeTag(Input rawInput) {
        int bi;
        byte[] secondBytes = new byte[8];
        byte[] fractionBytes = new byte[8];
        for (int bi2 = 0; bi2 < 4; ++bi2) {
            secondBytes[bi2] = 0;
            fractionBytes[bi2] = 0;
        }
        boolean isImmediate = true;
        for (bi = 4; bi < 8; ++bi) {
            secondBytes[bi] = rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
            if (secondBytes[bi] <= 0) continue;
            isImmediate = false;
        }
        for (bi = 4; bi < 8; ++bi) {
            fractionBytes[bi] = rawInput.getBytes()[rawInput.getAndIncreaseStreamPositionByOne()];
            if (bi < 7) {
                if (fractionBytes[bi] <= 0) continue;
                isImmediate = false;
                continue;
            }
            if (fractionBytes[bi] <= 1) continue;
            isImmediate = false;
        }
        if (isImmediate) {
            return OSCBundle.TIMESTAMP_IMMEDIATE;
        }
        long secsSince1900 = new BigInteger(secondBytes).longValue();
        long secsSince1970 = secsSince1900 - 2208988800L;
        if (secsSince1970 < 0L) {
            secsSince1970 = 0L;
        }
        long fraction = new BigInteger(fractionBytes).longValue();
        fraction = (fraction = fraction * 1000L / 0x100000000L) > 0L ? fraction + 1L : 0L;
        long millisecs = secsSince1970 * 1000L + fraction;
        return new Date(millisecs);
    }

    private List<Object> readArray(Input rawInput, CharSequence types, int pos) {
        int arrayLen = 0;
        while (types.charAt(pos + arrayLen) != ']') {
            ++arrayLen;
        }
        ArrayList<Object> array = new ArrayList<Object>(arrayLen);
        for (int ai = 0; ai < arrayLen; ++ai) {
            array.add(this.readArgument(rawInput, types.charAt(pos + ai)));
        }
        return array;
    }

    private int lengthOfCurrentString(Input rawInput) {
        int len = 0;
        while (rawInput.getBytes()[rawInput.getStreamPosition() + len] != 0) {
            ++len;
        }
        return len;
    }

    private void moveToFourByteBoundry(Input rawInput) {
        int mod = rawInput.getStreamPosition() % 4;
        rawInput.addToStreamPosition(4 - mod);
    }

    private static class Input {
        private final byte[] bytes;
        private final int bytesLength;
        private int streamPosition;

        Input(byte[] bytes, int bytesLength) {
            this.bytes = bytes;
            this.bytesLength = bytesLength;
            this.streamPosition = 0;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getBytesLength() {
            return this.bytesLength;
        }

        public int getAndIncreaseStreamPositionByOne() {
            return this.streamPosition++;
        }

        public void addToStreamPosition(int toAdd) {
            this.streamPosition += toAdd;
        }

        public int getStreamPosition() {
            return this.streamPosition;
        }
    }
}

