/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.AddressSelector;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCPacketDispatcher;
import com.illposed.osc.utility.OSCPatternAddressSelector;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.charset.Charset;

public class OSCPortIn
extends OSCPort
implements Runnable {
    static final int BUFFER_SIZE = 65507;
    private boolean listening;
    private final OSCByteArrayToJavaConverter converter = new OSCByteArrayToJavaConverter();
    private final OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();
    private Thread listeningThread = null;

    public OSCPortIn(DatagramSocket socket) {
        super(socket, socket.getLocalPort());
    }

    public OSCPortIn(int port) throws SocketException {
        this(new DatagramSocket(port));
    }

    public OSCPortIn(int port, Charset charset) throws SocketException {
        this(port);
        this.converter.setCharset(charset);
    }

    @Override
    public void run() {
        byte[] buffer = new byte[65507];
        DatagramPacket packet = new DatagramPacket(buffer, 65507);
        DatagramSocket socket = this.getSocket();
        while (this.listening) {
            try {
                try {
                    socket.receive(packet);
                }
                catch (SocketException ex) {
                    if (!this.listening) continue;
                    throw ex;
                }
                OSCPacket oscPacket = this.converter.convert(buffer, packet.getLength());
                this.dispatcher.dispatchPacket(oscPacket);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void startListening() {
        if (!this.isListening()) {
            this.listening = true;
            this.listeningThread = new Thread(this);
            this.listeningThread.setDaemon(true);
            this.listeningThread.start();
        }
    }

    public void stopListening() {
        this.listening = false;
        if (this.listeningThread != null) {
            this.listeningThread.interrupt();
        }
        this.listeningThread = null;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void addListener(String addressSelector, OSCListener listener) {
        this.addListener(new OSCPatternAddressSelector(addressSelector), listener);
    }

    public void addListener(AddressSelector addressSelector, OSCListener listener) {
        this.dispatcher.addListener(addressSelector, listener);
    }
}

