/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.AbstractOSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class OSCMessage
extends AbstractOSCPacket {
    private static final Pattern ILLEGAL_ADDRESS_CHAR = Pattern.compile("[ \\#\\*\\,\\?\\[\\]\\{\\}]");
    private String address;
    private List<Object> arguments;

    public OSCMessage() {
        this(null);
    }

    public OSCMessage(String address) {
        this(address, null);
    }

    public OSCMessage(String address, Collection<Object> arguments) {
        OSCMessage.checkAddress(address);
        this.address = address;
        this.arguments = arguments == null ? new LinkedList<Object>() : new ArrayList<Object>(arguments);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        OSCMessage.checkAddress(address);
        this.address = address;
        this.contentChanged();
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
        this.contentChanged();
    }

    public List<Object> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    private void computeAddressByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(this.address);
    }

    private void computeArgumentsByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(',');
        stream.writeTypes(this.arguments);
        for (Object argument : this.arguments) {
            stream.write(argument);
        }
    }

    @Override
    protected byte[] computeByteArray(OSCJavaToByteArrayConverter stream) {
        this.computeAddressByteArray(stream);
        this.computeArgumentsByteArray(stream);
        return stream.toByteArray();
    }

    private static void checkAddress(String address) {
        if (address != null && !OSCMessage.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid OSC address: " + address);
        }
    }

    public static boolean isValidAddress(String address) {
        return address != null && !address.isEmpty() && address.charAt(0) == '/' && !address.contains("//") && !ILLEGAL_ADDRESS_CHAR.matcher(address).find();
    }
}

