/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.AbstractOSCPacket;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class OSCBundle
extends AbstractOSCPacket {
    public static final long SECONDS_FROM_1900_TO_1970 = 2208988800L;
    public static final Date TIMESTAMP_IMMEDIATE = new Date(0L);
    private Date timestamp;
    private List<OSCPacket> packets;

    public OSCBundle() {
        this(TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Date timestamp) {
        this(null, timestamp);
    }

    public OSCBundle(Collection<OSCPacket> packets) {
        this(packets, TIMESTAMP_IMMEDIATE);
    }

    public OSCBundle(Collection<OSCPacket> packets, Date timestamp) {
        this.packets = null == packets ? new LinkedList<OSCPacket>() : new ArrayList<OSCPacket>(packets);
        this.timestamp = OSCBundle.clone(timestamp);
    }

    private static Date clone(Date toBeCloned) {
        return toBeCloned == null ? toBeCloned : (Date)toBeCloned.clone();
    }

    public Date getTimestamp() {
        return OSCBundle.clone(this.timestamp);
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = OSCBundle.clone(timestamp);
    }

    public void addPacket(OSCPacket packet) {
        this.packets.add(packet);
        this.contentChanged();
    }

    public List<OSCPacket> getPackets() {
        return Collections.unmodifiableList(this.packets);
    }

    private void computeTimeTagByteArray(OSCJavaToByteArrayConverter stream) {
        if (null == this.timestamp || this.timestamp.equals(TIMESTAMP_IMMEDIATE)) {
            stream.write(0);
            stream.write(1);
            return;
        }
        long millisecs = this.timestamp.getTime();
        long secsSince1970 = millisecs / 1000L;
        long secs = secsSince1970 + 2208988800L;
        long fraction = millisecs % 1000L * 0x100000000L / 1000L;
        stream.write((int)secs);
        stream.write((int)fraction);
    }

    @Override
    protected byte[] computeByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write("#bundle");
        this.computeTimeTagByteArray(stream);
        for (OSCPacket pkg : this.packets) {
            byte[] packetBytes = pkg.getByteArray();
            stream.write(packetBytes);
        }
        return stream.toByteArray();
    }
}

