/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.SessionsController=Class.extend({init:function(page,controllers){this.page=page;this.controllers=controllers;},start:function(){this.page.show(this);$.each(this.controllers,function(index,controller){controller.start();});},onTabVisible:function(index){this.controllers[index].onVisible();}});jscape.SessionsPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true,onSelect:$.proxy(function(title,index){if(this.listener){this.listener.onTabVisible(index);}},this)});},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},selectTab:function(index){this.infoPanel.tabs("select",index);}});jscape.SessionsPanelController=Class.extend({init:function(panel,closeSessionController,autoUpdateInterval){this.panel=panel;this.closeSessionController=closeSessionController;this.autoUpdateInterval=autoUpdateInterval;},start:function(){this.panel.show(this);this._updateSessions(true);},onVisible:function(){this.panel.resize();},onCloseSession:function(summary){this.closeSessionController.start(summary,$.proxy(this._updateSessions,this));},_updateSessions:function(showError){jscape.ApiClient.proxySessions($.proxy(this._sessionsUpdated,this),showError);},_sessionsUpdated:function(sessions){this.sessions=sessions;this.panel.setSessions(this.sessions);this._scheduleNextSessionsUpdate();},_scheduleNextSessionsUpdate:function(){setTimeout($.proxy(function(){this._updateSessions(false);},this),this.autoUpdateInterval);}});jscape.SessionsPanel=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.sessionsTable=$("#sessionsTable");this.sessionsTable.datagrid({fitColumns:true,remoteSort:true,sortName:"creationTime",sortOrder:"desc",singleSelect:true,columns:[[{field:"id",title:jscape.Resources["sessionsPage.sessionsTable.column.0"],width:12,halign:"left",align:"left",sortable:false},{field:"creationTime",title:jscape.Resources["sessionsPage.sessionsTable.column.1"],width:12,halign:"left",align:"left",sortable:true,formatter:function(value,row){return dateFormat(new Date(row.creationTime),"UTC:yyyy-mm-dd HH:MM:ss Z");}},{field:"uptime",title:jscape.Resources["sessionsPage.sessionsTable.column.2"],width:15,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._uptimeOf,this)},{field:"clientAddress",title:jscape.Resources["sessionsPage.sessionsTable.column.3"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.clientAddress);}},{field:"gatewayServerAddress",title:jscape.Resources["sessionsPage.sessionsTable.column.4"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.gatewayServerAddress);}},{field:"gatewayClientAddress",title:jscape.Resources["sessionsPage.sessionsTable.column.5"],width:12,halign:"left",align:"left",sortable:true,formatter:function(value,row){return row.gatewayClientAddress?"{host}:{port}".supplant(row.gatewayClientAddress):"";}},{field:"serverAddress",title:jscape.Resources["sessionsPage.sessionsTable.column.6"],width:10,halign:"center",align:"center",sortable:true,formatter:function(value,row){return row.serverAddress?"{host}:{port}".supplant(row.serverAddress):"";}},{field:"clientProtocol",title:jscape.Resources["sessionsPage.sessionsTable.column.7"],width:15,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._clientProtocolOf,this)},{field:"serverProtocol",title:jscape.Resources["sessionsPage.sessionsTable.column.8"],width:20,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._serverProtocolOf,this)}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),onSortColumn:$.proxy(this._sort,this),onLoadSuccess:$.proxy(this._dataLoaded,this)});this.sorter={"creationTime.asc":function(a,b){return window.sort(a.creationTime,b.creationTime);},"creationTime.desc":function(a,b){return window.sort(b.creationTime,a.creationTime);},"uptime.asc":function(a,b){return window.sort(a.uptime,b.uptime);},"uptime.desc":function(a,b){return window.sort(b.uptime,a.uptime);},"clientAddress.asc":$.proxy(function(a,b){return window.sortAddress(a.clientAddress,b.clientAddress);},this),"clientAddress.desc":$.proxy(function(a,b){return window.sortAddress(b.clientAddress,a.clientAddress);},this),"gatewayServerAddress.asc":$.proxy(function(a,b){return window.sortAddress(a.gatewayServerAddress,b.gatewayServerAddress);},this),"gatewayServerAddress.desc":$.proxy(function(a,b){return window.sortAddress(b.gatewayServerAddress,a.gatewayServerAddress);},this),"gatewayClientAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.gatewayClientAddress,b.gatewayClientAddress));},this),"gatewayClientAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.gatewayClientAddress,a.gatewayClientAddress));},this),"serverAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.serverAddress,b.serverAddress));},this),"serverAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.serverAddress,a.serverAddress));},this),"clientProtocol.asc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},this),"clientProtocol.desc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,b),this._clientProtocolOf(null,a));},this),"serverProtocol.asc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,a),this._serverProtocolOf(null,b));},this),"serverProtocol.desc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,b),this._serverProtocolOf(null,a));},this)};this.closeSessionButton=$("#closeSessionButton");this.closeSessionButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.closeSessionButton.click($.proxy(function(){if(!this.closeSessionButton.linkbutton("options").disabled){this.listener.onCloseSession(this.rowValue);}},this));},show:function(listener){this.listener=listener;this.sessionsTable.datagrid("resize");},resize:function(){this.sessionsTable.datagrid("resize");},setSessions:function(value){this.sessions=value;this._sort(this.sortedColumn||"protocol",this.sortOrder||"asc");},_sort:function(name,order){this.sortedColumn=name;this.sortOrder=order;this.sessions.sort(this.sorter[name+"."+order]);this.sessionsTable.datagrid("loadData",this.sessions);this._resetButtons();this._restoreSelection();},_sortColumn:function(a,b,value){return value?value:window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},_clientProtocolOf:function(value,service){return jscape.Resources["protocol."+service.clientProtocol];},_serverProtocolOf:function(value,service){return jscape.Resources["protocol."+service.serverProtocol];},_uptimeOf:function(value,entry){var interval=new TimeInterval(entry.uptime);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.closeSessionButton.linkbutton("enable");},_rowUnselected:function(){if(this.sessionsTable.datagrid("getSelections").length===0){this._resetButtons();}},_resetButtons:function(){this.closeSessionButton.linkbutton("disable");},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}
this.sessionsTable.datagrid("getPanel").find("div.datagrid-body td[field] div.datagrid-cell:not(:empty)").tooltip({position:"top",content:function(){return $(this).html();}});},_restoreSelection:function(){if(this.row>=0){this.sessionsTable.datagrid("selectRow",this.row);}}});jscape.CloseSessionController=Class.extend({start:function(value,callback){this.rowValue=value;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["closeProxySessionDialog.title"],jscape.Resources["closeProxySessionDialog.message"].supplant(this.rowValue),$.proxy(function(confirmed){if(confirmed){this._closeSession();}},this));},_closeSession:function(){jscape.ApiClient.closeProxySession(this.rowValue.id,$.proxy(this._operationCompleted,this));},_operationCompleted:function(){showMessage(jscape.Resources["proxySessionClosedDialog.message"].supplant(this.rowValue));this.callback();}});