/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.ServicesController=Class.extend({init:function(page,controllers){this.page=page;this.controllers=controllers;},start:function(){this.page.show(this);$.each(this.controllers,function(index,controller){controller.start();});},onTabVisible:function(index){this.controllers[index].onVisible();}});jscape.ServicesPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true,onSelect:$.proxy(function(title,index){if(this.listener){this.listener.onTabVisible(index);}},this)});},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},selectTab:function(index){this.infoPanel.tabs("select",index);}});jscape.ServicesPanelController=Class.extend({init:function(panel,addServiceController,editServiceController,stopServiceController,clearServiceCacheController,deleteServiceController,autoUpdateInterval){this.panel=panel;this.addServiceController=addServiceController;this.editServiceController=editServiceController;this.stopServiceController=stopServiceController;this.clearServiceCacheController=clearServiceCacheController;this.deleteServiceController=deleteServiceController;this.autoUpdateInterval=autoUpdateInterval;},start:function(){this.panel.show(this);this._updateServices();},onVisible:function(){this.panel.resize();},onAddService:function(){this.addServiceController.start($.proxy(function(summary,startRequired){if(startRequired){this.onStartService(summary);}else{this._updateServices(true);}},this));},onEditService:function(service){this.editServiceController.start(service.id,$.proxy(function(summary,startRequired){if(startRequired){this.onStartService(summary);}else{this._updateServices(true);}},this));},onStartService:function(service){jscape.ApiClient.startProxyService(service.id,$.proxy(function(){this._serviceStarted(service);},this),$.proxy(function(){this._updateServices(true);},this));},onStopServices:function(services){this.stopServiceController.start(services,$.proxy(function(){this._updateServices(true);},this),$.proxy(function(){this._updateServices(true);},this));},onClearServicesCache:function(services){this.clearServiceCacheController.start(services);},onDeleteServices:function(services){this.deleteServiceController.start(services,$.proxy(function(){this._updateServices(true);},this));},_updateServices:function(showError){jscape.ApiClient.proxyServices($.proxy(this._servicesUpdated,this),showError);},_servicesUpdated:function(services){this.services=services;this.panel.setServices(this.services);this._scheduleNextServicesUpdate();},_scheduleNextServicesUpdate:function(){setTimeout($.proxy(function(){this._updateServices(false);},this),this.autoUpdateInterval);},_serviceStarted:function(service){showMessage(jscape.Resources["serviceStartedDialog.message"].supplant(service.localAddress));this._updateServices(true);}});jscape.ServicesPanel=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.servicesTable=$("#servicesTable");this.servicesTable.datagrid({fitColumns:true,remoteSort:true,sortName:"protocol",sortOrder:"asc",singleSelect:true,columns:[[{field:"clientProtocol",title:jscape.Resources["servicesPage.servicesTable.column.0"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._clientProtocolOf,this)},{field:"serverProtocol",title:jscape.Resources["servicesPage.servicesTable.column.1"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._serverProtocolOf,this)},{field:"localAddress",title:jscape.Resources["servicesPage.servicesTable.column.2"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.localAddress);}},{field:"remoteAddress",title:jscape.Resources["servicesPage.servicesTable.column.3"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return row.remoteAddress?"{host}:{port}".supplant(row.remoteAddress):"";}},{field:"clusterName",title:jscape.Resources["servicesPage.servicesTable.column.4"],width:15,halign:"left",align:"left",sortable:true},{field:"agentUsed",title:jscape.Resources["servicesPage.servicesTable.column.5"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._delegationStatusOf,this)},{field:"fipsModeEnabled",title:jscape.Resources["servicesPage.servicesTable.column.6"],width:10,halign:"center",align:"center",sortable:true,formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});}},{field:"state",title:jscape.Resources["servicesPage.servicesTable.column.7"],width:15,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._stateOf,this)},{field:"uptime",title:jscape.Resources["servicesPage.servicesTable.column.8"],width:20,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._uptimeOf,this)},{field:"currentConnections",title:jscape.Resources["servicesPage.servicesTable.column.9"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return row.currentConnectionCount;}},{field:"totalConnections",title:jscape.Resources["servicesPage.servicesTable.column.10"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return row.totalConnectionCount;}}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),onSortColumn:$.proxy(this._sort,this),onDblClickRow:$.proxy(function(){this.listener.onEditService(this.rowValue);},this)});this.sorter={"clientProtocol.asc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},this),"clientProtocol.desc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,b),this._clientProtocolOf(null,a));},this),"serverProtocol.asc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,a),this._serverProtocolOf(null,b));},this),"serverProtocol.desc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,b),this._serverProtocolOf(null,a));},this),"localAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.localAddress,b.localAddress));},this),"localAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.localAddress,a.localAddress));},this),"remoteAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.remoteAddress,b.remoteAddress));},this),"remoteAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.remoteAddress,a.remoteAddress));},this),"clusterName.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.clusterName,b.clusterName));},this),"clusterName.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.clusterName,a.clusterName));},this),"agentUsed.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(a.agentUsed,b.agentUsed));},this),"agentUsed.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(b.agentUsed,a.agentUsed));},this),"fipsModeEnabled.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(a.fipsModeEnabled,b.fipsModeEnabled));},this),"fipsModeEnabled.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(b.fipsModeEnabled,a.fipsModeEnabled));},this),"state.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(this._stateOf(null,a),this._stateOf(null,b)));},this),"state.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(this._stateOf(null,b),this._stateOf(null,a)));},this),"uptime.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.uptimeMillis,b.uptimeMillis));},this),"uptime.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.uptimeMillis,a.uptimeMillis));},this),"currentConnections.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.currentConnections,b.currentConnections));},this),"currentConnections.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.currentConnections,a.currentConnections));},this),"totalConnections.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.totalConnections,b.totalConnections));},this),"totalConnections.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.totalConnections,a.totalConnections));},this)};this.addServiceButton=$("#addServiceButton");this.addServiceButton.linkbutton({width:jscape.Resources.buttonSize()});this.addServiceButton.click($.proxy(function(){this.listener.onAddService();},this));this.editServiceButton=$("#editServiceButton");this.editServiceButton.linkbutton({width:jscape.Resources.buttonSize()});this.editServiceButton.click($.proxy(function(){if(!this.editServiceButton.linkbutton("options").disabled){this.listener.onEditService(this.rowValue);}},this));this.startServiceButton=$("#startServiceButton");this.startServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.startServiceButton.click($.proxy(function(){if(!this.startServiceButton.linkbutton("options").disabled){this.listener.onStartService(this.rowValue);}},this));this.stopServiceButton=$("#stopServiceButton");this.stopServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.stopServiceButton.click($.proxy(this._stop,this));this.clearServiceCacheButton=$("#clearServiceCacheButton");this.clearServiceCacheButton.linkbutton({width:jscape.Resources["servicesPage.servicesTab.clearServiceCacheButton.width"],disabled:true});this.clearServiceCacheButton.click($.proxy(this._clearCache,this));this.deleteServiceButton=$("#deleteServiceButton");this.deleteServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteServiceButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.servicesTable.datagrid("resize");},resize:function(){this.servicesTable.datagrid("resize");},setServices:function(value){this.services=value;this._sort(this.sortedColumn||"protocol",this.sortOrder||"asc");},_rowSelected:function(row,rowValue){this.row=row;this.rowValue=rowValue;if(this.rowValue){this.editServiceButton.linkbutton("enable");this.startServiceButton.linkbutton(rowValue.uptimeMillis?"disable":"enable");this.stopServiceButton.linkbutton(rowValue.uptimeMillis?"enable":"disable");this.clearServiceCacheButton.linkbutton(rowValue.clientProtocol==="HTTP"||rowValue.clientProtocol==="HTTPS"?"enable":"disable");this.deleteServiceButton.linkbutton("enable");}},_rowUnselected:function(){if(this.servicesTable.datagrid("getSelections").length===0){this._resetButtons();}},_sort:function(name,order){this.sortedColumn=name;this.sortOrder=order;this.services.sort(this.sorter[name+"."+order]);this.servicesTable.datagrid("loadData",this.services);this._resetButtons();this._restoreSelection();},_sortColumn:function(a,b,value){return value?value:window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},_restoreSelection:function(){if(!this.rowValue){return;}
var i;var length=this.services.length;var value;for(i=0;i<length;++i){value=this.services[i];if(value.id===this.rowValue.id){this.servicesTable.datagrid("selectRow",i);return;}}},_stop:function(){if(this.stopServiceButton.linkbutton("options").disabled){return;}
var values=this.servicesTable.datagrid("getSelections");if(values.length>0){this.listener.onStopServices(values);}},_clearCache:function(){if(this.clearServiceCacheButton.linkbutton("options").disabled){return;}
var selectedRows=this.servicesTable.datagrid("getSelections");var values=[];$.each(selectedRows,function(index,row){if(row.clientProtocol==="HTTP"||row.clientProtocol==="HTTPS"){values.push(row);}});if(values.length>0){this.listener.onClearServicesCache(values);}},_delete:function(){if(this.deleteServiceButton.linkbutton("options").disabled){return;}
var values=this.servicesTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteServices(values);}},_clientProtocolOf:function(value,service){return jscape.Resources["protocol."+service.clientProtocolAlias];},_serverProtocolOf:function(value,service){return jscape.Resources["protocol."+service.serverProtocolAlias];},_delegationStatusOf:function(value,service){return service.agentUsed?jscape.Resources["service.delegated"]:jscape.Resources["service.non-delegated"]},_stateOf:function(value,service){return service.uptimeMillis?jscape.Resources["service.started"]:service.errorMessage?jscape.Resources["service.stopped"]+": "+service.errorMessage:jscape.Resources["service.stopped"];},_uptimeOf:function(value,service){if(!service.uptimeMillis){return"";}
var interval=new TimeInterval(service.uptimeMillis);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_resetButtons:function(){this.editServiceButton.linkbutton("disable");this.startServiceButton.linkbutton("disable");this.stopServiceButton.linkbutton("disable");this.deleteServiceButton.linkbutton("disable");}});jscape.AddServiceController=Class.extend({DEFAULT_PORTS:{FTP:21,FTPS:21,FTPS_IMPLICIT:990,SFTP:22,HTTP:80,HTTPS:443,RAW:22,RAW_SSL:22,SSH_SFTP:22,SMTP:25,POP3:110,IMAP4:143,MYSQL:3306,UDP:3000},PROTOCOL_MAP:{SSH_SFTP:"RAW",SMTP:"RAW",POP3:"RAW",IMAP4:"RAW",MYSQL:"RAW"},init:function(dialog,controllerMap){this.dialog=dialog;this.controllerMap=controllerMap;this.parametersController=new jscape.ServiceParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onSubmit:function(){this.dialog.hide();var clientProtocol=this._resolveProtocol(this.dialog.getClientProtocol());var defaultClientPort=this._defaultPortOf(this.dialog.getClientProtocol());var serverProtocol=this._resolveProtocol(this.dialog.getServerProtocol());var defaultServerPort=this._defaultPortOf(this.dialog.getServerProtocol());var clusters=this._clustersFor(serverProtocol);var controllerKey="{clientProtocol}-{serverProtocol}".supplant({clientProtocol:clientProtocol,serverProtocol:serverProtocol});var controller=this.controllerMap[controllerKey];controller.start(clientProtocol,this.dialog.getClientProtocol(),defaultClientPort,serverProtocol,this.dialog.getServerProtocol(),defaultServerPort,this.addresses,this.keys,clusters,this.parameters.sslCipherSuites,$.proxy(this._serviceAdded,this));},onCancel:function(){this.dialog.hide();},_parametersLoaded:function(parameters,addresses,keys,clusters){this.parameters=parameters;this.addresses=addresses;this.keys=keys;this.clusters=clusters;this.dialog.reset();this.dialog.show(this);},_clustersFor:function(protocol){var ret=[];var i;var cluster;for(i=0;i<this.clusters.length;i++){cluster=this.clusters[i];if(protocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_serviceAdded:function(summary,startRequired){showMessage(jscape.Resources["serviceCreatedDialog.message"].supplant({clientProtocol:jscape.Resources["protocol."+summary.clientProtocolAlias],serverProtocol:jscape.Resources["protocol."+summary.serverProtocolAlias],host:summary.localAddress.host,port:summary.localAddress.port}));this.callback(summary,startRequired);},_resolveProtocol:function(protocol){return this.PROTOCOL_MAP[protocol]?this.PROTOCOL_MAP[protocol]:protocol;},_defaultPortOf:function(protocol){return this.DEFAULT_PORTS[protocol]?this.DEFAULT_PORTS[protocol]:1000;}});jscape.ServiceProtocolDialog=Class.extend({PROTOCOL_MAP:{FTP:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS_IMPLICIT",text:jscape.Resources["protocol.FTPS_IMPLICIT"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],FTPS:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS",text:jscape.Resources["protocol.FTPS"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],FTPS_IMPLICIT:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS_IMPLICIT",text:jscape.Resources["protocol.FTPS_IMPLICIT"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],HTTP:[{value:"HTTP",text:jscape.Resources["protocol.HTTP"]},{value:"HTTPS",text:jscape.Resources["protocol.HTTPS"]}],HTTPS:[{value:"HTTP",text:jscape.Resources["protocol.HTTP"]},{value:"HTTPS",text:jscape.Resources["protocol.HTTPS"]}],RAW:[{value:"RAW",text:jscape.Resources["protocol.RAW"]},{value:"RAW_SSL",text:jscape.Resources["protocol.RAW_SSL"]}],RAW_SSL:[{value:"RAW",text:jscape.Resources["protocol.RAW"]},{value:"RAW_SSL",text:jscape.Resources["protocol.RAW_SSL"]}],SSH_SFTP:[{value:"SSH_SFTP",text:jscape.Resources["protocol.SSH_SFTP"]}],SMTP:[{value:"SMTP",text:jscape.Resources["protocol.SMTP"]}],POP3:[{value:"POP3",text:jscape.Resources["protocol.POP3"]}],IMAP4:[{value:"IMAP4",text:jscape.Resources["protocol.IMAP4"]}],MYSQL:[{value:"MYSQL",text:jscape.Resources["protocol.MYSQL"]}],UDP:[{value:"UDP",text:jscape.Resources["protocol.UDP"]}]},init:function(){this.dialog=$("#serviceProtocolDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["serviceProtocolDialog.title"],width:jscape.Resources.intVal("serviceProtocolDialog.width"),height:jscape.Resources.intVal("serviceProtocolDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.clientProtocolBox=$("#clientProtocolBox");this.clientProtocolBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,onChange:$.proxy(this._clientProtocolSelected,this)});this.serverProtocolBox=$("#serverProtocolBox");this.serverProtocolBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.clientProtocolBox.focus();this._clientProtocolSelected(this.getClientProtocol());},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getClientProtocol:function(){return this.clientProtocolBox.combobox("getValue");},getServerProtocol:function(){return this.serverProtocolBox.combobox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_clientProtocolSelected:function(newValue){var serverProtocols=this.PROTOCOL_MAP[newValue];this.serverProtocolBox.combobox("clear");this.serverProtocolBox.combobox("loadData",serverProtocols);this.serverProtocolBox.combobox("select",serverProtocols[0].value);}});jscape.EditServiceController=Class.extend({init:function(controllerMap){this.controllerMap=controllerMap;this.parametersController=new jscape.ServiceParametersController();},start:function(id,callback){this.callback=callback;jscape.ApiClient.proxyServiceFor(id,$.proxy(this._serviceLoaded,this));},_serviceLoaded:function(data){this.data=data;this.parametersController.start($.proxy(this._parametersLoaded,this));},_parametersLoaded:function(parameters,addresses,keys,clusters){var controllerKey="{clientProtocol}-{serverProtocol}".supplant({clientProtocol:this.data.clientProtocol,serverProtocol:this.data.serverProtocol});var controller=this.controllerMap[controllerKey];controller.start(this.data,addresses,keys,this._clustersFor(this.data.serverProtocol,clusters),$.proxy(this._serviceUpdated,this));},_clustersFor:function(protocol,clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(protocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_serviceUpdated:function(summary,startRequired){showMessage(jscape.Resources["serviceUpdatedDialog.message"].supplant({clientProtocol:jscape.Resources["protocol."+summary.clientProtocolAlias],serverProtocol:jscape.Resources["protocol."+summary.serverProtocolAlias],host:summary.localAddress.host,port:summary.localAddress.port}));this.callback(summary,startRequired);}});jscape.AddFtpServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setCommandTimeout(60000);this.dialog.setDataTimeout(60000);this.dialog.setDataTransferBufferSize(65536);this.dialog.setPortRange({});this.dialog.setBlockBounceAttack(true);this.dialog.setBlockPasvAttack(true);this.dialog.setShutdownSslServer(true);this.dialog.setShutdownSslClient(true);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp()}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.AddFtpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpServiceDialog.title"],width:jscape.Resources.intVal("addFtpServiceDialog.width"),height:jscape.Resources.intVal("addFtpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#addFtpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addFtpServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpHost",jscape.Resources["addFtpServiceDialog.error.emptyLocalHost.message"])]});this.localPortField=$("#addFtpServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addFtpServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addFtpServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpRemoteHost",jscape.Resources["addFtpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addFtpServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addFtpServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addFtpServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addFtpServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addFtpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#addFtpServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#addFtpServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#addFtpServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#addFtpServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#addFtpServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#addFtpServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#addFtpServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#addFtpServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{addFtpServiceDialogValidPassiveRegexpvalidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["addFtpServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#addFtpServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"addFtpServiceDialogValidPassiveRegexpvalidPassiveRegexp"});this.passivePortBox=$("#addFtpServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#addFtpServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#addFtpServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#addFtpServiceDialogBlockBounceBox");this.blockPasvBox=$("#addFtpServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#addFtpServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#addFtpServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#addFtpServiceDialogIgnorePasvIpBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.EditFtpServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setCommandTimeout(this.data.ftpData.commandConnectionTimeoutMillis);this.dialog.setDataTimeout(this.data.ftpData.dataConnectionTimeoutMillis);this.dialog.setDataChannelBufferSize(this.data.ftpData.dataSocketBufferSizeBytes);this.dialog.setDataTransferBufferSize(this.data.ftpData.dataTransferBufferSizeBytes);this.dialog.setPassiveIp(this.data.ftpData.passiveTransferConfiguration.outerIp);this.dialog.setPassiveIpRegexp(this.data.ftpData.passiveTransferConfiguration.innerIpRegexp);this.dialog.setPortRange(this.data.ftpData.passiveTransferConfiguration);this.dialog.setBlockBounceAttack(this.data.ftpData.blockBounceAttack);this.dialog.setBlockPasvAttack(this.data.ftpData.blockPasvAttack);this.dialog.setShutdownSslServer(this.data.ftpData.shutdownServerSsl);this.dialog.setShutdownSslClient(this.data.ftpData.shutdownClientSsl);this.dialog.setIgnorePasvIp(this.data.ftpData.ignoreServerPassiveIp);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp()},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.EditFtpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editFtpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editFtpServiceDialog.title"],width:jscape.Resources.intVal("editFtpServiceDialog.width"),height:jscape.Resources.intVal("editFtpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.saveStart.text"],width:jscape.Resources.intVal("button.saveStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#editFtpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editFtpServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredEditFtpHost",jscape.Resources["editFtpServiceDialog.error.emptyLocalHost.message"])]});this.localPortField=$("#editFtpServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editFtpServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editFtpServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditFtpRemoteHost",jscape.Resources["editFtpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editFtpServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editFtpServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editFtpServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editFtpServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editFtpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#editFtpServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#editFtpServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#editFtpServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#editFtpServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#editFtpServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#editFtpServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#editFtpServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#editFtpServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{editFtpServiceDialogValidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["editFtpServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#editFtpServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"editFtpServiceDialogValidPassiveRegexp"});this.passivePortBox=$("#editFtpServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#editFtpServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#editFtpServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#editFtpServiceDialogBlockBounceBox");this.blockPasvBox=$("#editFtpServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#editFtpServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#editFtpServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#editFtpServiceDialogIgnorePasvIpBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editFtpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},setIgnorePasvIp:function(value){this.ignorePasvIpBox.prop("checked",value);},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.AddFtpExplicitServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.ciphers=sslCiphers;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setCommandTimeout(60000);this.dialog.setDataTimeout(60000);this.dialog.setDataTransferBufferSize(65536);this.dialog.setPortRange({});this.dialog.setBlockBounceAttack(true);this.dialog.setBlockPasvAttack(true);this.dialog.setShutdownSslServer(true);this.dialog.setShutdownSslClient(true);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp(),cipherSuites:this.ciphers}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.AddFtpExplicitServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpExplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpExplicitServiceDialog.title"],width:jscape.Resources.intVal("addFtpExplicitServiceDialog.width"),height:jscape.Resources.intVal("addFtpExplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addFtpExplicitServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#addFtpExplicitServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#addFtpExplicitServiceDialogAddButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#addFtpExplicitServiceDialogAddStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.addStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#addFtpExplicitServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#addFtpExplicitServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addFtpExplicitServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpExplicitHost",jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addFtpExplicitServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addFtpExplicitServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addFtpExplicitServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpExplicitRemoteHost",jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addFtpExplicitServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addFtpExplicitServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addFtpExplicitServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addFtpExplicitServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addFtpExplicitServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#addFtpExplicitServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#addFtpExplicitServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#addFtpExplicitServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#addFtpExplicitServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#addFtpExplicitServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#addFtpExplicitServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#addFtpExplicitServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#addFtpExplicitServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#addFtpExplicitServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#addFtpExplicitServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#addFtpExplicitServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{addFtpExplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["addFtpExplicitServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#addFtpExplicitServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"addFtpExplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp"});this.passivePortBox=$("#addFtpExplicitServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#addFtpExplicitServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#addFtpExplicitServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#addFtpExplicitServiceDialogBlockBounceBox");this.blockPasvBox=$("#addFtpExplicitServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#addFtpExplicitServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#addFtpExplicitServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#addFtpExplicitServiceDialogIgnorePasvIpBox");this.fipsModeBox=$("#addFtpExplicitServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpExplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.EditFtpExplicitServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.ciphers=this.data.ftpData.cipherSuites;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setKey(this.data.keyAlias);this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setCommandTimeout(this.data.ftpData.commandConnectionTimeoutMillis);this.dialog.setDataTimeout(this.data.ftpData.dataConnectionTimeoutMillis);this.dialog.setDataChannelBufferSize(this.data.ftpData.dataSocketBufferSizeBytes);this.dialog.setDataTransferBufferSize(this.data.ftpData.dataTransferBufferSizeBytes);this.dialog.setPassiveIp(this.data.ftpData.passiveTransferConfiguration.outerIp);this.dialog.setPassiveIpRegexp(this.data.ftpData.passiveTransferConfiguration.innerIpRegexp);this.dialog.setPortRange(this.data.ftpData.passiveTransferConfiguration);this.dialog.setBlockBounceAttack(this.data.ftpData.blockBounceAttack);this.dialog.setBlockPasvAttack(this.data.ftpData.blockPasvAttack);this.dialog.setShutdownSslServer(this.data.ftpData.shutdownServerSsl);this.dialog.setShutdownSslClient(this.data.ftpData.shutdownClientSsl);this.dialog.setIgnorePasvIp(this.data.ftpData.ignoreServerPassiveIp);this.dialog.setFipsModeRequired(this.data.fipsModeRequired);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp(),cipherSuites:this.ciphers},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.EditFtpExplicitServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editFtpExplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editFtpExplicitServiceDialog.title"],width:jscape.Resources.intVal("editFtpExplicitServiceDialog.width"),height:jscape.Resources.intVal("editFtpExplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editFtpExplicitServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#editFtpExplicitServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#editFtpExplicitServiceDialogSaveButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#editFtpExplicitServiceDialogSaveStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.saveStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#editFtpExplicitServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#editFtpExplicitServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editFtpExplicitServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredEditFtpExplicitHost",jscape.Resources["editFtpExplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#editFtpExplicitServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editFtpExplicitServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editFtpExplicitServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditFtpExplicitRemoteHost",jscape.Resources["editFtpExplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editFtpExplicitServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editFtpExplicitServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editFtpExplicitServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editFtpExplicitServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editFtpExplicitServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#editFtpExplicitServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#editFtpExplicitServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#editFtpExplicitServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#editFtpExplicitServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#editFtpExplicitServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#editFtpExplicitServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#editFtpExplicitServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#editFtpExplicitServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#editFtpExplicitServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpExplicitServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#editFtpExplicitServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#editFtpExplicitServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{editFtpExplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["editFtpExplicitServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#editFtpExplicitServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"editFtpExplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp"});this.passivePortBox=$("#editFtpExplicitServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#editFtpExplicitServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#editFtpExplicitServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#editFtpExplicitServiceDialogBlockBounceBox");this.blockPasvBox=$("#editFtpExplicitServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#editFtpExplicitServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#editFtpExplicitServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#editFtpExplicitServiceDialogIgnorePasvIpBox");this.fipsModeBox=$("#editFtpExplicitServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editFtpExplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},setFipsModeRequired:function(value){this.fipsModeBox.prop("checked",value);},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},setIgnorePasvIp:function(value){this.ignorePasvIpBox.prop("checked",value);},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.AddFtpImplicitServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.ciphers=sslCiphers;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setCommandTimeout(60000);this.dialog.setDataTimeout(60000);this.dialog.setDataTransferBufferSize(65536);this.dialog.setPortRange({});this.dialog.setBlockBounceAttack(true);this.dialog.setBlockPasvAttack(true);this.dialog.setShutdownSslServer(true);this.dialog.setShutdownSslClient(true);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp(),cipherSuites:this.ciphers}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.AddFtpImplicitServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpImplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpImplicitServiceDialog.title"],width:jscape.Resources.intVal("addFtpImplicitServiceDialog.width"),height:jscape.Resources.intVal("addFtpImplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addFtpImplicitServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#addFtpImplicitServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#addFtpImplicitServiceDialogAddButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#addFtpImplicitServiceDialogAddStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.addStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#addFtpImplicitServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#addFtpImplicitServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addFtpImplicitServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpImplicitHost",jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addFtpImplicitServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addFtpImplicitServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addFtpImplicitServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpImplicitRemoteHost",jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addFtpImplicitServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addFtpImplicitServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addFtpImplicitServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addFtpImplicitServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addFtpImplicitServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#addFtpImplicitServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#addFtpImplicitServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#addFtpImplicitServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#addFtpImplicitServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#addFtpImplicitServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#addFtpImplicitServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#addFtpImplicitServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#addFtpImplicitServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#addFtpImplicitServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#addFtpImplicitServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#addFtpImplicitServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{addFtpImplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["addFtpImplicitServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#addFtpImplicitServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"addFtpImplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp"});this.passivePortBox=$("#addFtpImplicitServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#addFtpImplicitServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#addFtpImplicitServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#addFtpImplicitServiceDialogBlockBounceBox");this.blockPasvBox=$("#addFtpImplicitServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#addFtpImplicitServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#addFtpImplicitServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#addFtpImplicitServiceDialogIgnorePasvIpBox");this.fipsModeBox=$("#addFtpImplicitServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpImplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));if(clientProtocol==="FTP"){this.fipsModeBox.parent().hide();}else{this.fipsModeBox.parent().show();}},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.EditFtpImplicitServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.ciphers=this.data.ftpData.cipherSuites;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setKey(this.data.keyAlias);this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setCommandTimeout(this.data.ftpData.commandConnectionTimeoutMillis);this.dialog.setDataTimeout(this.data.ftpData.dataConnectionTimeoutMillis);this.dialog.setDataChannelBufferSize(this.data.ftpData.dataSocketBufferSizeBytes);this.dialog.setDataTransferBufferSize(this.data.ftpData.dataTransferBufferSizeBytes);this.dialog.setPassiveIp(this.data.ftpData.passiveTransferConfiguration.outerIp);this.dialog.setPassiveIpRegexp(this.data.ftpData.passiveTransferConfiguration.innerIpRegexp);this.dialog.setPortRange(this.data.ftpData.passiveTransferConfiguration);this.dialog.setBlockBounceAttack(this.data.ftpData.blockBounceAttack);this.dialog.setBlockPasvAttack(this.data.ftpData.blockPasvAttack);this.dialog.setShutdownSslServer(this.data.ftpData.shutdownServerSsl);this.dialog.setShutdownSslClient(this.data.ftpData.shutdownClientSsl);this.dialog.setIgnorePasvIp(this.data.ftpData.ignoreServerPassiveIp);this.dialog.setFipsModeRequired(this.data.fipsModeRequired);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),ignoreServerPassiveIp:this.dialog.isIgnorePasvIp(),cipherSuites:this.ciphers},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.EditFtpImplicitServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editFtpImplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editFtpImplicitServiceDialog.title"],width:jscape.Resources.intVal("editFtpImplicitServiceDialog.width"),height:jscape.Resources.intVal("editFtpImplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editFtpImplicitServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#editFtpImplicitServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#editFtpImplicitServiceDialogSaveButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#editFtpImplicitServiceDialogSaveStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.saveStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#editFtpImplicitServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#editFtpImplicitServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editFtpImplicitServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredEditFtpImplicitHost",jscape.Resources["editFtpImplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#editFtpImplicitServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editFtpImplicitServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editFtpImplicitServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditFtpImplicitRemoteHost",jscape.Resources["editFtpImplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editFtpImplicitServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editFtpImplicitServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editFtpImplicitServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editFtpImplicitServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editFtpImplicitServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#editFtpImplicitServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#editFtpImplicitServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#editFtpImplicitServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#editFtpImplicitServiceDialogConnectionDelegationBox");this.commandTimeoutField=$("#editFtpImplicitServiceDialogCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyCommandTimeout.message"]});this.dataTimeoutField=$("#editFtpImplicitServiceDialogDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyDataTimeout.message"]});this.dataChannelBufferSizeEnabledBox=$("#editFtpImplicitServiceDialogDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#editFtpImplicitServiceDialogDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#editFtpImplicitServiceDialogDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editFtpImplicitServiceDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#editFtpImplicitServiceDialogPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#editFtpImplicitServiceDialogPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{editFtpImplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["editFtpImplicitServiceDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#editFtpImplicitServiceDialogPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"editFtpImplicitServiceDialogValidPassiveRegexpvalidPassiveRegexp"});this.passivePortBox=$("#editFtpImplicitServiceDialogPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#editFtpImplicitServiceDialogPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#editFtpImplicitServiceDialogPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#editFtpImplicitServiceDialogBlockBounceBox");this.blockPasvBox=$("#editFtpImplicitServiceDialogBlockPasvBox");this.shutdownSslServerBox=$("#editFtpImplicitServiceDialogShutdownSslServerBox");this.shutdownSslClientBox=$("#editFtpImplicitServiceDialogShutdownSslClientBox");this.ignorePasvIpBox=$("#editFtpImplicitServiceDialogIgnorePasvIpBox");this.fipsModeBox=$("#editFtpImplicitServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._dataChannelBufferSizeBoxClicked();this._regexpBoxClicked();this._portBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editFtpImplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));if(clientProtocol==="FTP"){this.fipsModeBox.parent().hide();}else{this.fipsModeBox.parent().show();}},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},setFipsModeRequired:function(value){this.fipsModeBox.prop("checked",value);},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},setIgnorePasvIp:function(value){this.ignorePasvIpBox.prop("checked",value);},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.AddRawServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setTimeout(60000);this.dialog.setBufferSize(65536);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),rawData:{connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),bufferSize:this.dialog.getBufferSize()}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.AddRawServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addRawServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRawServiceDialog.title"],width:jscape.Resources.intVal("addRawServiceDialog.width"),height:jscape.Resources.intVal("addRawServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#addRawServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addRawServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("addRawServiceDialogLocaHost",jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addRawServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addRawServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addRawServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddRawRemoteHost",jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addRawServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addRawServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addRawServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addRawServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addRawServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#addRawServiceDialogConnectionDelegationBox");this.timeoutField=$("#addRawServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyTimeout.message"]});this.channelBufferSizeEnabledBox=$("#addRawServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#addRawServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyChannelBufferSize.message"]});this.bufferSizeField=$("#addRawServiceDialogBufferSizeField");this.bufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyBufferSize.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addRawServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getBufferSize:function(){return parseInt(this.bufferSizeField.numberspinner("getValue"),10);},setBufferSize:function(value){this.bufferSizeField.numberspinner("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.EditRawServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setTimeout(this.data.rawData.connectionTimeoutMillis);this.dialog.setChannelBufferSize(this.data.rawData.socketBufferSizeBytes);this.dialog.setBufferSize(this.data.rawData.bufferSize);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),rawData:{connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),bufferSize:this.dialog.getBufferSize()},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.EditRawServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editRawServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editRawServiceDialog.title"],width:jscape.Resources.intVal("editRawServiceDialog.width"),height:jscape.Resources.intVal("editRawServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.saveStart.text"],width:jscape.Resources.intVal("button.saveStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#editRawServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editRawServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("editRawServiceDialogLocalHost",jscape.Resources["editRawServiceDialog.error.emptyLocalHost.message"])]});this.localPortField=$("#editRawServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editRawServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editRawServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditRawRemoteHost",jscape.Resources["editRawServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editRawServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editRawServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editRawServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editRawServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editRawServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#editRawServiceDialogConnectionDelegationBox");this.timeoutField=$("#editRawServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyTimeout.message"]});this.channelBufferSizeEnabledBox=$("#editRawServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#editRawServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyChannelBufferSize.message"]});this.bufferSizeField=$("#editRawServiceDialogBufferSizeField");this.bufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editRawServiceDialog.error.emptyBufferSize.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editRawServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getBufferSize:function(){return parseInt(this.bufferSizeField.numberspinner("getValue"),10);},setBufferSize:function(value){this.bufferSizeField.numberspinner("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.AddRawSslServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.ciphers=sslCiphers;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setTimeout(60000);this.dialog.setBufferSize(65536);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),rawData:{connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),bufferSize:this.dialog.getBufferSize(),cipherSuites:this.ciphers}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.AddRawSslServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addRawSslServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRawSslServiceDialog.title"],width:jscape.Resources.intVal("addRawSslServiceDialog.width"),height:jscape.Resources.intVal("addRawSslServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addRawSslServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#addRawSslServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#addRawSslServiceDialogAddButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#addRawSslServiceDialogAddStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.addStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#addRawSslServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#addRawSslServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addRawSslServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("addRawSslServiceDialogLocalHost",jscape.Resources["addRawSslServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addRawSslServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addRawSslServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addRawSslServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddRawSslRemoteHost",jscape.Resources["addRawSslServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addRawSslServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addRawSslServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addRawSslServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addRawSslServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addRawSslServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#addRawSslServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#addRawSslServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#addRawSslServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#addRawSslServiceDialogConnectionDelegationBox");this.timeoutField=$("#addRawSslServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyTimeout.message"]});this.channelBufferSizeEnabledBox=$("#addRawSslServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#addRawSslServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyChannelBufferSize.message"]});this.bufferSizeField=$("#addRawSslServiceDialogBufferSizeField");this.bufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyBufferSize.message"]});this.fipsModeBox=$("#addRawSslServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addRawSslServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getBufferSize:function(){return parseInt(this.bufferSizeField.numberspinner("getValue"),10);},setBufferSize:function(value){this.bufferSizeField.numberspinner("setValue",value);},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.EditRawSslServiceController=Class.extend({init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.sslCiphersController=sslCiphersController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.ciphers=this.data.rawData.cipherSuites;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setKey(this.data.keyAlias);this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setTimeout(this.data.rawData.connectionTimeoutMillis);this.dialog.setChannelBufferSize(this.data.rawData.socketBufferSizeBytes);this.dialog.setBufferSize(this.data.rawData.bufferSize);this.dialog.setFipsModeRequired(this.data.fipsModeRequired);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),rawData:{connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),bufferSize:this.dialog.getBufferSize(),cipherSuites:this.ciphers},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.EditRawSslServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editRawSslServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editRawSslServiceDialog.title"],width:jscape.Resources.intVal("editRawSslServiceDialog.width"),height:jscape.Resources.intVal("editRawSslServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editRawSslServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#editRawSslServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.addButton=$("#editRawSslServiceDialogSaveButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#editRawSslServiceDialogSaveStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.saveStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#editRawSslServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#editRawSslServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editRawSslServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("editRawSslServiceDialogLocalHost",jscape.Resources["editRawSslServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#editRawSslServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editRawSslServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editRawSslServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditRawSslRemoteHost",jscape.Resources["editRawSslServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editRawSslServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editRawSslServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editRawSslServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editRawSslServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editRawSslServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#editRawSslServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#editRawSslServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#editRawSslServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#editRawSslServiceDialogConnectionDelegationBox");this.timeoutField=$("#editRawSslServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyTimeout.message"]});this.channelBufferSizeEnabledBox=$("#editRawSslServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#editRawSslServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyChannelBufferSize.message"]});this.bufferSizeField=$("#editRawSslServiceDialogBufferSizeField");this.bufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editRawSslServiceDialog.error.emptyBufferSize.message"]});this.fipsModeBox=$("#editRawSslServiceDialogFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editRawSslServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getBufferSize:function(){return parseInt(this.bufferSizeField.numberspinner("getValue"),10);},setBufferSize:function(value){this.bufferSizeField.numberspinner("setValue",value);},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},setFipsModeRequired:function(value){this.fipsModeBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.AddUdpServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),udpData:{connectionTimeoutMillis:this.dialog.getConnectionTimeout()}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.AddUdpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addUdpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addUdpServiceDialog.title"],width:jscape.Resources.intVal("addUdpServiceDialog.width"),height:jscape.Resources.intVal("addUdpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#addUdpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#udpLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddUdpHost",jscape.Resources["addUdpServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#udpLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#udpRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#udpRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddUdpRemoteHost",jscape.Resources["addUdpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#udpRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#udpRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#udpClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#udpClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150,});this.addClusterButton=$("#addUdpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#udpConnectionDelegationBox");this.timeoutField=$("#addUdpServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyConnectionTimeout.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addUdpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},getConnectionTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setConnectionTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.EditUdpServiceController=Class.extend({init:function(dialogBuilder,addClusterController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setClusters(clusters);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setConnectionTimeout(this.data.udpData.connectionTimeoutMillis);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),udpData:{connectionTimeoutMillis:this.dialog.getConnectionTimeout()},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;}});jscape.EditUdpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editUdpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editUdpServiceDialog.title"],width:jscape.Resources.intVal("editUdpServiceDialog.width"),height:jscape.Resources.intVal("editUdpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.saveStart.text"],width:jscape.Resources.intVal("button.saveStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.panel=$("#editUdpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editUdpLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredEditUdpHost",jscape.Resources["editUdpServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#editUdpLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editUdpRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editUdpRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requirededitUdpRemoteHost",jscape.Resources["editUdpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editUdpRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editUdpRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editUdpClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editUdpClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150,});this.addClusterButton=$("#editUdpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#editUdpConnectionDelegationBox");this.timeoutField=$("#editUdpServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editUdpServiceDialog.error.emptyConnectionTimeout.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editUdpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},getConnectionTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setConnectionTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddHttpServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialogBuilder,addClusterController,rulesController,testParametersController,selectCacheDirectoryController,rewriteRulesController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.rulesController=rulesController;this.testParametersController=testParametersController;this.selectCacheDirectoryController=selectCacheDirectoryController;this.rewriteRulesController=rewriteRulesController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.defaultClientPort=defaultClientPort;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.defaultServerPort=defaultServerPort;this.addresses=addresses;this.clusters=clusters;this.callback=callback;this.testParameters=this.DEFAULT_TEST_PARAMETERS;this.rules=[];this.selectedRules=[];if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setLocalPort(this.defaultClientPort);this.dialog.setRemotePort(this.defaultServerPort);this.dialog.setClusters(this.clusters);this.dialog.setTimeout(60000);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onSelectRules:function(){this.rulesController.start(this.rules,this.selectedRules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},onSelectCacheDirectory:function(){this.selectCacheDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setCacheDirectory(path);},this));},onChangeRewriteRules:function(){this.rewriteRulesController.start(this.rules,$.proxy(this._rulesUpdated,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this.selectedRules:[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null,connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),natHost:this.dialog.getNatHost(),cache:this.dialog.getCache(),regexpRewriteRules:this.rules}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.selectedRules=rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_rulesUpdated:function(rules){this.rules=rules;var selectedRules=[];$.each(this.rules,$.proxy(function(index,rule){if(this.selectedRules.indexOf(rule.name)!==-1){selectedRules.push(rule.name);}},this));this.selectedRules=selectedRules;}});jscape.AddHttpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addHttpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addHttpServiceDialog.title"],width:jscape.Resources.intVal("addHttpServiceDialog.width"),height:jscape.Resources.intVal("addHttpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addHttpServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.rulesButton=$("#addHttpServiceDialogRulesButton");this.rulesButton.linkbutton({width:jscape.Resources.intVal("addHttpServiceDialog.rulesButton.width")});this.rulesButton.click($.proxy(function(){this.listener.onChangeRewriteRules();},this));this.addButton=$("#addHttpServiceDialogAddButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#addHttpServiceDialogAddStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.addStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#addHttpServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#addHttpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addHttpServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("addHttpServiceDialogLocalHost",jscape.Resources["addHttpServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addHttpServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addHttpServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addHttpServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddHttpRemoteHost",jscape.Resources["addHttpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addHttpServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addHttpServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addHttpServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addHttpServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addHttpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#addHttpServiceDialogConnectionDelegationBox");this.rewriteRulesBox=$("#addHttpServiceDialogUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._onRewriteRulesBoxClick,this));this.rewriteRulesButton=$("#addHttpServiceDialogRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("addHttpServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#addHttpServiceDialogTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#addHttpServiceDialogTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("addHttpServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));this.timeoutField=$("#addHttpServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyConnectionTimeout.message"]});this.channelBufferSizeEnabledBox=$("#addHttpServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#addHttpServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyChannelBufferSize.message"]});this.natHostField=$("#addHttpServiceDialogNatHostField");this.natHostField.textbox({});this.cachedBox=$("#addHttpServiceDialogCacheBox");this.cachedBox.click($.proxy(this._cacheBoxClicked,this));this.cacheDirectoryField=$("#addHttpServiceDialogCacheDirectoryField");this.cacheDirectoryField.textbox({required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyCacheDirectory.message"],validType:[requiredFieldRule("addHttpServiceDialogCache",jscape.Resources["addHttpServiceDialog.error.emptyCacheDirectory.message"])]});this.selectCacheDirectoryButton=$("#addHttpServiceDialogCacheDirectoryButton");this.selectCacheDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectCacheDirectoryButton.click($.proxy(function(){if(!this.selectCacheDirectoryButton.linkbutton("options").disabled){this.listener.onSelectCacheDirectory();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this._cacheBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addHttpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getNatHost:function(){return this.natHostField.textbox("getValue").trim();},setNatHost:function(value){this.natHostField.textbox("setValue",value);},getCache:function(){if(this.cachedBox.prop("checked")){return{directory:this.cacheDirectoryField.textbox("getValue").trim()};}
return null;},setCache:function(value){if(value){this.cachedBox.prop("checked",true);this.cacheDirectoryField.textbox("setValue",value.directory);this.cacheDirectoryField.textbox("validate");}else{this.cachedBox.prop("checked",false);this.cacheDirectoryField.textbox("setValue","");}
this._cacheBoxClicked();},setCacheDirectory:function(value){this.cacheDirectoryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_onRewriteRulesBoxClick:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_cacheBoxClicked:function(){var enabled=this.cachedBox.prop("checked");this.cacheDirectoryField.textbox(enabled?"enable":"disable");this.cacheDirectoryField.textbox(enabled?"enableValidation":"disableValidation");this.selectCacheDirectoryButton.linkbutton(enabled?"enable":"disable");}});jscape.EditHttpServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialogBuilder,addClusterController,rulesController,testParametersController,selectCacheDirectoryController,rewriteRulesController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.rulesController=rulesController;this.testParametersController=testParametersController;this.selectCacheDirectoryController=selectCacheDirectoryController;this.rewriteRulesController=rewriteRulesController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.addresses=addresses;this.clusters=clusters;this.callback=callback;this.testParameters=this.data.httpData.testParameters?this.data.httpData.testParameters:this.DEFAULT_TEST_PARAMETERS;this.rules=this.data.httpData.regexpRewriteRules;this.selectedRules=this.data.httpData.rewriteRules;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setClusters(this.clusters);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setUseRewriteRules(this.data.httpData.rewriteRules.length>0);this.dialog.setUseTestParameters(this.data.httpData.testParameters);this.dialog.setTimeout(this.data.httpData.connectionTimeoutMillis);this.dialog.setChannelBufferSize(this.data.httpData.socketBufferSizeBytes);this.dialog.setNatHost(this.data.httpData.natHost);this.dialog.setCache(this.data.httpData.cache);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onSelectRules:function(){this.rulesController.start(this.rules,this.selectedRules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},onSelectCacheDirectory:function(){this.selectCacheDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setCacheDirectory(path);},this));},onChangeRewriteRules:function(){this.rewriteRulesController.start(this.rules,$.proxy(this._rulesUpdated,this));},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this.selectedRules:[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null,connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),natHost:this.dialog.getNatHost(),cache:this.dialog.getCache(),regexpRewriteRules:this.rules},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.selectedRules=rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_rulesUpdated:function(rules){this.rules=rules;var selectedRules=[];$.each(this.rules,$.proxy(function(index,rule){if(this.selectedRules.indexOf(rule.name)!==-1){selectedRules.push(rule.name);}},this));this.selectedRules=selectedRules;}});jscape.EditHttpServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editHttpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editHttpServiceDialog.title"],width:jscape.Resources.intVal("editHttpServiceDialog.width"),height:jscape.Resources.intVal("editHttpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editHttpServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.rulesButton=$("#editHttpServiceDialogRulesButton");this.rulesButton.linkbutton({width:jscape.Resources.intVal("editHttpServiceDialog.rulesButton.width")});this.rulesButton.click($.proxy(function(){this.listener.onChangeRewriteRules();},this));this.addButton=$("#editHttpServiceDialogSaveButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#editHttpServiceDialogSaveStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.saveStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#editHttpServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#editHttpServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editHttpServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("editHttpServiceDialogLocalHost",jscape.Resources["editHttpServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#editHttpServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editHttpServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editHttpServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditHttpRemoteHost",jscape.Resources["editHttpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editHttpServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editHttpServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editHttpServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editHttpServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editHttpServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.connectionDelegationBox=$("#editHttpServiceDialogConnectionDelegationBox");this.rewriteRulesBox=$("#editHttpServiceDialogUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._onRewriteRulesBoxClick,this));this.rewriteRulesButton=$("#editHttpServiceDialogRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("editHttpServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#editHttpServiceDialogTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#editHttpServiceDialogTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("editHttpServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));this.timeoutField=$("#editHttpServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyConnectionTimeout.message"]});this.channelBufferSizeEnabledBox=$("#editHttpServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#editHttpServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyChannelBufferSize.message"]});this.natHostField=$("#editHttpServiceDialogNatHostField");this.natHostField.textbox({});this.cachedBox=$("#editHttpServiceDialogCacheBox");this.cachedBox.click($.proxy(this._cacheBoxClicked,this));this.cacheDirectoryField=$("#editHttpServiceDialogCacheDirectoryField");this.cacheDirectoryField.textbox({required:true,missingMessage:jscape.Resources["editHttpServiceDialog.error.emptyCacheDirectory.message"],validType:[requiredFieldRule("editHttpServiceDialogCache",jscape.Resources["editHttpServiceDialog.error.emptyCacheDirectory.message"])]});this.selectCacheDirectoryButton=$("#editHttpServiceDialogCacheDirectoryButton");this.selectCacheDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectCacheDirectoryButton.click($.proxy(function(){if(!this.selectCacheDirectoryButton.linkbutton("options").disabled){this.listener.onSelectCacheDirectory();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this._cacheBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editHttpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},setUseRewriteRules:function(value){this.rewriteRulesBox.prop("checked",value);this._onRewriteRulesBoxClick();},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},setUseTestParameters:function(value){this.testParametersBox.prop("checked",value);this._onTestParametersBoxClick();},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getNatHost:function(){return this.natHostField.textbox("getValue").trim();},setNatHost:function(value){this.natHostField.textbox("setValue",value);},getCache:function(){if(this.cachedBox.prop("checked")){return{directory:this.cacheDirectoryField.textbox("getValue").trim()};}
return null;},setCache:function(value){if(value){this.cachedBox.prop("checked",true);this.cacheDirectoryField.textbox("setValue",value.directory);this.cacheDirectoryField.textbox("validate");}else{this.cachedBox.prop("checked",false);this.cacheDirectoryField.textbox("setValue","");}
this._cacheBoxClicked();},setCacheDirectory:function(value){this.cacheDirectoryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_onRewriteRulesBoxClick:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_cacheBoxClicked:function(){var enabled=this.cachedBox.prop("checked");this.cacheDirectoryField.textbox(enabled?"enable":"disable");this.cacheDirectoryField.textbox(enabled?"enableValidation":"disableValidation");this.selectCacheDirectoryButton.linkbutton(enabled?"enable":"disable");}});jscape.AddHttpsServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,rulesController,testParametersController,selectCacheDirectoryController,rewriteRulesController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.rulesController=rulesController;this.testParametersController=testParametersController;this.selectCacheDirectoryController=selectCacheDirectoryController;this.rewriteRulesController=rewriteRulesController;this.sslCiphersController=sslCiphersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,sslCiphers,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.defaultClientPort=defaultClientPort;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.defaultServerPort=defaultServerPort;this.addresses=addresses;this.keys=keys;this.clusters=clusters;this.ciphers=sslCiphers;this.callback=callback;this.testParameters=this.DEFAULT_TEST_PARAMETERS;this.rules=[];this.selectedRules=[];if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setLocalPort(this.defaultClientPort);this.dialog.setRemotePort(this.defaultServerPort);this.dialog.setClusters(this.clusters);this.dialog.setKeys(this.keys);this.dialog.setTimeout(60000);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectRules:function(){this.rulesController.start(this.rules,this.selectedRules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},onSelectCacheDirectory:function(){this.selectCacheDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setCacheDirectory(path);},this));},onChangeRewriteRules:function(){this.rewriteRulesController.start(this.rules,$.proxy(this._rulesUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this.selectedRules:[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null,connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),natHost:this.dialog.getNatHost(),cache:this.dialog.getCache(),regexpRewriteRules:this.rules,cipherSuites:this.ciphers}};jscape.ApiClient.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.selectedRules=rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_rulesUpdated:function(rules){this.rules=rules;var selectedRules=[];$.each(this.rules,$.proxy(function(index,rule){if(this.selectedRules.indexOf(rule.name)!==-1){selectedRules.push(rule.name);}},this));this.selectedRules=selectedRules;},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.AddHttpsServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addHttpsServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addHttpsServiceDialog.title"],width:jscape.Resources.intVal("addHttpsServiceDialog.width"),height:jscape.Resources.intVal("addHttpsServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addHttpsServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#addHttpsServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.rulesButton=$("#addHttpsServiceDialogRulesButton");this.rulesButton.linkbutton({width:jscape.Resources.intVal("addHttpsServiceDialog.rulesButton.width")});this.rulesButton.click($.proxy(function(){this.listener.onChangeRewriteRules();},this));this.addButton=$("#addHttpsServiceDialogAddButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#addHttpsServiceDialogAddStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.addStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#addHttpsServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#addHttpsServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#addHttpsServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("addHttpsServiceDialogLocalHost",jscape.Resources["addHttpsServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#addHttpsServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#addHttpsServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#addHttpsServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddHttpsRemoteHost",jscape.Resources["addHttpsServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#addHttpsServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#addHttpsServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#addHttpsServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#addHttpsServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#addHttpsServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#addHttpsServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#addHttpsServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#addHttpsServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#addHttpsServiceDialogConnectionDelegationBox");this.fipsModeBox=$("#addHttpsServiceDialogFipsModeBox");this.rewriteRulesBox=$("#addHttpsServiceDialogUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._onRewriteRulesBoxClick,this));this.rewriteRulesButton=$("#addHttpsServiceDialogRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("addHttpsServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#addHttpsServiceDialogTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#addHttpsServiceDialogTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("addHttpsServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));this.timeoutField=$("#addHttpsServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyConnectionTimeout.message"]});this.channelBufferSizeEnabledBox=$("#addHttpsServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#addHttpsServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyChannelBufferSize.message"]});this.natHostField=$("#addHttpsServiceDialogNatHostField");this.natHostField.textbox({});this.cachedBox=$("#addHttpsServiceDialogCacheBox");this.cachedBox.click($.proxy(this._cacheBoxClicked,this));this.cacheDirectoryField=$("#addHttpsServiceDialogCacheDirectoryField");this.cacheDirectoryField.textbox({required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyCacheDirectory.message"],validType:[requiredFieldRule("addHttpsServiceDialogCache",jscape.Resources["addHttpsServiceDialog.error.emptyCacheDirectory.message"])]});this.selectCacheDirectoryButton=$("#addHttpsServiceDialogCacheDirectoryButton");this.selectCacheDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectCacheDirectoryButton.click($.proxy(function(){if(!this.selectCacheDirectoryButton.linkbutton("options").disabled){this.listener.onSelectCacheDirectory();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this._cacheBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addHttpsServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getNatHost:function(){return this.natHostField.textbox("getValue").trim();},setNatHost:function(value){this.natHostField.textbox("setValue",value);},getCache:function(){if(this.cachedBox.prop("checked")){return{directory:this.cacheDirectoryField.textbox("getValue").trim()};}
return null;},setCache:function(value){if(value){this.cachedBox.prop("checked",true);this.cacheDirectoryField.textbox("setValue",value.directory);this.cacheDirectoryField.textbox("validate");}else{this.cachedBox.prop("checked",false);this.cacheDirectoryField.textbox("setValue","");}
this._cacheBoxClicked();},setCacheDirectory:function(value){this.cacheDirectoryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_onRewriteRulesBoxClick:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_cacheBoxClicked:function(){var enabled=this.cachedBox.prop("checked");this.cacheDirectoryField.textbox(enabled?"enable":"disable");this.cacheDirectoryField.textbox(enabled?"enableValidation":"disableValidation");this.selectCacheDirectoryButton.linkbutton(enabled?"enable":"disable");}});jscape.EditHttpsServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialogBuilder,addClusterController,generateKeyController,importKeyController,rulesController,testParametersController,selectCacheDirectoryController,rewriteRulesController,sslCiphersController){this.dialogBuilder=dialogBuilder;this.addClusterController=addClusterController;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.rulesController=rulesController;this.testParametersController=testParametersController;this.selectCacheDirectoryController=selectCacheDirectoryController;this.rewriteRulesController=rewriteRulesController;this.sslCiphersController=sslCiphersController;},start:function(data,addresses,keys,clusters,callback){this.data=data;this.addresses=addresses;this.keys=keys;this.clusters=clusters;this.callback=callback;this.testParameters=this.data.httpData.testParameters?this.data.httpData.testParameters:this.DEFAULT_TEST_PARAMETERS;this.rules=this.data.httpData.regexpRewriteRules;this.selectedRules=this.data.httpData.rewriteRules;this.ciphers=this.data.httpData.cipherSuites;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.data.clientProtocolAlias,this.data.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setClusters(this.clusters);this.dialog.setKeys(this.keys);this.dialog.setLocalHost(this.data.localAddress.host);this.dialog.setLocalPort(this.data.localAddress.port);if(this.data.remoteDescriptor){this.dialog.setRemoteHostSelected();this.dialog.setRemoteHost(this.data.remoteDescriptor.remoteAddress.host);this.dialog.setRemotePort(this.data.remoteDescriptor.remoteAddress.port);this.dialog.setRemoteTimeout(this.data.remoteDescriptor.timeout);}else{this.dialog.setClusterSelected();this.dialog.setCluster(this.data.clusterName);}
this.dialog.setKey(this.data.keyAlias);this.dialog.setConnectionDelegationRequired(this.data.connectionDelegationRequired);this.dialog.setFipsModeRequired(this.data.fipsModeRequired);this.dialog.setUseRewriteRules(this.data.httpData.rewriteRules.length>0);this.dialog.setUseTestParameters(this.data.httpData.testParameters);this.dialog.setTimeout(this.data.httpData.connectionTimeoutMillis);this.dialog.setChannelBufferSize(this.data.httpData.socketBufferSizeBytes);this.dialog.setNatHost(this.data.httpData.natHost);this.dialog.setCache(this.data.httpData.cache);},onAddCluster:function(){this.addClusterController.start($.proxy(this._clustersUpdated,this),this.data.serverProtocol);},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSelectRules:function(){this.rulesController.start(this.rules,this.selectedRules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},onSelectCacheDirectory:function(){this.selectCacheDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setCacheDirectory(path);},this));},onChangeRewriteRules:function(){this.rewriteRulesController.start(this.rules,$.proxy(this._rulesUpdated,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(startRequired){var service={id:this.data.id,localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.data.clientProtocol,clientProtocolAlias:this.data.clientProtocolAlias,serverProtocol:this.data.serverProtocol,serverProtocolAlias:this.data.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this.selectedRules:[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null,connectionTimeoutMillis:this.dialog.getTimeout(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),natHost:this.dialog.getNatHost(),cache:this.dialog.getCache(),regexpRewriteRules:this.rules,cipherSuites:this.ciphers},version:this.data.version};jscape.ApiClient.updateProxyService(service,$.proxy(function(summary){this._serviceUpdated(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceUpdated:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.selectedRules=rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;},_clustersUpdated:function(){jscape.ApiClient.clusters($.proxy(function(clusters){var currentCluster=this.dialog.getCluster();this.dialog.setClusters(this._serverClusters(clusters));if(currentCluster){this.dialog.setCluster(currentCluster);}},this));},_serverClusters:function(clusters){var ret=[];var i;var cluster;for(i=0;i<clusters.length;i++){cluster=clusters[i];if(this.data.serverProtocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));},_rulesUpdated:function(rules){this.rules=rules;var selectedRules=[];$.each(this.rules,$.proxy(function(index,rule){if(this.selectedRules.indexOf(rule.name)!==-1){selectedRules.push(rule.name);}},this));this.selectedRules=selectedRules;},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.EditHttpsServiceDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#editHttpsServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editHttpsServiceDialog.title"],width:jscape.Resources.intVal("editHttpsServiceDialog.width"),height:jscape.Resources.intVal("editHttpsServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editHttpsServiceDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.sslCiphersButton=$("#editHttpsServiceDialogSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.rulesButton=$("#editHttpsServiceDialogRulesButton");this.rulesButton.linkbutton({width:jscape.Resources.intVal("editHttpsServiceDialog.rulesButton.width")});this.rulesButton.click($.proxy(function(){this.listener.onChangeRewriteRules();},this));this.addButton=$("#editHttpsServiceDialogSaveButton");this.addButton.linkbutton({width:jscape.Resources.buttonSize()});this.addButton.click($.proxy(function(){this._onSubmit(false);},this));this.addStartButton=$("#editHttpsServiceDialogSaveStartButton");this.addStartButton.linkbutton({width:jscape.Resources.intVal("button.saveStart.width")});this.addStartButton.click($.proxy(function(){this._onSubmit(true);},this));this.cancelButton=$("#editHttpsServiceDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.panel=$("#editHttpsServiceDialogPanel");this.panel.tabs({border:true,plain:true});this.localHostField=$("#editHttpsServiceDialogLocalHostField");this.localHostField.combobox({required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("editHttpsServiceDialogLocalHost",jscape.Resources["editHttpsServiceDialog.error.emptyLocalHost.message"])]});this.localPortField=$("#editHttpsServiceDialogLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#editHttpsServiceDialogRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#editHttpsServiceDialogRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredEditHttpsRemoteHost",jscape.Resources["editHttpsServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#editHttpsServiceDialogRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#editHttpsServiceDialogRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#editHttpsServiceDialogClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#editHttpsServiceDialogClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.addClusterButton=$("#editHttpsServiceDialogAddClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onAddCluster();},this));this.keysBox=$("#editHttpsServiceDialogKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.generateKeyButton=$("#editHttpsServiceDialogGenerateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#editHttpsServiceDialogImportKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.connectionDelegationBox=$("#editHttpsServiceDialogConnectionDelegationBox");this.fipsModeBox=$("#editHttpsServiceDialogFipsModeBox");this.rewriteRulesBox=$("#editHttpsServiceDialogUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._onRewriteRulesBoxClick,this));this.rewriteRulesButton=$("#editHttpsServiceDialogRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("editHttpsServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#editHttpsServiceDialogTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#editHttpsServiceDialogTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("editHttpsServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));this.timeoutField=$("#editHttpsServiceDialogTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyConnectionTimeout.message"]});this.channelBufferSizeEnabledBox=$("#editHttpsServiceDialogChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#editHttpsServiceDialogChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyChannelBufferSize.message"]});this.natHostField=$("#editHttpsServiceDialogNatHostField");this.natHostField.textbox({});this.cachedBox=$("#editHttpsServiceDialogCacheBox");this.cachedBox.click($.proxy(this._cacheBoxClicked,this));this.cacheDirectoryField=$("#editHttpsServiceDialogCacheDirectoryField");this.cacheDirectoryField.textbox({required:true,missingMessage:jscape.Resources["editHttpsServiceDialog.error.emptyCacheDirectory.message"],validType:[requiredFieldRule("editHttpsServiceDialogCache",jscape.Resources["editHttpsServiceDialog.error.emptyCacheDirectory.message"])]});this.selectCacheDirectoryButton=$("#editHttpsServiceDialogCacheDirectoryButton");this.selectCacheDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectCacheDirectoryButton.click($.proxy(function(){if(!this.selectCacheDirectoryButton.linkbutton("options").disabled){this.listener.onSelectCacheDirectory();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.panel.tabs("select",0);this._channelBufferSizeBoxClicked();this._cacheBoxClicked();this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["editHttpsServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue","::").combobox("select","::");},setClusters:function(values){this.clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",this.clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}
this.clusterButton.prop("disabled",values.length===0);},setKeys:function(values){this.keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",this.keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},setLocalHost:function(value){this.localHostField.combobox("setValue",value).combobox("select",value);},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},setRemoteHostSelected:function(){this.remoteServerButton.prop("checked",true);this._strategySelected();},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},setRemoteHost:function(value){this.remoteHostField.textbox("setValue",value);},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setRemoteTimeout:function(value){this.remoteTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},setClusterSelected:function(){this.clusterButton.prop("checked",true);this._strategySelected();},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},setCluster:function(value){if($.grep(this.clusters,function(candidate){return candidate.value===value;}).length>0){this.clustersBox.combobox("setValue",value).combobox("select",value);}else if(this.clusters.length>0){this.clustersBox.combobox("setValue",this.clusters[0].value).combobox("select",this.clusters[0].value);}},getKey:function(){return this.keysBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keysBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keysBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},setConnectionDelegationRequired:function(value){this.connectionDelegationBox.prop("checked",value);},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},setFipsModeRequired:function(value){this.fipsModeBox.prop("checked",value);},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},setUseRewriteRules:function(value){this.rewriteRulesBox.prop("checked",value);this._onRewriteRulesBoxClick();},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},setUseTestParameters:function(value){this.testParametersBox.prop("checked",value);this._onTestParametersBoxClick();},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getNatHost:function(){return this.natHostField.textbox("getValue").trim();},setNatHost:function(value){this.natHostField.textbox("setValue",value);},getCache:function(){if(this.cachedBox.prop("checked")){return{directory:this.cacheDirectoryField.textbox("getValue").trim()};}
return null;},setCache:function(value){if(value){this.cachedBox.prop("checked",true);this.cacheDirectoryField.textbox("setValue",value.directory);this.cacheDirectoryField.textbox("validate");}else{this.cachedBox.prop("checked",false);this.cacheDirectoryField.textbox("setValue","");}
this._cacheBoxClicked();},setCacheDirectory:function(value){this.cacheDirectoryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_onRewriteRulesBoxClick:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_cacheBoxClicked:function(){var enabled=this.cachedBox.prop("checked");this.cacheDirectoryField.textbox(enabled?"enable":"disable");this.cacheDirectoryField.textbox(enabled?"enableValidation":"disableValidation");this.selectCacheDirectoryButton.linkbutton(enabled?"enable":"disable");}});jscape.HttpTestParametersController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(parameters,callback){this.parameters=parameters;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setPath(this.parameters.path);this.dialog.setStatusRegexp(this.parameters.statusRegexp);this.dialog.setBodyRegexp(this.parameters.bodyRegexp);},onSubmit:function(){var parameters={path:this.dialog.getPath(),statusRegexp:this.dialog.getStatusRegexp(),bodyRegexp:this.dialog.getBodyRegexp()};this.dialog.hide();this.callback(parameters);},onCancel:function(){this.dialog.hide();}});jscape.HttpTestParametersDialog=Class.extend({init:function(){this.dialog=$("#httpTestParametersDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["httpTestParametersDialog.title"],width:jscape.Resources.intVal("httpTestParametersDialog.width"),height:jscape.Resources.intVal("httpTestParametersDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.pathField=$("#httpMonitorPathField");this.pathField.textbox({required:true,missingMessage:jscape.Resources["httpTestParametersDialog.error.emptyMonitorPath.message"],validType:[requiredFieldRule("requiredHttpMonitorPath",jscape.Resources["httpTestParametersDialog.error.emptyMonitorPath.message"])]});this.statusRegexpField=$("#httpMonitorStatusRegexpField");this.statusRegexpField.textbox({required:true,missingMessage:jscape.Resources["httpTestParametersDialog.error.emptyMonitorStatusRegexp.message"],validType:[requiredFieldRule("requiredHttpsMonitorStatusRegexp",jscape.Resources["httpTestParametersDialog.error.emptyMonitorStatusRegexp.message"])]});this.bodyRegexpField=$("#httpMonitorBodyRegexpField");this.bodyRegexpField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.pathField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getPath:function(){return this.pathField.textbox("getValue").trim();},setPath:function(value){this.pathField.textbox("setValue",value);this.pathField.textbox("validate");},getStatusRegexp:function(){return this.statusRegexpField.textbox("getValue").trim();},setStatusRegexp:function(value){this.statusRegexpField.textbox("setValue",value);this.statusRegexpField.textbox("validate");},getBodyRegexp:function(){return this.bodyRegexpField.textbox("getValue").trim();},setBodyRegexp:function(value){this.bodyRegexpField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.HttpServiceRulesController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(rules,selectedRules,callback){this._initRules(rules,selectedRules);this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setRules(this.rules);},onSubmit:function(){this.dialog.hide();var rules=[];$.each(this.rules,function(index,rule){if(rule.enabled){rules.push(rule.name);}});this.callback(rules);},onCancel:function(){this.dialog.hide();},onRuleUp:function(index){if(0<index&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index-1];this.rules[index-1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index-1);}},onRuleDown:function(index){if(index<this.rules.length-1&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index+1];this.rules[index+1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index+1);}},_initRules:function(rules,selectedRules){var enabledRules=[];var disabledRules=[];$.each(rules,function(index,rule){var dataRule={name:rule.name,enabled:selectedRules.indexOf(rule.name)!==-1};if(dataRule.enabled){enabledRules.push(dataRule);}else{disabledRules.push(dataRule);}});this.rules=enabledRules.concat(disabledRules);}});jscape.HttpServiceRulesDialog=Class.extend({init:function(){this.dialog=$("#httpServiceRulesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["httpServiceRulesDialog.title"],width:jscape.Resources.intVal("httpServiceRulesDialog.width"),height:jscape.Resources.intVal("httpServiceRulesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.rulesTable=$("#httpServiceRulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["httpServiceRulesDialog.rulesTable.column.0"],sortable:false,width:80},{field:"enabled",title:jscape.Resources["httpServiceRulesDialog.rulesTable.column.1"],sortable:false,width:20,checkbox:true}]],selectOnCheck:false,checkOnSelect:false,onSelect:$.proxy(this._ruleSelected,this),onCheck:function(index,row){row.enabled=true;},onUncheck:function(index,row){row.enabled=false;},onCheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=true;}},onUncheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=false;}}});this.ruleUpButton=$("#httpServiceRuleUpButton");this.ruleUpButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleUpButton.click($.proxy(function(){if(!this.ruleUpButton.linkbutton("options").disabled){this.listener.onRuleUp(this.row);}},this));this.ruleDownButton=$("#httpServiceRuleDownButton");this.ruleDownButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleDownButton.click($.proxy(function(){if(!this.ruleDownButton.linkbutton("options").disabled){this.listener.onRuleDown(this.row);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.rulesTable.datagrid("loadData",[]);this.ruleUpButton.linkbutton("disable");this.ruleDownButton.linkbutton("disable");},setRules:function(values){this.rulesTable.datagrid("loadData",values);var i;for(i=0;i<values.length;++i){if(values[i].enabled){this.rulesTable.datagrid("checkRow",i);}}
this.ruleUpButton.linkbutton("disable");this.ruleDownButton.linkbutton("disable");},selectRule:function(index){this.rulesTable.datagrid("selectRow",index);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_ruleSelected:function(row,rule){this.row=row;this.rule=rule;this.ruleUpButton.linkbutton(row>0?"enable":"disable");this.ruleDownButton.linkbutton(row<this.rulesTable.datagrid("getRows").length-1?"enable":"disable");}});jscape.ServiceParametersController=Class.extend({start:function(callback){this.callback=callback;jscape.ApiClient.serverParameters($.proxy(this._parametersLoaded,this),true);},_parametersLoaded:function(parameters){this.parameters=parameters;jscape.ApiClient.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.addresses=addresses;jscape.ApiClient.serverKeyNames($.proxy(this._keysLoaded,this));},_keysLoaded:function(keys){this.keys=keys;jscape.ApiClient.clusters($.proxy(this._clustersLoaded,this));},_clustersLoaded:function(clusters){this.callback(this.parameters,this.addresses,this.keys,clusters);}});jscape.StopServiceController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["stopServiceDialog.title"],this.values.length===1?jscape.Resources["stopServiceDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["stopServiceDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.stopProxyService(this.values[this.valueIndex++].id,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["serviceStoppedDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["serviceStoppedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});jscape.ClearServiceCacheController=Class.extend({start:function(values){this.values=values;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["clearServiceCacheDialog.title"],this.values.length===1?jscape.Resources["clearServiceCacheDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["clearServiceCacheDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.clearHttpProxyServiceCache(this.values[this.valueIndex++].id,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["serviceCacheClearedDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["serviceCacheClearedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));}});jscape.DeleteServiceController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteServiceDialog.title"],this.values.length===1?jscape.Resources["deleteServiceDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["deleteServiceDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.removeProxyService(this.values[this.valueIndex++].id,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["serviceDeletedDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["serviceDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});jscape.SslCiphersController=Class.extend({STRONG_CIPHERS:["SSL_RSA_WITH_RC4_128_MD5","SSL_RSA_WITH_RC4_128_SHA","SSL_RSA_WITH_3DES_EDE_CBC_SHA","SSL_RSA_WITH_AES_128_CBC_SHA","SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA","SSL_DHE_RSA_WITH_AES_128_CBC_SHA","SSL_DHE_DSS_WITH_AES_128_CBC_SHA","SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA","SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA","SSL_DHE_DSS_WITH_RC4_128_SHA","SSL_KRB5_WITH_RC4_128_SHA","SSL_KRB5_WITH_RC4_128_MD5","SSL_KRB5_WITH_3DES_EDE_CBC_SHA","SSL_KRB5_WITH_3DES_EDE_CBC_MD5","TLS_RSA_WITH_AES_128_CBC_SHA","TLS_DHE_RSA_WITH_AES_128_CBC_SHA","TLS_DHE_DSS_WITH_AES_128_CBC_SHA","TLS_KRB5_WITH_RC4_128_SHA","TLS_KRB5_WITH_RC4_128_MD5","TLS_KRB5_WITH_3DES_EDE_CBC_SHA","TLS_KRB5_WITH_3DES_EDE_CBC_MD5"],MEDIUM_CIPHERS:["SSL_DHE_RSA_WITH_DES_CBC_SHA","SSL_DHE_DSS_WITH_DES_CBC_SHA","SSL_RSA_WITH_DES_CBC_SHA","SSL_RSA_FIPS_WITH_DES_CBC_SHA","SSL_KRB5_WITH_DES_CBC_SHA","SSL_KRB5_WITH_DES_CBC_MD5","TLS_KRB5_WITH_DES_CBC_SHA","TLS_KRB5_WITH_DES_CBC_MD5"],init:function(dialogBuilder){this.dialogBuilder=dialogBuilder;},start:function(ciphers,callback){this.enabledCiphers=ciphers;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
jscape.ApiClient.serverParameters($.proxy(this._parametersLoaded,this),true);},onSubmit:function(){this.dialog.hide();var enabledCiphers=[];$.each(this.ciphers,function(index,cipher){if(cipher.enabled){enabledCiphers.push(cipher.cipher);}});this.callback(enabledCiphers);},onCancel:function(){this.dialog.hide();},onSelectStrong:function(){this._selectCiphers(this.STRONG_CIPHERS);this.dialog.setCiphers(this.ciphers);},onSelectStrongMedium:function(){this._selectCiphers(this.STRONG_CIPHERS.concat(this.MEDIUM_CIPHERS));this.dialog.setCiphers(this.ciphers);},_parametersLoaded:function(parameters){this._initCiphers(parameters.sslCipherSuites);this.dialog.reset();this.dialog.show(this);this.dialog.setCiphers(this.ciphers);},_initCiphers:function(sslCipherSuites){this.ciphers=[];var enabledCiphers=[];var disableCiphers=[];var i;var cipherName;var cipher;for(i=0;i<sslCipherSuites.length;++i){cipherName=sslCipherSuites[i];cipher={cipher:cipherName,enabled:!this.enabledCiphers||this.enabledCiphers.indexOf(cipherName)>-1};if(cipher.enabled){enabledCiphers.push(cipher);}else{disableCiphers.push(cipher);}}
this.ciphers=enabledCiphers.concat(disableCiphers);},_selectCiphers:function(targetCiphers){var enabledCiphers=[];var disableCiphers=[];var i;var cipher;for(i=0;i<this.ciphers.length;++i){cipher=this.ciphers[i];if(targetCiphers.indexOf(cipher.cipher)>-1){cipher.enabled=true;enabledCiphers.push(cipher);}else{cipher.enabled=false;disableCiphers.push(cipher);}}
this.ciphers=enabledCiphers.concat(disableCiphers);}});jscape.SslCiphersDialog=Class.extend({init:function(){this.dialog=$("#sslCiphersDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["sslCiphersDialog.title"],width:jscape.Resources.intVal("sslCiphersDialog.width"),height:jscape.Resources.intVal("sslCiphersDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.ciphersTable=$("#sslCiphersTable");this.ciphersTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"cipher",title:jscape.Resources["sslCiphersDialog.ciphersTable.column.0"],sortable:false,width:80},{field:"enabled",title:jscape.Resources["sslCiphersDialog.ciphersTable.column.1"],sortable:false,width:20,checkbox:true}]],selectOnCheck:false,checkOnSelect:false,onCheck:function(index,row){row.enabled=true;},onUncheck:function(index,row){row.enabled=false;},onCheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=true;}},onUncheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=false;}}});this.selectStrongButton=$("#selectSslStrongButton");this.selectStrongButton.linkbutton({width:jscape.Resources.intVal("sslCiphersDialog.selectStrongButton.width")});this.selectStrongButton.click($.proxy(function(){this.listener.onSelectStrong();},this));this.selectMediumButton=$("#selectSslMediumButton");this.selectMediumButton.linkbutton({width:jscape.Resources.intVal("sslCiphersDialog.selectSslMediumButton.width")});this.selectMediumButton.click($.proxy(function(){this.listener.onSelectStrongMedium();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.ciphersTable.datagrid("loadData",[]);},setCiphers:function(values){this.ciphersTable.datagrid("loadData",values);var i;for(i=0;i<values.length;++i){if(values[i].enabled){this.ciphersTable.datagrid("checkRow",i);}}},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.UrlRewriteRulesController=Class.extend({init:function(dialogBuilder,addRewriteRuleController,editRewriteRuleController,testRewriteRuleController){this.dialogBuilder=dialogBuilder;this.addRewriteRuleController=addRewriteRuleController;this.editRewriteRuleController=editRewriteRuleController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rules,callback){this._initRules(rules);this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setRules(this.rules);},onSubmit:function(){this.dialog.hide();this.callback(this.rules);},onCancel:function(){this.dialog.hide();},onAddRule:function(){this.addRewriteRuleController.start(this.rules,$.proxy(this._ruleAdded,this));},onEditRule:function(rule){this.editRewriteRuleController.start(rule,$.proxy(this._ruleUpdated,this));},onTestRule:function(rule){this.testRewriteRuleController.start(rule);},onDeleteRule:function(rule){$.messager.confirm(jscape.Resources["deleteRewriteDialog.title"],jscape.Resources["deleteRewriteDialog.message"].supplant(rule),$.proxy(function(confirmed){if(confirmed){this._ruleDeleted(rule);}},this));},_initRules:function(rules){this.rules=[];var i;var rule;var copy;for(i=0;i<rules.length;++i){rule=rules[i];copy={name:rule.name,description:rule.description,findRegexp:rule.findRegexp,replaceRegexp:rule.replaceRegexp,scope:rule.scope,direction:rule.direction,replaceScope:rule.replaceScope};this.rules.push(copy);}},_ruleAdded:function(rule){this.rules.push(rule);this.dialog.setRules(this.rules);},_ruleUpdated:function(rule){var index=this._indexFor(rule.name);this.rules[index]=rule;this.dialog.setRules(this.rules);},_ruleDeleted:function(rule){var index=this._indexFor(rule.name);this.rules.splice(index,1);this.dialog.setRules(this.rules);},_indexFor:function(ruleName){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].name===ruleName){return i;}}
return-1;}});jscape.UrlRewriteRulesDialog=Class.extend({init:function(){this.dialog=$("#rewriteRulesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["rewriteRulesDialog.title"],width:jscape.Resources.intVal("rewriteRulesDialog.width"),height:jscape.Resources.intVal("rewriteRulesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.rulesTable=$("#rewriteRulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.0"],sortable:true,width:20},{field:"scope",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.1"],sortable:true,width:20,formatter:function(value,row){return jscape.Resources["rewriteRule.scope."+row.scope];}},{field:"direction",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.2"],sortable:true,width:10,formatter:function(value,row){return jscape.Resources["rewriteRule.direction."+row.direction];}},{field:"replaceScope",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.3"],sortable:true,width:10,formatter:function(value,row){return jscape.Resources["rewriteRule.replaceScope."+row.replaceScope];}},{field:"findRegexp",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.4"],sortable:false,width:20},{field:"replaceRegexp",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.5"],sortable:false,width:20},{field:"ignoringSubsequentRulesRequired",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.6"],sortable:false,width:20,halign:"center",align:"center",formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});}},{field:"description",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.7"],sortable:false,width:20}]],onSelect:$.proxy(this._ruleSelected,this),onSortColumn:$.proxy(this._resetButtons,this),onDblClickRow:$.proxy(function(index,rule){this.listener.onEditRule(rule);},this)});this.testRuleButton=$("#testRewriteRuleButton");this.testRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.testRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onTestRule(this.rule);}},this));this.addRuleButton=$("#addRewriteRuleButton");this.addRuleButton.linkbutton({width:jscape.Resources.buttonSize()});this.addRuleButton.click($.proxy(function(){this.listener.onAddRule();},this));this.editRuleButton=$("#editRewriteRuleButton");this.editRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onEditRule(this.rule);}},this));this.deleteRuleButton=$("#deleteRewriteRuleButton");this.deleteRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onDeleteRule(this.rule);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.rulesTable.datagrid("loadData",[]);},setRules:function(values){this.rulesTable.datagrid("loadData",values);this._resetButtons();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_ruleSelected:function(row,rule){this.row=row;this.rule=rule;this.testRuleButton.linkbutton("enable");this.editRuleButton.linkbutton("enable");this.deleteRuleButton.linkbutton("enable");},_resetButtons:function(){this.testRuleButton.linkbutton("disable");this.editRuleButton.linkbutton("disable");this.deleteRuleButton.linkbutton("disable");}});jscape.AddRewriteRuleController=Class.extend({init:function(dialogBuilder,rewriteRuleVariablesController,testRewriteRuleController){this.dialogBuilder=dialogBuilder;this.rewriteRuleVariablesController=rewriteRuleVariablesController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rules,callback){this.rules=rules;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);},onSubmit:function(){this.dialog.hide();var rule=this._rule();this.callback(rule);},onCancel:function(){this.dialog.hide();},onAddVariable:function(){this.rewriteRuleVariablesController.start($.proxy(this._variableAdded,this));},onTestRule:function(){var rule=this._rule();this.testRewriteRuleController.start(rule);},ruleExists:function(name){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].name===name){return true;}}
return false;},_rule:function(){return{name:this.dialog.getName(),description:this.dialog.getDescription(),scope:this.dialog.getScope(),direction:this.dialog.getDirection(),findRegexp:this.dialog.getFindRegexp(),replaceRegexp:this.dialog.getReplaceRegexp(),replaceScope:this.dialog.getReplaceScope(),ignoringSubsequentRulesRequired:this.dialog.isExclusive()};},_variableAdded:function(variable){if(variable){this.dialog.setVariable("{"+variable+"}");}}});jscape.AddRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#addRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRewriteRuleDialog.title"],width:jscape.Resources.intVal("addRewriteRuleDialog.width"),height:jscape.Resources.intVal("addRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:"#addRewriteRuleDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.addVariableButton=$("#rewriteRuleAddVariableButton");this.addVariableButton.linkbutton({width:jscape.Resources.intVal("addRewriteRuleDialog.addVariableButton.width"),disabled:true});this.addVariableButton.click($.proxy(function(){if(!this.addVariableButton.linkbutton("options").disabled){this.listener.onAddVariable();}},this));this.testButton=$("#addRewriteRuleDialogTestButton");this.testButton.linkbutton({width:jscape.Resources.buttonSize()});this.testButton.click($.proxy(this._onTest,this));this.okButton=$("#addRewriteRuleDialogOkButton");this.okButton.linkbutton({width:jscape.Resources.buttonSize()});this.okButton.click($.proxy(this._onSubmit,this));this.cancelButton=$("#addRewriteRuleDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.nameField=$("#rewriteRuleNameField");this.nameField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyName.message"],validType:[requiredFieldRule("requiredAddRewriteRuleName",jscape.Resources["addRewriteRuleDialog.error.emptyName.message"]),validationRule("uniqueRuleName",$.proxy(function(value){return!this.listener.ruleExists(value);},this),jscape.Resources["addRewriteRuleDialog.error.nameExists.message"])]});this.nameField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.descriptionField=$("#rewriteRuleDescriptionField");this.descriptionField.textbox({});this.descriptionField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.ruleDirectionField=$("#addRewriteRuleDirectionField");this.ruleDirectionField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleScopeField=$("#addRewriteRuleScopeField");this.ruleScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleReplaceScopeField=$("#addRewriteRuleReplaceScopeField");this.ruleReplaceScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.findRegexpField=$("#rewriteRuleFindRegexpField");this.findRegexpField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyFindRegexp.message"],validType:requiredFieldRule("requiredAddFindRegex",jscape.Resources["addRewriteRuleDialog.error.emptyFindRegexp.message"])});this.findRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.findRegexpField;this.addVariableButton.linkbutton("enable");},this));this.findRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.findRegexpField[0].selectionEnd;},this));this.replaceRegexpField=$("#rewriteRuleReplaceRegexpField");this.replaceRegexpField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyReplaceRegexp.message"],validType:requiredFieldRule("requiredAddReplaceRegex",jscape.Resources["addRewriteRuleDialog.error.emptyReplaceRegexp.message"])});this.replaceRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.replaceRegexpField;this.addVariableButton.linkbutton("enable");},this));this.replaceRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.replaceRegexpField[0].selectionEnd;},this));this.exclusiveBox=$("#rewriteRuleExclusiveBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.nameField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.addVariableButton.linkbutton("disable");},setVariable:function(variable){if(this.currentVariableField){var currentText=this.currentVariableField.textbox("getValue");var insertPosition=this.currentVariableFieldPosition?this.currentVariableFieldPosition:this.currentVariableField[0].selectionEnd;var resultText=currentText.length>0&&insertPosition>=0?currentText.substring(0,insertPosition)+variable+currentText.substring(insertPosition):currentText+variable;this.currentVariableField.textbox("setValue",resultText);}},getName:function(){return this.nameField.textbox("getValue").trim();},getDescription:function(){return this.descriptionField.textbox("getValue").trim();},getDirection:function(){return this.ruleDirectionField.combobox("getValue");},getScope:function(){return this.ruleScopeField.combobox("getValue");},getReplaceScope:function(){return this.ruleReplaceScopeField.combobox("getValue");},getFindRegexp:function(){return this.findRegexpField.textbox("getValue").trim();},getReplaceRegexp:function(){return this.replaceRegexpField.textbox("getValue").trim();},isExclusive:function(){return this.exclusiveBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_onTest:function(){if(this.form.form("validate")){this.listener.onTestRule();}}});jscape.EditRewriteRuleController=Class.extend({init:function(dialogBuilder,rewriteRuleVariablesController,testRewriteRuleController){this.dialogBuilder=dialogBuilder;this.rewriteRuleVariablesController=rewriteRuleVariablesController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rule,callback){this.rule=rule;this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.setName(this.rule.name);this.dialog.setDescription(this.rule.description);this.dialog.setDirection(this.rule.direction);this.dialog.setScope(this.rule.scope);this.dialog.setReplaceScope(this.rule.replaceScope);this.dialog.setFindRegexp(this.rule.findRegexp);this.dialog.setReplaceRegexp(this.rule.replaceRegexp);this.dialog.setExclusive(this.rule.ignoringSubsequentRulesRequired);this.dialog.show(this);},onSubmit:function(){this.dialog.hide();var rule=this._rule();this.callback(rule);},onCancel:function(){this.dialog.hide();},onAddVariable:function(){this.rewriteRuleVariablesController.start($.proxy(this._variableAdded,this));},onTestRule:function(){var rule=this._rule();this.testRewriteRuleController.start(rule);},_rule:function(){return{name:this.rule.name,description:this.dialog.getDescription(),scope:this.dialog.getScope(),direction:this.dialog.getDirection(),findRegexp:this.dialog.getFindRegexp(),replaceRegexp:this.dialog.getReplaceRegexp(),replaceScope:this.dialog.getReplaceScope(),ignoringSubsequentRulesRequired:this.dialog.isExclusive()};},_variableAdded:function(variable){if(variable){this.dialog.setVariable("{"+variable+"}");}}});jscape.EditRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#editRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editRewriteRuleDialog.title"],width:jscape.Resources.intVal("editRewriteRuleDialog.width"),height:jscape.Resources.intVal("editRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:"#editRewriteRuleDialogButtonBar",onClose:$.proxy(this._onCancel,this),closed:true});this.addVariableButton=$("#editRewriteRuleAddVariableButton");this.addVariableButton.linkbutton({width:jscape.Resources.intVal("editRewriteRuleDialog.addVariableButton.width"),disabled:true});this.addVariableButton.click($.proxy(function(){if(!this.addVariableButton.linkbutton("options").disabled){this.listener.onAddVariable();}},this));this.testButton=$("#editRewriteRuleDialogTestButton");this.testButton.linkbutton({width:jscape.Resources.buttonSize()});this.testButton.click($.proxy(this._onTest,this));this.okButton=$("#editRewriteRuleDialogOkButton");this.okButton.linkbutton({width:jscape.Resources.buttonSize()});this.okButton.click($.proxy(this._onSubmit,this));this.cancelButton=$("#editRewriteRuleDialogCancelButton");this.cancelButton.linkbutton({width:jscape.Resources.buttonSize()});this.cancelButton.click($.proxy(this._onCancel,this));this.form=this.dialog.find("form");this.descriptionField=$("#editRewriteRuleDescriptionField");this.descriptionField.textbox({});this.descriptionField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.ruleDirectionField=$("#editRewriteRuleDirectionField");this.ruleDirectionField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleScopeField=$("#editRewriteRuleScopeField");this.ruleScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleReplaceScopeField=$("#editRewriteRuleReplaceScopeField");this.ruleReplaceScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.findRegexpField=$("#editRewriteRuleFindRegexpField");this.findRegexpField.textbox({required:true,missingMessage:jscape.Resources["editRewriteRuleDialog.error.emptyFindRegexp.message"],validType:requiredFieldRule("requiredEditFindRegexp",jscape.Resources["editRewriteRuleDialog.error.emptyFindRegexp.message"])});this.findRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.findRegexpField;this.addVariableButton.linkbutton("enable");},this));this.findRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.findRegexpField[0].selectionEnd;},this));this.replaceRegexpField=$("#editRewriteRuleReplaceRegexpField");this.replaceRegexpField.textbox({required:true,missingMessage:jscape.Resources["editRewriteRuleDialog.error.emptyReplaceRegexp.message"],validType:requiredFieldRule("requiredEditReplaceRegexp",jscape.Resources["editRewriteRuleDialog.error.emptyReplaceRegexp.message"])});this.replaceRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.replaceRegexpField;this.addVariableButton.linkbutton("enable");},this));this.replaceRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.replaceRegexpField[0].selectionEnd;},this));this.exclusiveBox=$("#editRewriteRuleExclusiveBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.descriptionField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.addVariableButton.linkbutton("disable");},setVariable:function(variable){if(this.currentVariableField){var currentText=this.currentVariableField.textbox("getValue");var insertPosition=this.currentVariableFieldPosition?this.currentVariableFieldPosition:this.currentVariableField[0].selectionEnd;var resultText=currentText.length>0&&insertPosition>=0?currentText.substring(0,insertPosition)+variable+currentText.substring(insertPosition):currentText+variable;this.currentVariableField.textbox("setValue",resultText);}},setName:function(value){this.dialog.dialog("setTitle",jscape.Resources["editRewriteRuleDialog.title"].supplant({name:value}));},getDescription:function(){return this.descriptionField.textbox("getValue").trim();},setDescription:function(value){this.descriptionField.textbox("setValue",value);},getDirection:function(){return this.ruleDirectionField.combobox("getValue");},setDirection:function(value){this.ruleDirectionField.combobox("setValue",value).combobox("select",value);},getScope:function(){return this.ruleScopeField.combobox("getValue");},setScope:function(value){this.ruleScopeField.combobox("setValue",value).combobox("select",value);},getReplaceScope:function(){return this.ruleReplaceScopeField.combobox("getValue");},setReplaceScope:function(value){this.ruleReplaceScopeField.combobox("setValue",value).combobox("select",value);},getFindRegexp:function(){return this.findRegexpField.textbox("getValue").trim();},setFindRegexp:function(value){this.findRegexpField.textbox("setValue",value);this.findRegexpField.textbox("validate");},getReplaceRegexp:function(){return this.replaceRegexpField.textbox("getValue").trim();},setReplaceRegexp:function(value){this.replaceRegexpField.textbox("setValue",value);this.replaceRegexpField.textbox("validate");},isExclusive:function(){return this.exclusiveBox.prop("checked");},setExclusive:function(value){this.exclusiveBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_onTest:function(){if(this.form.form("validate")){this.listener.onTestRule();}},_clientServerButtonClick:function(){this.requestUriScopeButton.removeAttr("disabled");this.requestUriScopeButton.prop("checked",true);this.contentScopeButton.attr("disabled",true);this.headersContentScopeButton.attr("disabled",true);},_serverClientButtonClick:function(){this.requestUriScopeButton.attr("disabled",true);this.headersScopeButton.prop("checked",true);this.contentScopeButton.removeAttr("disabled");this.headersContentScopeButton.removeAttr("disabled");},_anyDirectionButtonClick:function(){this.requestUriScopeButton.attr("disabled",true);this.headersScopeButton.prop("checked",true);this.contentScopeButton.attr("disabled",true);this.headersContentScopeButton.attr("disabled",true);}});jscape.RewriteRuleVariablesController=Class.extend({VARIABLES:[{name:"SERVER_IP",description:jscape.Resources["variable.SERVER_IP.description"]},{name:"SERVER_HOSTNAME",description:jscape.Resources["variable.SERVER_HOSTNAME.description"]},{name:"SERVER_PORT",description:jscape.Resources["variable.SERVER_PORT.description"]},{name:"CLIENT_IP",description:jscape.Resources["variable.CLIENT_IP.description"]},{name:"CLIENT_PORT",description:jscape.Resources["variable.CLIENT_PORT.description"]},{name:"GATEWAY_OUTER_IP",description:jscape.Resources["variable.GATEWAY_OUTER_IP.description"]},{name:"GATEWAY_OUTER_HOSTNAME",description:jscape.Resources["variable.GATEWAY_OUTER_HOSTNAME.description"]},{name:"GATEWAY_IP",description:jscape.Resources["variable.GATEWAY_IP.description"]},{name:"GATEWAY_PORT",description:jscape.Resources["variable.GATEWAY_PORT.description"]}],init:function(dialogBuilder){this.dialogBuilder=dialogBuilder;},start:function(callback){this.callback=callback;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.show(this);this.dialog.setVariables(this.VARIABLES);},onSubmit:function(){this.dialog.hide();var variable=this.dialog.getVariable();this.callback(variable);},onCancel:function(){this.dialog.hide();}});jscape.RewriteRuleVariablesDialog=Class.extend({init:function(){this.dialog=$("#rewriteRuleVariablesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["rewriteRuleVariablesDialog.title"],width:jscape.Resources.intVal("rewriteRuleVariablesDialog.width"),height:jscape.Resources.intVal("rewriteRuleVariablesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.variablesTable=$("#rewriteRuleVariablesTable");this.variablesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["rewriteRuleVariablesDialog.variableTable.column.0"],width:40,halign:"left",align:"left",sortable:true},{field:"description",title:jscape.Resources["rewriteRuleVariablesDialog.variableTable.column.1"],width:60,halign:"left",align:"left",sortable:false}]],sortName:"name",sortOrder:"asc",onSelect:$.proxy(this._variableSelected,this),onDblClickRow:$.proxy($.proxy(this._onSubmit,this))});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.variablesTable.datagrid("loadData",[]);this.variable=null;},setVariables:function(values){this.variablesTable.datagrid("loadData",values);},getVariable:function(){return this.variable;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_variableSelected:function(row,variable){this.variable=variable.name;}});jscape.TestRewriteRuleController=Class.extend({init:function(dialogBuilder,testResultDialog){this.dialogBuilder=dialogBuilder;this.testResultDialog=testResultDialog;},start:function(rule){this.rule=rule;if(!this.dialog){this.dialog=this.dialogBuilder();}
this.dialog.reset();this.dialog.setName(this.rule.name);this.dialog.setFindRegexp(this.rule.findRegexp);this.dialog.setReplaceRegexp(this.rule.replaceRegexp);this.dialog.show(this);},onSubmit:function(){var environment=this._environment();var findRegexp=this.rule.findRegexp.supplant(environment);var replaceRegexp=this.rule.replaceRegexp.supplant(environment);var content=this.dialog.getContent();var result=content.replace(new RegExp(findRegexp,"gm"),replaceRegexp);this.testResultDialog.reset();this.testResultDialog.setContent(result);this.testResultDialog.show(this);},onCancel:function(){this.dialog.hide();},onClose:function(){this.testResultDialog.hide();},_environment:function(){return{SERVER_IP:this._quote(this.dialog.getServerIp()),SERVER_HOSTNAME:this._quote(this.dialog.getServerHost()),SERVER_PORT:this.dialog.getServerPort(),CLIENT_IP:this._quote(this.dialog.getClientIp()),CLIENT_PORT:this.dialog.getClientPort(),GATEWAY_OUTER_IP:this._quote(this.dialog.getGatewayOuterIp()),GATEWAY_OUTER_HOSTNAME:this._quote(this.dialog.getGatewayOuterHost()),GATEWAY_IP:this._quote(this.dialog.getGatewayIp()),GATEWAY_PORT:this.dialog.getGatewayPort()};},_quote:function(value){return value.replace(/([.?*+\^$\[\]\\(){}|\-])/g,"\\$1");}});jscape.TestRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#testRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["testRewriteRuleDialog.title"],width:jscape.Resources.intVal("testRewriteRuleDialog.width"),height:jscape.Resources.intVal("testRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.findRegexpField=$("#findRegexpField");this.findRegexpField.textbox({});this.replaceRegexpField=$("#replaceRegexpField");this.replaceRegexpField.textbox({});this.serverIpField=$("#serverIpField");this.serverIpField.textbox({});this.serverHostField=$("#serverHostField");this.serverHostField.textbox({});this.serverPortField=$("#serverPortField");this.serverPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyServerPort.message"]});this.clientIpField=$("#clientIpField");this.clientIpField.textbox({});this.clientPortField=$("#clientPortField");this.clientPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyClientPort.message"]});this.gatewayOuterIpField=$("#gatewayOuterIpField");this.gatewayOuterIpField.textbox({});this.gatewayOuterHostField=$("#gatewayOuterHostField");this.gatewayOuterHostField.textbox({});this.gatewayIpField=$("#gatewayIpField");this.gatewayIpField.textbox({});this.gatewayPortField=$("#gatewayPortField");this.gatewayPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyGatewayPort.message"]});this.contentField=$("#contentField");this.contentField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.serverIpField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setName:function(value){this.dialog.dialog("setTitle",jscape.Resources["testRewriteRuleDialog.title"].supplant({name:value}));},setFindRegexp:function(value){this.findRegexpField.textbox("setValue",value);},setReplaceRegexp:function(value){this.replaceRegexpField.textbox("setValue",value);},getServerIp:function(){return this.serverIpField.textbox("getValue").trim();},getServerHost:function(){return this.serverHostField.textbox("getValue").trim();},getServerPort:function(){return this.serverPortField.numberspinner("getValue");},getClientIp:function(){return this.clientIpField.textbox("getValue").trim();},getClientPort:function(){return this.clientPortField.numberspinner("getValue");},getGatewayOuterIp:function(){return this.gatewayOuterIpField.textbox("getValue").trim();},getGatewayOuterHost:function(){return this.gatewayOuterHostField.textbox("getValue").trim();},getGatewayIp:function(){return this.gatewayIpField.textbox("getValue").trim();},getGatewayPort:function(){return this.gatewayPortField.numberspinner("getValue");},getContent:function(){return this.contentField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.TestRuleResultDialog=Class.extend({init:function(){this.dialog=$("#testRuleResultDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["testRuleResultDialog.title"],width:jscape.Resources.intVal("testRuleResultDialog.width"),height:jscape.Resources.intVal("testRuleResultDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.close.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onClose,this)}],onClose:$.proxy(this._onClose,this),closed:true});this.form=this.dialog.find("form");this.contentField=$("#resultContentField");this.contentField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setContent:function(value){this.contentField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onClose:function(){this.listener.onClose();}});