/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.KeysController=Class.extend({init:function(page,generateKeyController,importKeyController,keyDetailsController,importCertificateController,generateCertificateController,exportKeyController,deleteKeyController){this.page=page;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.keyDetailsController=keyDetailsController;this.importCertificateController=importCertificateController;this.generateCertificateController=generateCertificateController;this.exportKeyController=exportKeyController;this.deleteKeyController=deleteKeyController;},start:function(){this.page.show(this);},onReload:function(request,successCallback){jscape.ApiClient.serverKeysFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onGenerateKey:function(){this.generateKeyController.start($.proxy(function(){this.page.reload();},this));},onImportKey:function(){this.importKeyController.start($.proxy(function(){this.page.reload();},this));},onShowKeyDetails:function(summary){this.keyDetailsController.start(summary);},onImportCertificate:function(summary){this.importCertificateController.start(summary,$.proxy(function(){this.page.reload();},this));},onGenerateCertificate:function(summary){this.generateCertificateController.start(summary,$.proxy(function(){this.page.reload();},this));},onGenerateCsr:function(summary){jscape.ApiClient.serverKeyCsrFor(summary.name);},onExportKey:function(summary){this.exportKeyController.start(summary);},onDeleteKeys:function(summaries){this.deleteKeyController.start(summaries,$.proxy(function(){this.page.reload();},this));}});jscape.KeysPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.keysTable=$("#keysTable");this.keysTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"name",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"name",title:jscape.Resources["keysPage.keysTable.column.0"],width:20,halign:"left",align:"left",sortable:true,searchable:true},{field:"keyAlgorithm",title:jscape.Resources["keysPage.keysTable.column.1"],width:10,halign:"left",align:"left",sortable:true,searchable:true},{field:"keySize",title:jscape.Resources["keysPage.keysTable.column.2"],width:10,halign:"right",align:"right",sortable:true,searchable:true},{field:"certificateSerialNumber",title:jscape.Resources["keysPage.keysTable.column.3"],width:20,halign:"left",align:"left",sortable:true,searchable:true,formatter:function(value,row){return"{value}(0x{hexValue})".supplant({value:row.certificateSerialNumber,hexValue:row.certificateSerialNumberHex});}},{field:"certificateIssuer",title:jscape.Resources["keysPage.keysTable.column.4"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"certificateSubject",title:jscape.Resources["keysPage.keysTable.column.5"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"certificateBeginDate",title:jscape.Resources["keysPage.keysTable.column.6"],width:20,halign:"right",align:"right",sortable:true,searchable:true,formatter:function(value,row){var dateString=dateFormat(row.certificateBeginDate,"UTC:mm-dd-yyyy Z");return row.certificateBeginDate>new Date().getTime()?"<span style='color:red;'>{value}</span>".supplant({value:dateString}):dateString;},finder:"datebox"},{field:"certificateEndDate",title:jscape.Resources["keysPage.keysTable.column.7"],width:20,halign:"right",align:"right",sortable:true,searchable:true,formatter:function(value,row){var dateString=dateFormat(row.certificateEndDate,"UTC:mm-dd-yyyy Z");return row.certificateEndDate<new Date().getTime()?"<span style='color:red;'>{value}</span>".supplant({value:dateString}):dateString;},finder:"datebox"}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onShowKeyDetails(this.rowValue);},this)});this.generateKeyButton=$("#generateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#importKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.keyDetailsButton=$("#keyDetailsButton");this.keyDetailsButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.keyDetailsButton.click($.proxy(function(){if(!this.keyDetailsButton.linkbutton("options").disabled){this.listener.onShowKeyDetails(this.rowValue);}},this));this.importCertificateButton=$("#importCertificateButton");this.importCertificateButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.importCertificateButton.width"),disabled:true});this.importCertificateButton.click($.proxy(function(){if(!this.importCertificateButton.linkbutton("options").disabled){this.listener.onImportCertificate(this.rowValue);}},this));this.generateCertificateButton=$("#generateCertificateButton");this.generateCertificateButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.generateCertificateButton.width"),disabled:true});this.generateCertificateButton.click($.proxy(function(){if(!this.importCertificateButton.linkbutton("options").disabled){this.listener.onGenerateCertificate(this.rowValue);}},this));this.generateCsrButton=$("#generateCsrButton");this.generateCsrButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.generateCsrButton.width"),disabled:true});this.generateCsrButton.click($.proxy(function(){if(!this.generateCsrButton.linkbutton("options").disabled){this.listener.onGenerateCsr(this.rowValue);}},this));this.exportKeyButton=$("#exportKeyButton");this.exportKeyButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.exportKeyButton.click($.proxy(function(){if(!this.exportKeyButton.linkbutton("options").disabled){this.listener.onExportKey(this.rowValue);}},this));this.deleteKeyButton=$("#deleteKeyButton");this.deleteKeyButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteKeyButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");this.keysTable.datagrid("reload");},reload:function(){this.keysTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;if(this.rowValue){this.keyDetailsButton.linkbutton("enable");this.importCertificateButton.linkbutton("enable");this.generateCertificateButton.linkbutton("enable");this.generateCsrButton.linkbutton("enable");this.exportKeyButton.linkbutton("enable");this.deleteKeyButton.linkbutton("enable");}},_rowUnselected:function(){if(this.keysTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.keysTable.datagrid("options").pageNumber;if(pageNumber>1){this.keysTable.datagrid("gotoPage",pageNumber-1);}}
this.keysTable.datagrid("getPanel").find("div.datagrid-body td[field] div.datagrid-cell:not(:empty)").tooltip({position:"top",content:function(){return $(this).html();}});},_delete:function(){var values=this.keysTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteKeys(values);}},_resetButtons:function(){this.keyDetailsButton.linkbutton("disable");this.importCertificateButton.linkbutton("disable");this.generateCertificateButton.linkbutton("disable");this.generateCsrButton.linkbutton("disable");this.exportKeyButton.linkbutton("disable");this.deleteKeyButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.keysTable.datagrid("selectRow",this.row);}}});jscape.GenerateKeyController=Class.extend({init:function(dialog,controllerMap){this.dialog=dialog;this.controllerMap=controllerMap;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){this.dialog.hide();var algorithm=this.dialog.getAlgorithm();var controller=this.controllerMap[algorithm];controller.start(this.callback);},onCancel:function(){this.dialog.hide();}});jscape.GenerateKeyAlgorithmDialog=Class.extend({init:function(){this.dialog=$("#generateKeyAlgorithmDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateKeyAlgorithmDialog.title"],width:jscape.Resources.intVal("generateKeyAlgorithmDialog.width"),height:jscape.Resources.intVal("generateKeyAlgorithmDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.algorithmField=$("#generateKeyAlgorithmField");this.algorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.algorithmField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getAlgorithm:function(){return this.algorithmField.combobox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.GenerateRsaKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var data={name:this.dialog.getAlias(),keyAlgorithm:"RSA",keySize:this.dialog.getLength(),certificateGenerationData:{validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry(),subjectAlternativeName:this.dialog.getSubjectAlternativeName()}};jscape.ApiClient.generateServerKey(data,$.proxy(this._keyGenerated,this));},onCancel:function(){this.dialog.hide();},_keyGenerated:function(summary){this.dialog.hide();showMessage(jscape.Resources["keyGeneratedDialog.message"].supplant(summary));this.callback();}});jscape.GenerateRsaKeyDialog=Class.extend({TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateRsaKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateRsaKeyDialog.title"],width:jscape.Resources.intVal("generateRsaKeyDialog.width"),height:jscape.Resources.intVal("generateRsaKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateRsaKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#generateRsaKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["generateRsaKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredGenerateRsaKeyAlias",jscape.Resources["generateRsaKeyDialog.error.validAlias.message"]),validationRule("generateRsaKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["generateRsaKeyDialog.error.validAlias.message"])]});this.lengthBox=$("#generateRsaKeyLengthBox");this.lengthBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.periodField=$("#generateRsaKeyCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateRsaKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generateRsaKeyCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateRsaKeyDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGenerateRsaKeyCommonName",jscape.Resources["generateRsaKeyDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generateRsaKeyCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generateRsaKeyCertificateOField");this.organizationField.textbox({});this.localityField=$("#generateRsaKeyCertificateLField");this.localityField.textbox({});this.stateField=$("#generateRsaKeyCertificateStField");this.stateField.textbox({});this.countryField=$("#generateRsaKeyCertificateCField");this.countryField.textbox({});this.subjectAlternativeNameField=$("#generateRsaKeyCertificateSnaField");this.subjectAlternativeNameField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getAlias:function(){return this.aliasField.textbox("getValue").trim();},getLength:function(){return parseInt(this.lengthBox.combobox("getValue"),10);},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},getLocality:function(){return this.localityField.textbox("getValue").trim();},getState:function(){return this.stateField.textbox("getValue").trim();},getCountry:function(){return this.countryField.textbox("getValue").trim();},getSubjectAlternativeName:function(){return this.subjectAlternativeNameField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.GenerateDsaKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var data={name:this.dialog.getAlias(),keyAlgorithm:"DSA",keySize:this.dialog.getLength(),certificateGenerationData:{validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry(),subjectAlternativeName:this.dialog.getSubjectAlternativeName()}};jscape.ApiClient.generateServerKey(data,$.proxy(this._keyGenerated,this));},onCancel:function(){this.dialog.hide();},_keyGenerated:function(summary){this.dialog.hide();showMessage(jscape.Resources["keyGeneratedDialog.message"].supplant(summary));this.callback();}});jscape.GenerateDsaKeyDialog=Class.extend({TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateDsaKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateDsaKeyDialog.title"],width:jscape.Resources.intVal("generateDsaKeyDialog.width"),height:jscape.Resources.intVal("generateDsaKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateDsaKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#generateDsaKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["generateDsaKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredGenerateDsaKeyAlias",jscape.Resources["generateDsaKeyDialog.error.validAlias.message"]),validationRule("generateDsaKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["generateDsaKeyDialog.error.validAlias.message"])]});this.lengthBox=$("#generateDsaKeyLengthBox");this.lengthBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.periodField=$("#generateDsaKeyCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateDsaKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generateDsaKeyCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateDsaKeyDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGenerateDsaKeyCommonName",jscape.Resources["generateDsaKeyDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generateDsaKeyCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generateDsaKeyCertificateOField");this.organizationField.textbox({});this.localityField=$("#generateDsaKeyCertificateLField");this.localityField.textbox({});this.stateField=$("#generateDsaKeyCertificateStField");this.stateField.textbox({});this.countryField=$("#generateDsaKeyCertificateCField");this.countryField.textbox({});this.subjectAlternativeNameField=$("#generateDsaKeyCertificateSnaField");this.subjectAlternativeNameField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getAlias:function(){return this.aliasField.textbox("getValue").trim();},getLength:function(){return parseInt(this.lengthBox.combobox("getValue"),10);},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},getLocality:function(){return this.localityField.textbox("getValue").trim();},getState:function(){return this.stateField.textbox("getValue").trim();},getCountry:function(){return this.countryField.textbox("getValue").trim();},getSubjectAlternativeName:function(){return this.subjectAlternativeNameField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.GenerateEcKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var data={name:this.dialog.getAlias(),keyAlgorithm:"EC",keyCurveName:this.dialog.getCurve(),certificateGenerationData:{validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry(),subjectAlternativeName:this.dialog.getSubjectAlternativeName()}};jscape.ApiClient.generateServerKey(data,$.proxy(this._keyGenerated,this));},onCancel:function(){this.dialog.hide();},_keyGenerated:function(summary){this.dialog.hide();showMessage(jscape.Resources["keyGeneratedDialog.message"].supplant(summary));this.callback();}});jscape.GenerateEcKeyDialog=Class.extend({TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateEcKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateEcKeyDialog.title"],width:jscape.Resources.intVal("generateEcKeyDialog.width"),height:jscape.Resources.intVal("generateEcKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateEcKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#generateEcKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["generateEcKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredGenerateEcKeyAlias",jscape.Resources["generateDsaKeyDialog.error.validAlias.message"]),validationRule("generateEcKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["generateEcKeyDialog.error.validAlias.message"])]});this.curveBox=$("#generateEcKeyCurveBox");this.curveBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.periodField=$("#generateEcKeyCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateEcKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generateEcKeyCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateEcKeyDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGenerateEcKeyCommonName",jscape.Resources["generateEcKeyDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generateEcKeyCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generateEcKeyCertificateOField");this.organizationField.textbox({});this.localityField=$("#generateEcKeyCertificateLField");this.localityField.textbox({});this.stateField=$("#generateEcKeyCertificateStField");this.stateField.textbox({});this.countryField=$("#generateEcKeyCertificateCField");this.countryField.textbox({});this.subjectAlternativeNameField=$("#generateEcKeyCertificateSnaField");this.subjectAlternativeNameField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getAlias:function(){return this.aliasField.textbox("getValue").trim();},getCurve:function(){return this.curveBox.combobox("getValue");},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},getLocality:function(){return this.localityField.textbox("getValue").trim();},getState:function(){return this.stateField.textbox("getValue").trim();},getCountry:function(){return this.countryField.textbox("getValue").trim();},getSubjectAlternativeName:function(){return this.subjectAlternativeNameField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.ImportKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){jscape.ApiClient.importServerKey(this.dialog.getForm(),$.proxy(this._keyImported,this));},onCancel:function(){this.dialog.hide();},_keyImported:function(summary){this.dialog.hide();showMessage(jscape.Resources["keyImportedDialog.message"].supplant(summary));this.callback();}});jscape.ImportKeyDialog=Class.extend({init:function(){this.dialog=$("#importKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["importKeyDialog.title"],width:jscape.Resources.intVal("importKeyDialog.width"),height:jscape.Resources.intVal("importKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["importKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#importKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["importKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredImportKeyAlias",jscape.Resources["importKeyDialog.error.validAlias.message"]),validationRule("importKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["importKeyDialog.error.validAlias.message"])]});this.keyFileField=$("#importKeyFileField");this.keyFileField.filebox({buttonText:jscape.Resources["button.browse.text"],buttonAlign:"right",required:true,missingMessage:jscape.Resources["importKeyDialog.error.emptyFile.message"]});this.keyFilePasswordField=$("#importKeyFilePasswordField");this.keyFilePasswordField.passwordbox({});this.keyFileAliasField=$("#importKeyFileAliasField");this.keyFileAliasField.textbox({});this.keyPasswordField=$("#importKeyPasswordField");this.keyPasswordField.passwordbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getForm:function(){return this.form;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.KeyDetailsController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary){this.dialog.reset();this.dialog.setAlias(summary.name);this.dialog.setAlgorithm(summary.keyAlgorithm);this.dialog.setKeySize(summary.keySize);this.dialog.setCertificateSerial(summary.certificateSerialNumber,summary.certificateSerialNumberHex);this.dialog.setCertificateIssuer(summary.certificateIssuer);this.dialog.setCertificateSubject(summary.certificateSubject);this.dialog.setCertificateSubjectAlternativeName(summary.certificateSubjectAlternativeName);this.dialog.setCertificateBeginDate(summary.certificateBeginDate);this.dialog.setCertificateEndDate(summary.certificateEndDate);this.dialog.setKeyUsages(summary.keyUsages);this.dialog.setExtendedKeyUsages(summary.extendedKeyUsages);this.dialog.setCertificateSignatureAlgorithm(summary.certificateSignatureAlgorithm);this.dialog.setCertificateSignature(summary.certificateSignature);this.dialog.setRevocationListUrls(summary.revocationListUrls);this.dialog.show(this);},onClose:function(){this.dialog.hide();}});jscape.KeyDetailsDialog=Class.extend({init:function(){this.dialog=$("#keyDetailsDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["keyDetailsDialog.title"],width:jscape.Resources.intVal("keyDetailsDialog.width"),height:jscape.Resources.intVal("keyDetailsDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.close.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onClose,this)}],onClose:$.proxy(this._onClose,this),closed:true});this.form=this.dialog.find("form");this.keyNameField=$("#keyNameField");this.keyNameField.textbox({novalidate:true,readonly:true});this.keyNameField.next("span").css({"border":"none"});this.keyAlgorithmField=$("#keyAlgorithmField");this.keyAlgorithmField.textbox({novalidate:true,readonly:true});this.keyAlgorithmField.next("span").css({"border":"none"});this.keySizeField=$("#keySizeField");this.keySizeField.textbox({novalidate:true,readonly:true});this.keySizeField.next("span").css({"border":"none"});this.certificateSerialField=$("#certificateSerialField");this.certificateSerialField.textbox({novalidate:true,readonly:true});this.certificateSerialField.next("span").css({"border":"none"});this.certificateIssuerField=$("#certificateIssuerField");this.certificateIssuerField.textbox({novalidate:true,readonly:true});this.certificateIssuerField.next("span").css({"border":"none"});this.certificateSubjectField=$("#certificateSubjectField");this.certificateSubjectField.textbox({novalidate:true,readonly:true});this.certificateSubjectField.next("span").css({"border":"none"});this.certificateSnaField=$("#certificateSnaField");this.certificateSnaField.textbox({novalidate:true,readonly:true});this.certificateSnaField.next("span").css({"border":"none"});this.certificateBeginDateField=$("#certificateBeginDateField");this.certificateBeginDateField.textbox({novalidate:true,readonly:true});this.certificateBeginDateField.next("span").css({"border":"none"});this.certificateEndDateField=$("#certificateEndDateField");this.certificateEndDateField.textbox({novalidate:true,readonly:true});this.certificateEndDateField.next("span").css({"border":"none"});this.certificateExpirationField=$("#certificateExpirationField");this.certificateExpirationField.textbox({novalidate:true,readonly:true});this.certificateExpirationField.next("span").css({"border":"none"});this.certificateKeyUsagesField=$("#certificateKeyUsagesField");this.certificateKeyUsagesField.textbox({novalidate:true,readonly:true});this.certificateKeyUsagesField.next("span").css({"border":"none"});this.certificateExtendedKeyUsagesField=$("#certificateExtendedKeyUsagesField");this.certificateExtendedKeyUsagesField.textbox({novalidate:true,readonly:true});this.certificateExtendedKeyUsagesField.next("span").css({"border":"none"});this.certificateSignatureAlgorithmField=$("#certificateSignatureAlgorithmField");this.certificateSignatureAlgorithmField.textbox({novalidate:true,readonly:true});this.certificateSignatureAlgorithmField.next("span").css({"border":"none"});this.certificateSignatureField=$("#certificateSignatureField");this.certificateSignatureField.textbox({novalidate:true,readonly:true});this.certificateSignatureField.next("span").css({"border":"none"});this.certificateClrField=$("#certificateClrField");this.certificateClrField.textbox({novalidate:true,readonly:true});this.certificateClrField.next("span").css({"border":"none"});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["keyDetailsDialog.title"].supplant({name:value}));this.keyNameField.textbox("setValue",value);},setAlgorithm:function(value){this.keyAlgorithmField.textbox("setValue",value);},setKeySize:function(value){this.keySizeField.textbox("setValue",jscape.Resources["keyDetailsDialog.keySizeField.text"].supplant({value:value}));},setCertificateSerial:function(value,hexValue){this.certificateSerialField.textbox("setValue","{value}(0x{hexValue})".supplant({value:value,hexValue:hexValue}));},setCertificateIssuer:function(value){this.certificateIssuerField.textbox("setValue",value);},setCertificateSubject:function(value){this.certificateSubjectField.textbox("setValue",value);},setCertificateSubjectAlternativeName:function(value){this.certificateSnaField.textbox("setValue",value);},setCertificateBeginDate:function(value){this.certificateBeginDateField.textbox("setValue",dateFormat(value,"UTC:HH:MM:ss mm-dd-yyyy Z"));},setCertificateEndDate:function(value){this.certificateEndDateField.textbox("setValue",dateFormat(value,"UTC:HH:MM:ss mm-dd-yyyy Z"));var now=new Date().getTime();if(now<value){this.certificateExpirationField.textbox("setValue",jscape.Resources["keyDetailsDialog.certificateExpiration.text"].supplant({days:((value-now)/(1000*3600*24)).toFixed(0)}));}else{this.certificateExpirationField.textbox("setValue",jscape.Resources["keyDetailsDialog.certificateExpired.text"]);}},setKeyUsages:function(value){var text=$.map(value,function(element,index){return jscape.Resources["keyUsage."+element];}).join(", ");this.certificateKeyUsagesField.textbox("setValue",text);},setExtendedKeyUsages:function(value){var text=$.map(value,function(element,index){return jscape.Resources["extendedKeyUsage."+element];}).join(", ");this.certificateExtendedKeyUsagesField.textbox("setValue",text);},setCertificateSignatureAlgorithm:function(value){this.certificateSignatureAlgorithmField.textbox("setValue",value);},setCertificateSignature:function(value){this.certificateSignatureField.textbox("setValue",value);},setRevocationListUrls:function(value){this.certificateClrField.textbox("setValue",value.join(", "));},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onClose:function(){this.listener.onClose();}});jscape.ImportCertificateController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;this.dialog.reset();this.dialog.setAlias(this.data.name);this.dialog.show(this);},onSubmit:function(){jscape.ApiClient.importServerCertificate(this.data.name,this.dialog.getForm(),$.proxy(this._certificateImported,this));},onCancel:function(){this.dialog.hide();},_certificateImported:function(summary){this.dialog.hide();showMessage(jscape.Resources["certificateImportedDialog.message"].supplant(summary));this.callback();}});jscape.ImportCertificateDialog=Class.extend({init:function(){this.dialog=$("#importCertificateDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["importCertificateDialog.title"],width:jscape.Resources.intVal("importCertificateDialog.width"),height:jscape.Resources.intVal("importCertificateDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["importCertificateDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.keyFileField=$("#importCertificateFileField");this.keyFileField.filebox({buttonText:jscape.Resources["button.browse.text"],buttonAlign:"right",required:true,missingMessage:jscape.Resources["importCertificateDialog.error.emptyFile.message"]});this.certificateFilePasswordField=$("#importCertificateFilePasswordField");this.certificateFilePasswordField.passwordbox({});this.certificateFileAliasField=$("#importCertificateFileAliasField");this.certificateFileAliasField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.keyFileField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["importCertificateDialog.title"].supplant({name:value}));},getForm:function(){return this.form;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.GenerateCertificateController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;var subject=this._certificateSubjectFor(this.data.certificateSubject);this.dialog.reset();this.dialog.setAlias(this.data.name);this.dialog.setCommonName(subject.CN);this.dialog.setOrganizationUnit(subject.OU);this.dialog.setOrganization(subject.O);this.dialog.setLocality(subject.L);this.dialog.setState(subject.ST);this.dialog.setCountry(subject.C);this.dialog.setSubjectAlternativeName(this.data.certificateSubjectAlternativeName);this.dialog.show(this);},onSubmit:function(){var data={validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry(),subjectAlternativeName:this.dialog.getSubjectAlternativeName()};jscape.ApiClient.generateServerCertificate(this.data.name,data,$.proxy(this._certificateGenerated,this));},onCancel:function(){this.dialog.hide();},_certificateSubjectFor:function(value){var subject={CN:"",OU:"",O:"",L:"",ST:"",C:""};var values={};var entries=value?value.split(","):[];entries.forEach(function(entry){var parts=entry.split("=");if(parts.length===2){values[parts[0].toUpperCase().trim()]=parts[1];}});return $.extend(subject,values);},_certificateGenerated:function(summary){this.dialog.hide();showMessage(jscape.Resources["certificateGeneratedDialog.message"].supplant(summary));this.callback();}});jscape.GenerateCertificateDialog=Class.extend({TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateCertificateDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateCertificateDialog.title"],width:jscape.Resources.intVal("generateCertificateDialog.width"),height:jscape.Resources.intVal("generateCertificateDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateCertificateDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.periodField=$("#generateCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generateCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateCertificateDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGenerateCertificateCommonName",jscape.Resources["generateCertificateDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generateCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generateCertificateOField");this.organizationField.textbox({});this.localityField=$("#generateCertificateLField");this.localityField.textbox({});this.stateField=$("#generateCertificateStField");this.stateField.textbox({});this.countryField=$("#generateCertificateCField");this.countryField.textbox({});this.subjectAlternativeNameField=$("#generateCertificateSnaField");this.subjectAlternativeNameField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.periodField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["generateCertificateDialog.title"].supplant({name:value}));},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},setCommonName:function(value){this.commonNameField.textbox("setValue",value);this.commonNameField.textbox("validate");},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},setOrganizationUnit:function(value){this.organizationUnitField.textbox("setValue",value);},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},setOrganization:function(value){this.organizationField.textbox("setValue",value);},getLocality:function(){return this.localityField.textbox("getValue").trim();},setLocality:function(value){this.localityField.textbox("setValue",value);},getState:function(){return this.stateField.textbox("getValue").trim();},setState:function(value){this.stateField.textbox("setValue",value);},getCountry:function(){return this.countryField.textbox("getValue").trim();},setCountry:function(value){this.countryField.textbox("setValue",value);},getSubjectAlternativeName:function(){return this.subjectAlternativeNameField.textbox("getValue").trim();},setSubjectAlternativeName:function(value){this.subjectAlternativeNameField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.ExportKeyController=Class.extend({init:function(typeDialog,passwordDialog){this.typeDialog=typeDialog;this.passwordDialog=passwordDialog;},start:function(summary){this.data=summary;this.typeDialog.reset();this.typeDialog.setAlias(this.data.name);this.typeDialog.show(this);},onSubmit:function(){var type=this.typeDialog.getType();var format=this.typeDialog.getFormat();if(type==="certificate"){this.typeDialog.hide();jscape.ApiClient.serverCertificateFor(this.data.name,format);}else if(type==="publicKey"){this.typeDialog.hide();jscape.ApiClient.serverPublicKeyFor(this.data.name,format);}else if(type==="privateKey"){this.passwordDialog.reset();this.passwordDialog.setAlias(this.data.name);this.passwordDialog.show(this);}},onCancel:function(){this.typeDialog.hide();},onPasswordSubmit:function(){this.passwordDialog.hide();this.typeDialog.hide();jscape.ApiClient.serverKeyFor(this.data.name,this.typeDialog.getFormat(),this.passwordDialog.getPassword());},onPasswordCancel:function(){this.passwordDialog.hide();}});jscape.ExportKeyDialog=Class.extend({FORMATS:{"certificate":[{value:"X509"},{value:"PEM"}],"publicKey":[{value:"X509"},{value:"PEM"},{value:"Putty"},{value:"SSH"}],"privateKey":[{value:"JKS"},{value:"PKCS12"},{value:"PKCS8"},{value:"PEM"}]},init:function(){this.dialog=$("#exportKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["exportKeyDialog.title"],width:jscape.Resources.intVal("exportKeyDialog.width"),height:jscape.Resources.intVal("exportKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["exportKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.typeBox=$("#exportKeyTypeBox");this.typeBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,onSelect:$.proxy(this._typeSelected,this)});this.formatBox=$("#exportKeyFormatBox");this.formatBox.combobox({valueField:"value",panelHeight:"auto",panelMaxHeight:150,textField:"value",editable:false});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.typeBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._typeSelected(this.getType());},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["exportKeyDialog.title"].supplant({name:value}));},getType:function(){return this.typeBox.combobox("getValue");},getFormat:function(){return this.formatBox.combobox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_typeSelected:function(data){var formats=this.FORMATS[data.value||data];if(this.formatBox){this.formatBox.combobox("loadData",formats);this.formatBox.combobox("setValue",formats[0].value).combobox("select",formats[0].value);}}});jscape.ExportKeyPasswordDialog=Class.extend({init:function(){this.dialog=$("#exportKeyPasswordDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["exportKeyPasswordDialog.title"],width:jscape.Resources.intVal("exportKeyPasswordDialog.width"),height:jscape.Resources.intVal("exportKeyPasswordDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["exportKeyPasswordDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.passwordField=$("#exportKeyPasswordField");this.passwordField.passwordbox({required:true,missingMessage:jscape.Resources["exportKeyPasswordDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredKeyPassword",jscape.Resources["exportKeyPasswordDialog.error.emptyPassword.message"])]});this.passwordConfirmationField=$("#exportKeyPasswordConfirmationField");this.passwordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["exportKeyPasswordDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredKeyPasswordConfirmation",jscape.Resources["exportKeyPasswordDialog.error.emptyPasswordConfirmation.message"]),validationRule("sameExportPasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["exportKeyPasswordDialog.error.nonEqualPasswords.message"])]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.passwordField.passwordbox("passwordbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["exportKeyPasswordDialog.title"].supplant({name:value}));},getPassword:function(){return this.passwordField.passwordbox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onPasswordSubmit();}},_onCancel:function(){this.listener.onPasswordCancel();}});jscape.DeleteKeyController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteKeyDialog.title"],this.values.length===1?jscape.Resources["deleteKeyDialog.message"].supplant(this.values[0]):jscape.Resources["deleteKeyDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.removeServerKey(this.values[this.valueIndex++].name,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["keyDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["keyDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});