/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.JmxController=Class.extend({init:function(page,changeJmxConfigurationController){this.page=page;this.changeJmxConfigurationController=changeJmxConfigurationController;},start:function(){jscape.ApiClient.jmxServiceConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeJmxConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setService(this.configuration.enabled,this.configuration.host,this.configuration.serverPort,this.configuration.rmiPort);}});jscape.JmxPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.serviceField=$("#serviceField");this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setService:function(enabled,host,serverPort,rmiPort){var text=enabled?"service:jmx:rmi://{host}:{serverPort}/jndi/rmi://{host}:{rmiPort}/gateway".supplant({host:host==="0.0.0.0"||host==="::"?"127.0.0.1":host,serverPort:serverPort,rmiPort:rmiPort}):jscape.Resources["disabled"];this.serviceField.text(text);},_onChange:function(){this.listener.onChange();}});jscape.ChangeJmxConfigurationController=Class.extend({init:function(dialog){this.dialog=dialog;this.parametersController=new jscape.JmxParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onSubmit:function(){var configuration={host:this.dialog.getHost(),serverPort:this.dialog.getServerPort(),rmiPort:this.dialog.getRmiPort(),enabled:this.dialog.isEnabled(),version:this.configuration.version};jscape.ApiClient.updateJmxServiceConfiguration(configuration,$.proxy(function(){this._configurationUpdated(configuration);},this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_parametersLoaded:function(hosts){this.dialog.setHosts(hosts);jscape.ApiClient.jmxServiceConfiguration($.proxy(this._configurationLoaded,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setEnabled(this.configuration.enabled);this.dialog.setHost(this.configuration.host);this.dialog.setServerPort(this.configuration.serverPort);this.dialog.setRmiPort(this.configuration.rmiPort);this.dialog.show(this);},_configurationUpdated:function(configuration,error){this.dialog.hide();this._showConfigurationUpdated($.proxy(function(){this.callback(configuration);},this));},_showConfigurationUpdated:function(callback){showMessage(jscape.Resources["jmxServiceConfigurationAppliedDialog.message"]);callback();}});jscape.ChangeJmxConfigurationDialog=Class.extend({TIMEOUT_FACTOR:60*1000,init:function(){this.dialog=$("#jmxConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["jmxConfigurationDialog.title"],width:jscape.Resources.intVal("jmxConfigurationDialog.width"),height:jscape.Resources.intVal("jmxConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.enabledBox=$("#enabledBox");this.enabledBox.click($.proxy(this._enableBoxClicked,this));this.hostBox=$("#hostBox");this.hostBox.combobox({editable:false,required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["jmxConfigurationDialog.error.emptyHost.message"],validType:requiredFieldRule("requiredHost",jscape.Resources["jmxConfigurationDialog.error.emptyHost.message"]),disabled:true});this.serverPortField=$("#serverPortField");this.serverPortField.numberspinner({min:1,max:65535,value:30880,increment:1,required:true,missingMessage:jscape.Resources["jmxConfigurationDialog.error.emptyServerPort.message"],disabled:true});this.rmiPortField=$("#rmiPortField");this.rmiPortField.numberspinner({min:1,max:65535,value:30880,increment:1,required:true,missingMessage:jscape.Resources["jmxConfigurationDialog.error.emptyRmiPort.message"],disabled:true});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.hostBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setHosts:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.hostBox.combobox("loadData",hosts);},isEnabled:function(){return this.enabledBox.prop("checked");},setEnabled:function(value){this.enabledBox.prop("checked",value);this._enableBoxClicked();},getHost:function(){return this.hostBox.combobox("getValue").trim();},setHost:function(value){value=value&&value.length>0?value:"::";this.hostBox.combobox("setValue",value).combobox("select",value);},getServerPort:function(){return parseInt(this.serverPortField.numberspinner("getValue"),10);},setServerPort:function(value){this.serverPortField.numberspinner("setValue",value);},getRmiPort:function(){return parseInt(this.rmiPortField.numberspinner("getValue"),10);},setRmiPort:function(value){this.rmiPortField.numberspinner("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_enableBoxClicked:function(){var enable=this.enabledBox.prop("checked")?"enable":"disable";this.hostBox.combobox(enable);this.serverPortField.numberspinner(enable);this.rmiPortField.numberspinner(enable);},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.JmxParametersController=Class.extend({start:function(callback){this.callback=callback;this._loadAddresses();},_loadAddresses:function(){jscape.ApiClient.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.callback(addresses);}});