/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.IpAccessController=Class.extend({init:function(page,changeIpAccessConfigurationController){this.page=page;this.changeIpAccessConfigurationController=changeIpAccessConfigurationController;},start:function(){jscape.ApiClient.ipAccessConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeIpAccessConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this.page.show(this);this._initPage();},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setRules(this.configuration.rules);}});jscape.IpAccessPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.rulesTable=$("#rulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"mask",title:jscape.Resources["ipaccessPage.rulesTable.column.0"],width:40,halign:"left",align:"left",sortable:false},{field:"access",title:jscape.Resources["ipaccessPage.rulesTable.column.1"],width:20,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.accessAllowed?jscape.Resources["ipaccess.allowed"]:jscape.Resources["ipaccess.denied"];}},{field:"description",title:jscape.Resources["ipaccessPage.rulesTable.column.2"],width:40,halign:"left",align:"left",sortable:false}]]});this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setRules:function(value){this.rulesTable.datagrid("loadData",value);},_onChange:function(){this.listener.onChange();}});jscape.ChangeIpAccessConfigurationController=Class.extend({init:function(dialog,addRuleController,editRuleController){this.dialog=dialog;this.addRuleController=addRuleController;this.editRuleController=editRuleController;this.rules=[];},start:function(callback){this.callback=callback;jscape.ApiClient.ipAccessConfiguration($.proxy(this._configurationLoaded,this));},onSubmit:function(){var configuration={rules:this.rules,version:this.configuration.version};jscape.ApiClient.updateIpAccessConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},onRuleUp:function(index){if(0<index&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index-1];this.rules[index-1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index-1);}},onRuleDown:function(index){if(index<this.rules.length-1&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index+1];this.rules[index+1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index+1);}},onAddRule:function(){this.addRuleController.start(this.rules,$.proxy(this._ruleAdded,this));},onEditRule:function(rule){this.editRuleController.start(rule,$.proxy(this._ruleUpdated,this));},onDeleteRule:function(rule){$.messager.confirm(jscape.Resources["deleteRuleDialog.title"],jscape.Resources["deleteRuleDialog.message"].supplant(rule),$.proxy(function(confirmed){if(confirmed){this._ruleDeleted(rule);}},this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initRules();this.dialog.reset();this.dialog.show(this);this.dialog.setRules(this.configuration.rules);},_initRules:function(){this.rules=[];var rule;var i;for(i=0;i<this.configuration.rules.length;++i){rule=$.extend({},this.configuration.rules[i]);this.rules.push(rule);}},_configurationUpdated:function(configuration){this.dialog.hide();showMessage(jscape.Resources["ipAccessConfigurationAppliedDialog.message"]);this.callback(configuration);},_ruleAdded:function(rule){this.rules.push(rule);this.dialog.setRules(this.rules);},_ruleUpdated:function(rule){var index=this._indexFor(rule.mask);this.rules[index]=rule;this.dialog.setRules(this.rules);},_ruleDeleted:function(rule){var index=this._indexFor(rule.mask);this.rules.splice(index,1);this.dialog.setRules(this.rules);},_indexFor:function(mask){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].mask===mask){return i;}}
return-1;}});jscape.ChangeIpAccessConfigurationDialog=Class.extend({init:function(){this.dialog=$("#changeIpAccessConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["changeIpAccessConfigurationDialog.title"],width:jscape.Resources.intVal("changeIpAccessConfigurationDialog.width"),height:jscape.Resources.intVal("changeIpAccessConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.rulesTable=$("#editRulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"mask",title:jscape.Resources["changeIpAccessConfigurationDialog.editRulesTable.column.0"],width:40,halign:"left",align:"left",sortable:false},{field:"access",title:jscape.Resources["changeIpAccessConfigurationDialog.editRulesTable.column.1"],width:20,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.accessAllowed?jscape.Resources["ipaccess.allowed"]:jscape.Resources["ipaccess.denied"];}},{field:"description",title:jscape.Resources["changeIpAccessConfigurationDialog.editRulesTable.column.2"],width:40,halign:"left",align:"left",sortable:false}]],onSelect:$.proxy(this._rowSelected,this),onDblClickRow:$.proxy(function(index,value){this.listener.onEditRule(value);},this)});this.ruleUpButton=$("#ruleUpButton");this.ruleUpButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleUpButton.click($.proxy(function(){if(!this.ruleUpButton.linkbutton("options").disabled){this.listener.onRuleUp(this.row);}},this));this.ruleDownButton=$("#ruleDownButton");this.ruleDownButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleDownButton.click($.proxy(function(){if(!this.ruleDownButton.linkbutton("options").disabled){this.listener.onRuleDown(this.row);}},this));this.addRuleButton=$("#addRuleButton");this.addRuleButton.linkbutton({width:jscape.Resources.buttonSize()});this.addRuleButton.click($.proxy(function(){this.listener.onAddRule();},this));this.editRuleButton=$("#editRuleButton");this.editRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editRuleButton.click($.proxy(function(){if(!this.editRuleButton.linkbutton("options").disabled){this.listener.onEditRule(this.rowValue);}},this));this.deleteRuleButton=$("#deleteRuleButton");this.deleteRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteRuleButton.click($.proxy(function(){if(!this.deleteRuleButton.linkbutton("options").disabled){this.listener.onDeleteRule(this.rowValue);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.setRules([]);},setRules:function(value){this.rulesTable.datagrid("loadData",value);this._resetButtons();},selectRule:function(index){this.rulesTable.datagrid("selectRow",index);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_rowSelected:function(row,rowValue){this.row=row;this.rowValue=rowValue;this.ruleUpButton.linkbutton(row>0?"enable":"disable");this.ruleDownButton.linkbutton(row<this.rulesTable.datagrid("getRows").length-1?"enable":"disable");this.editRuleButton.linkbutton("enable");this.deleteRuleButton.linkbutton("enable");},_resetButtons:function(){this.ruleUpButton.linkbutton("disable");this.ruleDownButton.linkbutton("disable");this.editRuleButton.linkbutton("disable");this.deleteRuleButton.linkbutton("disable");}});jscape.AddRuleController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(rules,callback){this.rules=rules;this.callback=callback;this.dialog.reset();this.dialog.show(this);},ruleExists:function(mask){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].mask===mask){return true;}}
return false;},onSubmit:function(){var rule={mask:this.dialog.getMask(),description:this.dialog.getReason(),accessAllowed:this.dialog.isAllowed()};this.dialog.hide();this.callback(rule);},onCancel:function(){this.dialog.hide();}});jscape.AddRuleDialog=Class.extend({init:function(){this.dialog=$("#addRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRuleDialog.title"],width:jscape.Resources.intVal("addRuleDialog.width"),height:jscape.Resources.intVal("addRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.maskField=$("#maskField");this.maskField.textbox({required:true,missingMessage:jscape.Resources["addRuleDialog.error.emptyMask.message"],validType:[requiredFieldRule("requiredMask",jscape.Resources["addRuleDialog.error.emptyMask.message"]),validationRule("uniqueRule",$.proxy(function(value){return!this.listener.ruleExists(value);},this),jscape.Resources["addRuleDialog.error.maskExists.message"])]});this.reasonField=$("#addReasonField");this.reasonField.textbox({});this.accessAllowedBox=$("#addAccessAllowedBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.maskField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.accessAllowedBox.prop("checked",true);},getMask:function(){return this.maskField.textbox("getValue").trim();},getReason:function(){return this.reasonField.textbox("getValue").trim();},isAllowed:function(){return this.accessAllowedBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.EditRuleController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(rule,callback){this.rule=rule;this.callback=callback;this.dialog.reset();this.dialog.setMask(this.rule.mask);this.dialog.setReason(this.rule.description);this.dialog.setAllowed(this.rule.accessAllowed);this.dialog.show(this);},ruleExists:function(){return false;},onSubmit:function(){var rule={mask:this.rule.mask,description:this.dialog.getReason(),accessAllowed:this.dialog.isAllowed()};this.dialog.hide();this.callback(rule);},onCancel:function(){this.dialog.hide();}});jscape.EditRuleDialog=Class.extend({init:function(){this.dialog=$("#editRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editRuleDialog.title"],width:jscape.Resources.intVal("editRuleDialog.width"),height:jscape.Resources.intVal("editRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.reasonField=$("#editReasonField");this.reasonField.textbox({});this.accessAllowedBox=$("#editAccessAllowedBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.reasonField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setMask:function(value){this.dialog.dialog("setTitle",jscape.Resources["editRuleDialog.title"].supplant({mask:value}));},getReason:function(){return this.reasonField.textbox("getValue").trim();},setReason:function(value){this.reasonField.textbox("setValue",value);},isAllowed:function(){return this.accessAllowedBox.prop("checked");},setAllowed:function(value){this.accessAllowedBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});