/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.ClustersController=Class.extend({init:function(page,addClusterController,editClusterController,deleteClusterController){this.page=page;this.addClusterController=addClusterController;this.editClusterController=editClusterController;this.deleteClusterController=deleteClusterController;},start:function(){this.page.show(this);},onReload:function(request,successCallback){jscape.ApiClient.clustersFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onCreateCluster:function(){this.addClusterController.start($.proxy(function(){this.page.reload();},this));},onEditCluster:function(summary){this.editClusterController.start(summary,$.proxy(function(){this.page.reload();},this));},onDeleteClusters:function(summaries){this.deleteClusterController.start(summaries,$.proxy(function(){this.page.reload();},this));}});jscape.ClustersPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.clustersTable=$("#clustersTable");this.clustersTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"name",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"name",title:jscape.Resources["clustersPage.clustersTable.column.0"],width:20,halign:"left",align:"left",sortable:true,searchable:true},{field:"protocol",title:jscape.Resources["clustersPage.clustersTable.column.1"],width:40,halign:"left",align:"left",sortable:true,searchable:true,formatter:function(value,row){return jscape.Resources["protocol."+row.protocol];}},{field:"balancingAlgorithm",title:jscape.Resources["clustersPage.clustersTable.column.2"],width:40,halign:"left",align:"left",sortable:true,searchable:true,formatter:function(value,row){return jscape.Resources["balancingAlgorithm."+row.balancingAlgorithm];},finder:{type:"combobox",options:{panelHeight:"auto",panelMaxHeight:150,width:200,data:[{text:jscape.Resources["balancingAlgorithm.ROUND_ROBIN"],value:"ROUND_ROBIN"},{text:jscape.Resources["balancingAlgorithm.WEIGHTED_ROUND_ROBIN"],value:"WEIGHTED_ROUND_ROBIN"},{text:jscape.Resources["balancingAlgorithm.RANDOM"],value:"RANDOM"},{text:jscape.Resources["balancingAlgorithm.LEAST_CONNECTIONS"],value:"LEAST_CONNECTIONS"},{text:jscape.Resources["balancingAlgorithm.WEIGHTED_LEAST_CONNECTIONS"],value:"WEIGHTED_LEAST_CONNECTIONS"}]}}},{field:"hosts",title:jscape.Resources["clustersPage.clustersTable.column.3"],width:40,halign:"left",align:"left",sortable:false,searchable:false,formatter:$.proxy(this._hostsOf,this)}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onEditCluster(this.rowValue);},this)});this.addClusterButton=$("#addClusterButton");this.addClusterButton.linkbutton({width:jscape.Resources.buttonSize()});this.addClusterButton.click($.proxy(function(){this.listener.onCreateCluster();},this));this.editClusterButton=$("#editClusterButton");this.editClusterButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editClusterButton.click($.proxy(function(){if(!this.editClusterButton.linkbutton("options").disabled){this.listener.onEditCluster(this.rowValue);}},this));this.deleteClusterButton=$("#deleteClusterButton");this.deleteClusterButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteClusterButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");this.clustersTable.datagrid("reload");},reload:function(){this.clustersTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.editClusterButton.linkbutton("enable");this.deleteClusterButton.linkbutton("enable");},_rowUnselected:function(){if(this.clustersTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.clustersTable.datagrid("options").pageNumber;if(pageNumber>1){this.clustersTable.datagrid("gotoPage",pageNumber-1);}}
this.clustersTable.datagrid("getPanel").find("div.datagrid-body td[field] div.datagrid-cell:not(:empty)").tooltip({position:"top",content:function(){return $(this).html();}});},_delete:function(){var values=this.clustersTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteClusters(values);}},_resetButtons:function(){this.editClusterButton.linkbutton("disable");this.deleteClusterButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.agentsTable.datagrid("selectRow",this.row);}},_hostsOf:function(value,cluster){var hosts="";var host;var i;for(i=0;i<cluster.hosts.length;++i){if(i>0){hosts+=", ";}
host=cluster.hosts[i];hosts+=host.enabled?"{host}:{port}".supplant(host.address):"<S>{host}:{port}</S>".supplant(host.address);}
return hosts;}});jscape.AddClusterController=Class.extend({init:function(dialog,addHostController,editHostController){this.dialog=dialog;this.addHostController=addHostController;this.editHostController=editHostController;this.hosts=[];},start:function(callback,protocol){this.callback=callback;this.hosts=[];this.dialog.reset();if(protocol){this.dialog.setProtocol(protocol);}
this.dialog.show(this);},onSubmit:function(){if(this.hosts.length===0){showWarning(jscape.Resources["addClusterDialog.error.noHosts.message"]);return;}
var cluster={name:this.dialog.getName(),protocol:this.dialog.getProtocol(),balancingAlgorithm:this.dialog.getAlgorithm(),bindingPeriod:this.dialog.getBindingPeriod(),hosts:this.hosts,version:0};jscape.ApiClient.addCluster(cluster,$.proxy(this._clusterAdded,this));},onCancel:function(){this.dialog.hide();},onHostUp:function(index){if(0<index&&this.hosts.length>1){var tmp=this.hosts[index];this.hosts[index]=this.hosts[index-1];this.hosts[index-1]=tmp;this.dialog.setHosts(this.hosts);this.dialog.selectHost(index-1);}},onHostDown:function(index){if(index<this.hosts.length-1&&this.hosts.length>1){var tmp=this.hosts[index];this.hosts[index]=this.hosts[index+1];this.hosts[index+1]=tmp;this.dialog.setHosts(this.hosts);this.dialog.selectHost(index+1);}},onAddHost:function(){this.addHostController.start(this.dialog.getProtocol(),this.dialog.getAlgorithm(),this.hosts,$.proxy(this._hostAdded,this));},onEditHost:function(host){this.editHostController.start(host,this.dialog.getAlgorithm(),$.proxy(this._hostUpdated,this));},onDeleteHost:function(host){$.messager.confirm(jscape.Resources["deleteHostDialog.title"],jscape.Resources["deleteHostDialog.message"].supplant(host.descriptor.remoteAddress),$.proxy(function(confirmed){if(confirmed){this._hostDeleted(host);}},this));},_clusterAdded:function(cluster){this.dialog.hide();this.callback(cluster);},_hostAdded:function(host){this.hosts.push(host);this.dialog.setHosts(this.hosts);},_hostUpdated:function(host){var index=this._indexFor(host.descriptor.remoteAddress);this.hosts[index]=host;this.dialog.setHosts(this.hosts);},_hostDeleted:function(host){var index=this._indexFor(host.descriptor.remoteAddress);this.hosts.splice(index,1);this.dialog.setHosts(this.hosts);},_indexFor:function(address){var i;for(i=0;i<this.hosts.length;++i){if(this.hosts[i].descriptor.remoteAddress.host===address.host&&this.hosts[i].descriptor.remoteAddress.port===address.port){return i;}}
return-1;}});jscape.AddClusterDialog=Class.extend({TTL_FACTOR:1000*60,init:function(){this.dialog=$("#addClusterDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addClusterDialog.title"],width:jscape.Resources.intVal("addClusterDialog.width"),height:jscape.Resources.intVal("addClusterDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.clusterNameField=$("#clusterNameField");this.clusterNameField.textbox({required:true,missingMessage:jscape.Resources["addClusterDialog.error.validName.message"],validType:[requiredFieldRule("addClusterFieldEmpty",jscape.Resources["addClusterDialog.error.validName.message"]),validationRule("addClusterFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["addClusterDialog.error.validName.message"])]});this.clusterProtocolField=$("#clusterProtocolField");this.clusterProtocolField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.clusterAlgorithmField=$("#addClusterAlgorithmField");this.clusterAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.clusterTtlField=$("#addClusterTtlField");this.clusterTtlField.numberspinner({min:0,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["addClusterDialog.error.emptyTtl.message"]});this.hostsTable=$("#addHostsTable");this.hostsTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"host",title:jscape.Resources["addClusterDialog.hostsTable.column.0"],width:40,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.descriptor.remoteAddress.host;}},{field:"port",title:jscape.Resources["addClusterDialog.hostsTable.column.1"],width:20,halign:"right",align:"right",sortable:false,formatter:function(value,row){return row.descriptor.remoteAddress.port;}},{field:"weight",title:jscape.Resources["addClusterDialog.hostsTable.column.2"],width:20,halign:"right",align:"right",sortable:false},{field:"status",title:jscape.Resources["addClusterDialog.hostsTable.column.3"],width:40,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.enabled?jscape.Resources["enabled"]:jscape.Resources["disabled"];}}]],onSelect:$.proxy(this._rowSelected,this),onDblClickRow:$.proxy(function(index,value){this.listener.onEditHost(value);},this)});this.hostUpButton=$("#addHostUpButton");this.hostUpButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.hostUpButton.click($.proxy(function(){if(!this.hostUpButton.linkbutton("options").disabled){this.listener.onHostUp(this.row);}},this));this.hostDownButton=$("#addHostDownButton");this.hostDownButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.hostDownButton.click($.proxy(function(){if(!this.hostDownButton.linkbutton("options").disabled){this.listener.onHostDown(this.row);}},this));this.addHostButton=$("#addAddHostButton");this.addHostButton.linkbutton({width:jscape.Resources.buttonSize()});this.addHostButton.click($.proxy(function(){this.listener.onAddHost();},this));this.editHostButton=$("#addEditHostButton");this.editHostButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editHostButton.click($.proxy(function(){if(!this.editHostButton.linkbutton("options").disabled){this.listener.onEditHost(this.rowValue);}},this));this.deleteHostButton=$("#addDeleteHostButton");this.deleteHostButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteHostButton.click($.proxy(function(){if(!this.deleteHostButton.linkbutton("options").disabled){this.listener.onDeleteHost(this.rowValue);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.clusterNameField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.setHosts([]);},getName:function(){return this.clusterNameField.textbox("getValue").trim();},getProtocol:function(){return this.clusterProtocolField.combobox("getValue");},setProtocol:function(value){this.clusterProtocolField.combobox("setValue",value).combobox("select",value);},getAlgorithm:function(){return this.clusterAlgorithmField.combobox("getValue");},getBindingPeriod:function(){return parseInt(this.clusterTtlField.numberspinner("getValue"),10)*this.TTL_FACTOR;},setHosts:function(value){this.hostsTable.datagrid("loadData",value);this._resetButtons();},selectHost:function(index){this.hostsTable.datagrid("selectRow",index);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_rowSelected:function(row,rowValue){this.row=row;this.rowValue=rowValue;this.hostUpButton.linkbutton(row>0?"enable":"disable");this.hostDownButton.linkbutton(row<this.hostsTable.datagrid("getRows").length-1?"enable":"disable");this.editHostButton.linkbutton("enable");this.deleteHostButton.linkbutton("enable");},_resetButtons:function(){this.hostUpButton.linkbutton("disable");this.hostDownButton.linkbutton("disable");this.editHostButton.linkbutton("disable");this.deleteHostButton.linkbutton("disable");}});jscape.EditClusterController=Class.extend({init:function(dialog,addHostController,editHostController){this.dialog=dialog;this.addHostController=addHostController;this.editHostController=editHostController;this.hosts=[];},start:function(summary,callback){this.data=summary;this.callback=callback;jscape.ApiClient.clusterFor(this.data.name,$.proxy(this._clusterLoaded,this));},onSubmit:function(){if(this.hosts.length===0){showWarning(jscape.Resources["editClusterDialog.error.noHosts.message"]);return;}
var cluster={name:this.data.name,protocol:this.data.protocol,balancingAlgorithm:this.dialog.getAlgorithm(),bindingPeriod:this.dialog.getBindingPeriod(),hosts:this.hosts,version:this.data.version};if(this.hosts.length===0){showWarning(jscape.Resources["addClusterDialog.error.noHosts.message"]);return;}
jscape.ApiClient.updateCluster(cluster,$.proxy(this._clusterUpdated,this));},onCancel:function(){this.dialog.hide();},onHostUp:function(index){if(0<index&&this.hosts.length>1){var tmp=this.hosts[index];this.hosts[index]=this.hosts[index-1];this.hosts[index-1]=tmp;this.dialog.setHosts(this.hosts);this.dialog.selectHost(index-1);}},onHostDown:function(index){if(index<this.hosts.length-1&&this.hosts.length>1){var tmp=this.hosts[index];this.hosts[index]=this.hosts[index+1];this.hosts[index+1]=tmp;this.dialog.setHosts(this.hosts);this.dialog.selectHost(index+1);}},onAddHost:function(){this.addHostController.start(this.data.protocol,this.dialog.getAlgorithm(),this.hosts,$.proxy(this._hostAdded,this));},onEditHost:function(host){this.editHostController.start(host,this.dialog.getAlgorithm(),$.proxy(this._hostUpdated,this));},onDeleteHost:function(host){$.messager.confirm(jscape.Resources["deleteHostDialog.title"],jscape.Resources["deleteHostDialog.message"].supplant(host.descriptor.remoteAddress),$.proxy(function(confirmed){if(confirmed){this._hostDeleted(host);}},this));},_clusterLoaded:function(data){this.data=data;this._initHosts();this.dialog.reset();this.dialog.show(this);this.dialog.setName(this.data.name);this.dialog.setAlgorithm(this.data.balancingAlgorithm);this.dialog.setBindingPeriod(this.data.bindingPeriod);this.dialog.setHosts(this.data.hosts);},_initHosts:function(){this.hosts=[];var host;var i;for(i=0;i<this.data.hosts.length;++i){host=$.extend({},this.data.hosts[i]);this.hosts.push(host);}},_clusterUpdated:function(summary){this.dialog.hide();showMessage(jscape.Resources["clusterUpdatedDialog.message"].supplant(summary));this.callback();},_hostAdded:function(host){this.hosts.push(host);this.dialog.setHosts(this.hosts);},_hostUpdated:function(host){var index=this._indexFor(host.descriptor.remoteAddress);this.hosts[index]=host;this.dialog.setHosts(this.hosts);},_hostDeleted:function(host){var index=this._indexFor(host.descriptor.remoteAddress);this.hosts.splice(index,1);this.dialog.setHosts(this.hosts);},_indexFor:function(address){var i;for(i=0;i<this.hosts.length;++i){if(this.hosts[i].descriptor.remoteAddress.host===address.host&&this.hosts[i].descriptor.remoteAddress.port===address.port){return i;}}
return-1;}});jscape.EditClusterDialog=Class.extend({TTL_FACTOR:1000*60,init:function(){this.dialog=$("#editClusterDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editClusterDialog.title"],width:jscape.Resources.intVal("editClusterDialog.width"),height:jscape.Resources.intVal("editClusterDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.clusterAlgorithmField=$("#editClusterAlgorithmField");this.clusterAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.clusterTtlField=$("#editClusterTtlField");this.clusterTtlField.numberspinner({min:0,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["editClusterDialog.error.emptyTtl.message"]});this.hostsTable=$("#editHostsTable");this.hostsTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"host",title:jscape.Resources["editClusterDialog.hostsTable.column.0"],width:40,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.descriptor.remoteAddress.host;}},{field:"port",title:jscape.Resources["editClusterDialog.hostsTable.column.1"],width:20,halign:"right",align:"right",sortable:false,formatter:function(value,row){return row.descriptor.remoteAddress.port;}},{field:"weight",title:jscape.Resources["editClusterDialog.hostsTable.column.2"],width:20,halign:"right",align:"right",sortable:false},{field:"status",title:jscape.Resources["editClusterDialog.hostsTable.column.3"],width:40,halign:"left",align:"left",sortable:false,formatter:function(value,row){return row.enabled?jscape.Resources["enabled"]:jscape.Resources["disabled"];}}]],onSelect:$.proxy(this._rowSelected,this),onDblClickRow:$.proxy(function(index,value){this.listener.onEditHost(value);},this)});this.hostUpButton=$("#editHostUpButton");this.hostUpButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.hostUpButton.click($.proxy(function(){if(!this.hostUpButton.linkbutton("options").disabled){this.listener.onHostUp(this.row);}},this));this.hostDownButton=$("#editHostDownButton");this.hostDownButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.hostDownButton.click($.proxy(function(){if(!this.hostDownButton.linkbutton("options").disabled){this.listener.onHostDown(this.row);}},this));this.addHostButton=$("#editAddHostButton");this.addHostButton.linkbutton({width:jscape.Resources.buttonSize()});this.addHostButton.click($.proxy(function(){this.listener.onAddHost();},this));this.editHostButton=$("#editEditHostButton");this.editHostButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editHostButton.click($.proxy(function(){if(!this.editHostButton.linkbutton("options").disabled){this.listener.onEditHost(this.rowValue);}},this));this.deleteHostButton=$("#editDeleteHostButton");this.deleteHostButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteHostButton.click($.proxy(function(){if(!this.deleteHostButton.linkbutton("options").disabled){this.listener.onDeleteHost(this.rowValue);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.clusterAlgorithmField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.setHosts([]);},setName:function(value){this.dialog.dialog("setTitle",jscape.Resources["editClusterDialog.title"].supplant({name:value}));},getAlgorithm:function(){return this.clusterAlgorithmField.combobox("getValue");},setAlgorithm:function(value){this.clusterAlgorithmField.combobox("setValue",value).combobox("select",value);},getBindingPeriod:function(){return this.clusterTtlField.numberspinner("getValue")*this.TTL_FACTOR;},setBindingPeriod:function(value){this.clusterTtlField.numberspinner("setValue",value/this.TTL_FACTOR);},setHosts:function(value){this.hostsTable.datagrid("loadData",value);this._resetButtons();},selectHost:function(index){this.hostsTable.datagrid("selectRow",index);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_rowSelected:function(row,rowValue){this.row=row;this.rowValue=rowValue;this.hostUpButton.linkbutton(row>0?"enable":"disable");this.hostDownButton.linkbutton(row<this.hostsTable.datagrid("getRows").length-1?"enable":"disable");this.editHostButton.linkbutton("enable");this.deleteHostButton.linkbutton("enable");},_resetButtons:function(){this.hostUpButton.linkbutton("disable");this.hostDownButton.linkbutton("disable");this.editHostButton.linkbutton("disable");this.deleteHostButton.linkbutton("disable");}});jscape.AddHostController=Class.extend({DEFAULT_PORTS:{FTP:21,FTPS:21,FTPS_IMPLICIT:990,HTTP:80,HTTPS:443,RAW:22,SSH_SFTP:22,SMTP:25,POP3:110,IMAP4:143,MYSQL:3306},WEIGHTED_ALGORITHM:{ROUND_ROBIN:false,WEIGHTED_ROUND_ROBIN:true,RANDOM:false,LEAST_CONNECTIONS:false,WEIGHTED_LEAST_CONNECTIONS:true},init:function(dialog){this.dialog=dialog;},start:function(protocol,algorithm,hosts,callback){this.hosts=hosts;this.callback=callback;this.dialog.reset();this.dialog.setPort(this.DEFAULT_PORTS[protocol]);this.dialog.setWeightEnabled(this.WEIGHTED_ALGORITHM[algorithm]);this.dialog.show(this);},hostExists:function(host,port){var i;for(i=0;i<this.hosts.length;++i){if(this.hosts[i].descriptor.remoteAddress.host===host&&this.hosts[i].descriptor.remoteAddress.port===port){return true;}}
return false;},onSubmit:function(){var host={descriptor:{remoteAddress:{host:this.dialog.getHost(),port:this.dialog.getPort()},timeout:this.dialog.getTimeout()},weight:this.dialog.getWeight(),enabled:this.dialog.isEnabled()};this.dialog.hide();this.callback(host);},onCancel:function(){this.dialog.hide();}});jscape.AddHostDialog=Class.extend({TTL_FACTOR:1000,init:function(){this.dialog=$("#addHostDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addHostDialog.title"],width:jscape.Resources.intVal("addHostDialog.width"),height:jscape.Resources.intVal("addHostDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.hostField=$("#hostField");this.hostField.textbox({required:true,missingMessage:jscape.Resources["addHostDialog.error.validHost.message"],validType:[requiredFieldRule("requiredHostName",jscape.Resources["addHostDialog.error.validHost.message"]),validationRule("uniqueHost",$.proxy(function(value){return!this.listener.hostExists(value,this.getPort());},this),jscape.Resources["addHostDialog.error.hostExists.message"])]});this.portField=$("#portField");this.portField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addHostDialog.error.emptyPort.message"]});this.timeoutField=$("#addTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addHostDialog.error.emptyTimeout.message"]});this.weightField=$("#addWeightField");this.weightField.numberspinner({min:1,max:100,value:1,increment:1,required:true,missingMessage:jscape.Resources["addHostDialog.error.emptyWeight.message"]});this.hostEnabledBox=$("#addHostEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.hostField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.hostEnabledBox.prop("checked",true);},getHost:function(){return this.hostField.textbox("getValue").trim();},getPort:function(){return parseInt(this.portField.numberspinner("getValue"),10);},setPort:function(value){this.portField.numberspinner("setValue",value);},getTimeout:function(){return this.timeoutField.numberspinner("getValue")*this.TTL_FACTOR;},setWeightEnabled:function(value){this.weightField.numberspinner(value?"enable":"disable");},getWeight:function(){return parseInt(this.weightField.numberspinner("getValue"),10);},isEnabled:function(){return this.hostEnabledBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.EditHostController=Class.extend({WEIGHTED_ALGORITHM:{ROUND_ROBIN:false,WEIGHTED_ROUND_ROBIN:true,RANDOM:false,LEAST_CONNECTIONS:false,WEIGHTED_LEAST_CONNECTIONS:true},init:function(dialog){this.dialog=dialog;},start:function(host,algorithm,callback){this.host=host;this.callback=callback;this.dialog.reset();this.dialog.setHost(this.host.descriptor.remoteAddress.host,this.host.descriptor.remoteAddress.port);this.dialog.setTimeout(this.host.descriptor.timeout);this.dialog.setWeightEnabled(this.WEIGHTED_ALGORITHM[algorithm]);this.dialog.setWeight(this.host.weight);this.dialog.setEnabled(this.host.enabled);this.dialog.show(this);},onSubmit:function(){var host={descriptor:{remoteAddress:this.host.descriptor.remoteAddress,timeout:this.dialog.getTimeout()},weight:this.dialog.getWeight(),enabled:this.dialog.isEnabled()};this.dialog.hide();this.callback(host);},onCancel:function(){this.dialog.hide();}});jscape.EditHostDialog=Class.extend({TTL_FACTOR:1000,init:function(){this.dialog=$("#editHostDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editHostDialog.title"],width:jscape.Resources.intVal("editHostDialog.width"),height:jscape.Resources.intVal("editHostDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.timeoutField=$("#editTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:30,increment:1,required:true,missingMessage:jscape.Resources["editHostDialog.error.emptyTimeout.message"]});this.weightField=$("#editWeightField");this.weightField.numberspinner({min:1,max:100,value:1,increment:1,required:true,missingMessage:jscape.Resources["editHostDialog.error.emptyWeight.message"]});this.hostEnabledBox=$("#editHostEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.timeoutField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.hostEnabledBox.prop("checked",true);},setHost:function(host,port){this.dialog.dialog("setTitle",jscape.Resources["editHostDialog.title"].supplant({host:host,port:port}));},getTimeout:function(){return this.timeoutField.numberspinner("getValue")*this.TTL_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TTL_FACTOR);},setWeightEnabled:function(value){this.weightField.numberspinner(value?"enable":"disable");},getWeight:function(){return parseInt(this.weightField.numberspinner("getValue"),10);},setWeight:function(value){this.weightField.numberspinner("setValue",value);},isEnabled:function(){return this.hostEnabledBox.prop("checked");},setEnabled:function(value){this.hostEnabledBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.DeleteClusterController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteClusterDialog.title"],this.values.length===1?jscape.Resources["deleteClusterDialog.message"].supplant(this.values[0]):jscape.Resources["deleteClusterDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.removeCluster(this.values[this.valueIndex++].name,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["clusterDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["clusterDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});