/* Copyright &#169; Advanced Systems Concepts Inc. 2009-2021. All Rights Reserved */
jscape.AgentsController=Class.extend({init:function(page,controllers){this.page=page;this.controllers=controllers;},start:function(){this.page.show(this);$.each(this.controllers,function(index,controller){controller.start();});},onTabVisible:function(index){this.controllers[index].onVisible();}});jscape.AgentsPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true,onSelect:$.proxy(function(title,index){if(this.listener){this.listener.onTabVisible(index);}},this)});},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},selectTab:function(index){this.infoPanel.tabs("select",index);}});jscape.AgentServicePanelController=Class.extend({init:function(panel,changeAgentConfigurationController,closeAgentSessionController,updateAgentApplicationController,autoUpdateInterval){this.panel=panel;this.changeAgentConfigurationController=changeAgentConfigurationController;this.closeAgentSessionController=closeAgentSessionController;this.updateAgentApplicationController=updateAgentApplicationController;this.autoUpdateInterval=autoUpdateInterval;},start:function(){jscape.ApiClient.agentServiceConfiguration($.proxy(this._configurationLoaded,this));},onVisible:function(){this.panel.resize();},onChange:function(){this.changeAgentConfigurationController.start($.proxy(this._configurationUpdated,this));},onCloseAgentSession:function(summary){this.closeAgentSessionController.start(summary,$.proxy(this._updateSessions,this));},onUpdateAgentApplication:function(summary){this.updateAgentApplicationController.start(summary,$.proxy(this._updateSessions,this));},_configurationLoaded:function(configuration){this.configuration=configuration;jscape.ApiClient.serverParameters($.proxy(this._parametersLoaded,this),true);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPanel();},_parametersLoaded:function(parameters){this.parameters=parameters;this._initPanel();this.panel.show(this);this._updateSessions(true);},_initPanel:function(){this.panel.setConfiguration(this.configuration);this.panel.setApplicationVersion(this.parameters.version);},_updateSessions:function(showError){jscape.ApiClient.agentSessions($.proxy(this._sessionsUpdated,this),showError);},_sessionsUpdated:function(summaries){this.panel.setAgentSessions(summaries);this._scheduleNextSessionsUpdate();},_scheduleNextSessionsUpdate:function(){setTimeout($.proxy(function(){this._updateSessions(false);},this),this.autoUpdateInterval);}});jscape.AgentServicePanel=Class.extend({init:function(){this.agentField=$("#agentServiceField");this.agentSessionsTable=$("#agentSessionsTable");this.agentSessionsTable.datagrid({fitColumns:true,remoteSort:true,sortName:"creationTime",sortOrder:"desc",singleSelect:true,columns:[[{field:"id",title:jscape.Resources["agentsPage.agentSessionsTable.column.0"],width:15,halign:"left",align:"left",sortable:false},{field:"username",title:jscape.Resources["agentsPage.agentSessionsTable.column.1"],width:20,halign:"left",align:"left",sortable:true},{field:"remoteAddress",title:jscape.Resources["agentsPage.agentSessionsTable.column.2"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.remoteAddress);}},{field:"creationTime",title:jscape.Resources["agentsPage.agentSessionsTable.column.3"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return dateFormat(new Date(row.creationTime),"UTC:HH:mm:ss MM-dd-yyyy Z");}},{field:"uptime",title:jscape.Resources["agentsPage.agentSessionsTable.column.4"],width:20,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._uptimeOf,this)},{field:"currentConnections",title:jscape.Resources["agentsPage.agentSessionsTable.column.5"],width:15,halign:"right",align:"right",sortable:true},{field:"currentPorts",title:jscape.Resources["agentsPage.agentSessionsTable.column.6"],width:15,halign:"right",align:"right",sortable:true},{field:"applicationVersion",title:jscape.Resources["agentsPage.agentSessionsTable.column.7"],width:10,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._formatVersion,this)},{field:"mediaFileSummary",title:jscape.Resources["agentsPage.agentSessionsTable.column.8"],width:30,halign:"left",align:"left",sortable:true,formatter:function(value,row){return row.mediaFileSummary.name;}}]],onSortColumn:$.proxy(this._sort,this),onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),onLoadSuccess:$.proxy(this._dataLoaded,this)});this.sorter={"username.asc":function(a,b){return window.sort(a.username,b.username);},"username.desc":function(a,b){return window.sort(b.username,a.username);},"remoteAddress.asc":$.proxy(function(a,b){return window.sortAddress(a.remoteAddress,b.remoteAddress);},this),"remoteAddress.desc":$.proxy(function(a,b){return window.sortAddress(b.remoteAddress,a.remoteAddress);},this),"creationTime.asc":function(a,b){return window.sort(a.creationTime,b.creationTime);},"creationTime.desc":function(a,b){return window.sort(b.creationTime,a.creationTime);},"uptime.asc":function(a,b){return window.sort(a.uptime,b.uptime);},"uptime.desc":function(a,b){return window.sort(b.uptime,a.uptime);},"currentConnections.asc":function(a,b){return window.sort(a.currentConnections,b.currentConnections);},"currentConnections.desc":function(a,b){return window.sort(b.currentConnections,a.currentConnections);},"currentPorts.asc":function(a,b){return window.sort(a.currentPorts,b.currentPorts);},"currentPorts.desc":function(a,b){return window.sort(b.currentPorts,a.currentPorts);},"applicationVersion.asc":function(a,b){return window.sort(a.applicationVersion,b.applicationVersion);},"applicationVersion.desc":function(a,b){return window.sort(b.applicationVersion,a.applicationVersion);},"mediaFileSummary.asc":function(a,b){return window.sort(a.mediaFileSummary,b.mediaFileSummary);},"mediaFileSummary.desc":function(a,b){return window.sort(b.mediaFileSummary,a.mediaFileSummary);}};this.changeButton=$("#changeAgentServiceConfigurationButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(function(){this.listener.onChange();},this));this.closeAgentSessionButton=$("#closeAgentSessionButton");this.closeAgentSessionButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.closeAgentSessionButton.click($.proxy(function(){if(!this.closeAgentSessionButton.linkbutton("options").disabled){this.listener.onCloseAgentSession(this.rowValue);}},this));this.updateAgentApplicationButton=$("#updateAgentApplicationButton");this.updateAgentApplicationButton.linkbutton({width:jscape.Resources.intVal("agentsPage.updateAgentApplicationButton.width"),disabled:true});this.updateAgentApplicationButton.click($.proxy(function(){if(!this.updateAgentApplicationButton.linkbutton("options").disabled){this.listener.onUpdateAgentApplication(this.rowValue);}},this));},show:function(listener){this.listener=listener;this.agentSessions=[];},resize:function(){this.agentSessionsTable.datagrid("resize");},setConfiguration:function(value){this.agentField.text(value.enabled?jscape.Resources["agentsPage.agentServiceField.text"].supplant({host:value.address.host,port:value.address.port,key:value.keyAlias}):jscape.Resources["disabled"]);},setApplicationVersion:function(value){this.applicationVersion=value;},setAgentSessions:function(value){this.agentSessions=value;this._sort(this.sortedColumn||"date",this.sortOrder||"desc");},_sort:function(name,order){this.sortedColumn=name;this.sortOrder=order;this.agentSessions.sort(this.sorter[name+"."+order]);this.agentSessionsTable.datagrid("loadData",this.agentSessions);},_uptimeOf:function(value,entry){var interval=new TimeInterval(entry.uptime);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_formatVersion:function(value,entry){return this.applicationVersion===entry.applicationVersion?entry.applicationVersion:"<span style='color:red;'>{applicationVersion}</span>".supplant(entry);},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.closeAgentSessionButton.linkbutton("enable");if(value.mediaFileSummary.name!==""){this.updateAgentApplicationButton.linkbutton("enable");}},_rowUnselected:function(){if(this.agentSessionsTable.datagrid("getSelections").length===0){this._resetButtons();}},_resetButtons:function(){this.closeAgentSessionButton.linkbutton("disable");this.updateAgentApplicationButton.linkbutton("disable");},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}
this.agentSessionsTable.datagrid("getPanel").find("div.datagrid-body td[field] div.datagrid-cell:not(:empty)").tooltip({position:"top",content:function(){return $(this).html();}});},_restoreSelection:function(){if(this.row>=0){this.agentSessionsTable.datagrid("selectRow",this.row);}}});jscape.ChangeAgentServiceConfigurationController=Class.extend({init:function(dialog,generateKeyController,importKeyController){this.dialog=dialog;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.parametersController=new jscape.AgentParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onGenerateKey:function(){this.generateKeyController.start($.proxy(this._keysUpdated,this));},onImportKey:function(){this.importKeyController.start($.proxy(this._keysUpdated,this));},onSubmit:function(){var configuration={address:{host:this.dialog.getHost(),port:this.dialog.getPort()},keyAlias:this.dialog.getKey(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),enabled:this.dialog.isEnabled(),version:this.configuration.version};jscape.ApiClient.updateAgentConnectorFactoryConfiguration(configuration,$.proxy(function(){this._configurationUpdated(configuration);},this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_parametersLoaded:function(hosts,keys){this.dialog.setHosts(hosts);this.dialog.setKeys(keys);jscape.ApiClient.agentServiceConfiguration($.proxy(this._configurationLoaded,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setEnabled(this.configuration.enabled);this.dialog.setHost(this.configuration.address.host);this.dialog.setPort(this.configuration.address.port);this.dialog.setKey(this.configuration.keyAlias);this.dialog.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.dialog.show(this);},_configurationUpdated:function(configuration,error){this.dialog.hide();showMessage(jscape.Resources["agentServiceConfigurationAppliedDialog.message"]);this.callback(configuration);},_keysUpdated:function(){jscape.ApiClient.serverKeyNames($.proxy(function(keys){var currentKey=this.dialog.getKey();this.dialog.setKeys(keys);if(currentKey){this.dialog.setKey(currentKey);}},this));}});jscape.ChangeAgentServiceConfigurationDialog=Class.extend({init:function(){this.dialog=$("#agentServiceConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["agentServiceConfigurationDialog.title"],width:jscape.Resources.intVal("agentServiceConfigurationDialog.width"),height:jscape.Resources.intVal("agentServiceConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.agentServiceEnabledBox=$("#agentServiceEnabledBox");this.agentServiceEnabledBox.click($.proxy(this._agentServiceEnabledBoxClicked,this));this.agentServiceHostBox=$("#agentServiceHostBox");this.agentServiceHostBox.combobox({editable:false,required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["agentServiceConfigurationDialog.error.emptyHost.message"],validType:requiredFieldRule("ConfigurationDialogHostRequired",jscape.Resources["agentConfigurationDialog.error.emptyHost.message"])});this.agentServicePortField=$("#agentServicePortField");this.agentServicePortField.numberspinner({min:1,max:65535,value:30843,increment:1,required:true,missingMessage:jscape.Resources["agentServiceConfigurationDialog.error.emptyPort.message"]});this.agentServiceKeyBox=$("#agentServiceKeyBox");this.agentServiceKeyBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.agentServiceConfigurationGenerateKeyButton=$("#agentServiceConfigurationGenerateKeyButton");this.agentServiceConfigurationGenerateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.agentServiceConfigurationGenerateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.agentServiceConfigurationImportKeyButton=$("#agentServiceConfigurationImportKeyButton");this.agentServiceConfigurationImportKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.agentServiceConfigurationImportKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.agentServiceChannelBufferSizeEnabledBox=$("#agentServiceChannelBufferSizeEnabledBox");this.agentServiceChannelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.agentServiceChannelBufferSizeField=$("#agentServiceChannelBufferSizeField");this.agentServiceChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["agentServiceConfigurationDialog.error.emptyChannelBufferSize.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.agentServiceEnabledBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setHosts:function(values){var hosts=$.map(values,function(value){return{value:value,text:value};});hosts.unshift({value:"0.0.0.0",text:jscape.Resources["ip4.any.address"]});hosts.unshift({value:"::",text:jscape.Resources["ip6.any.address"]});this.agentServiceHostBox.combobox("loadData",hosts);this.agentServiceHostBox.combobox("loadData",hosts);},setKeys:function(values){this.keys=$.map(values,function(value){return{text:value,value:value};});this.agentServiceKeyBox.combobox("loadData",this.keys);this.agentServiceEnabledBox.prop("disabled",this.keys.length===0);},getHost:function(){return this.agentServiceHostBox.combobox("getValue").trim();},setHost:function(value){value=value&&value.length>0?value:"::";this.agentServiceHostBox.combobox("setValue",value).combobox("select",value);},getPort:function(){return parseInt(this.agentServicePortField.numberspinner("getValue"),10);},setPort:function(value){this.agentServicePortField.numberspinner("setValue",value);},getKey:function(){return this.agentServiceKeyBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.agentServiceKeyBox.combobox("setValue",value).combobox("select",value);}else if(this.keys&&this.keys.length>0){this.agentServiceKeyBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},getChannelBufferSize:function(){return this.agentServiceChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.agentServiceChannelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.agentServiceChannelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.agentServiceChannelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.agentServiceChannelBufferSizeField.numberspinner("setValue",value);}},isEnabled:function(){return!this.agentServiceEnabledBox.prop("disabled")&&this.agentServiceEnabledBox.prop("checked");},setEnabled:function(value){if(!this.agentServiceEnabledBox.prop("disabled")){this.agentServiceEnabledBox.prop("checked",value);this._agentServiceEnabledBoxClicked();}},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_agentServiceEnabledBoxClicked:function(){var enable=this.agentServiceEnabledBox.prop("checked")?"enable":"disable";this.agentServiceHostBox.combobox(enable);this.agentServicePortField.numberspinner(enable);this.agentServiceKeyBox.combobox(enable);},_channelBufferSizeBoxClicked:function(){this.agentServiceChannelBufferSizeField.combobox(this.agentServiceChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.AgentParametersController=Class.extend({start:function(callback){this.callback=callback;this._loadAddresses();},_loadAddresses:function(){jscape.ApiClient.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.addresses=addresses;this._loadKeys();},_loadKeys:function(){jscape.ApiClient.serverKeyNames($.proxy(this._keysLoaded,this));},_keysLoaded:function(keys){this.callback(this.addresses,keys);}});jscape.AgentsPanelController=Class.extend({init:function(panel,addAgentController,editAgentController,deleteAgentController){this.panel=panel;this.addAgentController=addAgentController;this.editAgentController=editAgentController;this.deleteAgentController=deleteAgentController;},start:function(){this.panel.show(this);},onVisible:function(){this.panel.resize();},onReload:function(request,successCallback){jscape.ApiClient.agentsFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onCreateAgent:function(){this.addAgentController.start($.proxy(function(){this.panel.reload();},this));},onEditAgent:function(summary){this.editAgentController.start(summary,$.proxy(function(){this.panel.reload();},this));},onDeleteAgents:function(summaries){this.deleteAgentController.start(summaries,$.proxy(function(){this.panel.reload();},this));}});jscape.AgentsPanel=Class.extend({init:function(){this.agentsTable=$("#agentsTable");this.agentsTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"username",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"username",title:jscape.Resources["agentsPage.agentsTable.column.0"],width:90,halign:"left",align:"left",sortable:true,searchable:true},{field:"enabled",title:jscape.Resources["agentsPage.agentsTable.column.1"],width:10,halign:"center",align:"center",sortable:true,searchable:true,formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});},finder:{type:"combobox",options:{panelHeight:"auto",data:[{text:jscape.Resources["true"],value:1},{text:jscape.Resources["false"],value:0}]}}}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onEditAgent(this.rowValue);},this)});this.addAgentButton=$("#addAgentButton");this.addAgentButton.linkbutton({width:jscape.Resources.buttonSize()});this.addAgentButton.click($.proxy(function(){this.listener.onCreateAgent();},this));this.editAgentButton=$("#editAgentButton");this.editAgentButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editAgentButton.click($.proxy(function(){if(!this.editAgentButton.linkbutton("options").disabled){this.listener.onEditAgent(this.rowValue);}},this));this.deleteAgentButton=$("#deleteAgentButton");this.deleteAgentButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteAgentButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.agentsTable.datagrid("reload");},resize:function(){this.agentsTable.datagrid("resize");},reload:function(){this.agentsTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.editAgentButton.linkbutton("enable");this.deleteAgentButton.linkbutton("enable");},_rowUnselected:function(){if(this.agentsTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.agentsTable.datagrid("options").pageNumber;if(pageNumber>1){this.agentsTable.datagrid("gotoPage",pageNumber-1);}}},_delete:function(){var values=this.agentsTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteAgents(values);}},_resetButtons:function(){this.editAgentButton.linkbutton("disable");this.deleteAgentButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.agentsTable.datagrid("selectRow",this.row);}}});jscape.AddAgentController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var agent={username:this.dialog.getLogin(),password:this.dialog.getPassword(),enabled:this.dialog.isEnabled()};jscape.ApiClient.addAgent(agent,$.proxy(this._agentCreated,this));},onCancel:function(){this.dialog.hide();},_agentCreated:function(summary){this.dialog.hide();showMessage(jscape.Resources["agentCreatedDialog.message"].supplant(summary));this.callback();}});jscape.AddAgentDialog=Class.extend({init:function(){this.dialog=$("#addAgentDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addAgentDialog.title"],width:jscape.Resources.intVal("addAgentDialog.width"),height:jscape.Resources.intVal("addAgentDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.loginField=$("#addAgentLoginField");this.loginField.textbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.validLogin.message"],validType:[requiredFieldRule("addAgentLoginFieldEmpty",jscape.Resources["addAgentDialog.error.validLogin.message"]),validationRule("addAgentLoginFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["addAgentDialog.error.validLogin.message"])]});this.passwordField=$("#addAgentPasswordField");this.passwordField.passwordbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredPassword",jscape.Resources["addAgentDialog.error.emptyPassword.message"])]});this.passwordConfirmationField=$("#addAgentPasswordConfirmationField");this.passwordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredPasswordConfirmation",jscape.Resources["addAgentDialog.error.emptyPasswordConfirmation.message"]),validationRule("samePasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["addAgentDialog.error.nonEqualPasswords.message"])]});this.enabledBox=$("#addAgentEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.enabledBox.prop("checked",true);this.loginField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getLogin:function(){return this.loginField.textbox("getValue").trim();},getPassword:function(){return this.passwordField.passwordbox("getValue");},isEnabled:function(){return this.enabledBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.EditAgentController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;jscape.ApiClient.agentFor(this.data.username,$.proxy(this._agentLoaded,this));},onSubmit:function(){var agent={username:this.data.username,password:this.dialog.getPassword(),enabled:this.dialog.isEnabled(),version:this.data.version};jscape.ApiClient.updateAgent(agent,$.proxy(this._agentUpdated,this));},onCancel:function(){this.dialog.hide();},_agentLoaded:function(data){this.data=data;this.dialog.reset();this.dialog.setLogin(this.data.username);this.dialog.setEnabled(this.data.enabled);this.dialog.show(this);},_agentUpdated:function(summary){this.dialog.hide();showMessage(jscape.Resources["agentUpdatedDialog.message"].supplant(summary));this.callback();}});jscape.EditAgentDialog=Class.extend({init:function(){this.dialog=$("#editAgentDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editAgentDialog.title"],width:jscape.Resources.intVal("editAgentDialog.width"),height:jscape.Resources.intVal("editAgentDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.passwordField=$("#editAgentPasswordField");this.passwordField.passwordbox({});this.passwordConfirmationField=$("#editAgentPasswordConfirmationField");this.passwordConfirmationField.passwordbox({validType:[validationRule("sameEditAgentPasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["editAgentDialog.error.nonEqualPasswords.message"])]});this.enabledBox=$("#editAgentEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.passwordField.passwordbox("passwordbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setLogin:function(value){this.dialog.dialog("setTitle",jscape.Resources["editAgentDialog.title"].supplant({username:value}));},getPassword:function(){return this.passwordField.passwordbox("getValue");},isEnabled:function(){return this.enabledBox.prop("checked");},setEnabled:function(value){this.enabledBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.DeleteAgentController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteAgentDialog.title"],this.values.length===1?jscape.Resources["deleteAgentDialog.message"].supplant(this.values[0]):jscape.Resources["deleteAgentDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.removeAgent(this.values[this.valueIndex++].username,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["agentDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["agentDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});jscape.CloseAgentSessionController=Class.extend({start:function(value,callback){this.rowValue=value;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["closeAgentSessionDialog.title"],jscape.Resources["closeAgentSessionDialog.message"].supplant(this.rowValue),$.proxy(function(confirmed){if(confirmed){this._closeSession();}},this));},_closeSession:function(){jscape.ApiClient.closeAgentSession(this.rowValue.id,$.proxy(this._operationCompleted,this));},_operationCompleted:function(){showMessage(jscape.Resources["agentSessionClosedDialog.message"].supplant(this.rowValue));this.callback();}});jscape.UpdateAgentApplicationController=Class.extend({start:function(value,callback){this.rowValue=value;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["updateAgentInstallerDialog.title"],jscape.Resources["updateAgentInstallerDialog.message"].supplant(this.rowValue),$.proxy(function(confirmed){if(confirmed){this._updateInstaller();}},this));},_updateInstaller:function(){jscape.ApiClient.updateAgentInstaller(this.rowValue.id,$.proxy(this._updateCompleted,this));},_updateCompleted:function(){showMessage(jscape.Resources["agentInstallerUpdatedDialog.message"].supplant(this.rowValue));this._start();},_start:function(){if(!this.rowValue.mediaFileSummary.name.endsWith(".exe")){if(this.callback){this.callback();return;}}
$.messager.confirm(jscape.Resources["startAgentInstallerDialog.title"],jscape.Resources["startAgentInstallerDialog.message"].supplant(this.rowValue),$.proxy(function(confirmed){if(confirmed){this._startInstaller();}},this));},_startInstaller:function(){jscape.ApiClient.startAgentInstaller(this.rowValue.id,$.proxy(this._startCompleted,this));},_startCompleted:function(){showMessage(jscape.Resources["agentInstallerStartedDialog.message"].supplant(this.rowValue));this.callback();}});