import com.jscape.inet.gateway.operation.agent.GatewayAgentData;
import com.jscape.inet.gateway.operation.agent.GatewayAgentSummary;
import com.jscape.inet.gateway.operation.authentication.credentials.PasswordCredentials;
import com.jscape.inet.gateway.port.web.WebApiClient;
import com.jscape.util.Time;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.ssl.NullHostnameVerifier;
import com.jscape.util.net.ssl.SslContextFactory;

import javax.net.ssl.SSLSocketFactory;
import java.io.Console;
import java.util.UUID;
import java.util.logging.Logger;

/**
 * @author Alex Usun
 */
public class AddAgent {
    
    public static void main(String[] args)
            throws Exception {
        Console console = System.console();
        String host = console.readLine("Gateway host:");
        int port = Integer.parseInt(console.readLine("Gateway port:"));
        String username = console.readLine("Username:");
        String password = new String(console.readPassword("Password:"));
        String agentUsername = console.readLine("Agent username:");
        String agentPassword = new String(console.readPassword("Agent password:"));
        
        TransportAddress transportAddress = new TransportAddress(host, port);
        Time connectionTimeout = Time.seconds(30);
        SSLSocketFactory sslSocketFactory = SslContextFactory.defaultContext().getSocketFactory();
        NullHostnameVerifier hostnameVerifier = new NullHostnameVerifier();
        Logger logger = Logger.getLogger(UUID.randomUUID().toString());
        
        try (WebApiClient client = new WebApiClient(WebApiClient.Protocol.HTTP, transportAddress, connectionTimeout, sslSocketFactory, hostnameVerifier, logger)) {
            PasswordCredentials credentials = new PasswordCredentials(username, password);
            client.login(credentials);
    
            GatewayAgentData agentData = new GatewayAgentData(agentUsername, agentPassword, true, 0);
            GatewayAgentSummary summary = client.addAgent(agentData);
            
            System.out.println("Agent added:");
            System.out.println(summary);
        }
    }
}
