/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.install4j.api.beans.Anchor;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.styles.ControlButton;
import com.install4j.api.styles.ControlButtonContainer;
import com.install4j.api.styles.StyleContext;
import com.install4j.api.styles.StyleContextReceiver;
import com.install4j.runtime.beans.AnchorUtil;
import com.install4j.runtime.beans.screens.SystemStyle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormStyle
extends SystemStyle
implements FormPanelContainer {
    private JPanel formPanel;
    private FormEnvironment formEnvironment;
    private boolean fillHorizontal = true;
    private boolean fillVertical = true;
    private Anchor horizontalAnchor = Anchor.CENTER;
    private Anchor verticalAnchor = Anchor.CENTER;
    private boolean standalone = true;
    private StyleContext lastStyleContext;
    private List<Runnable> deferredRunnables = new ArrayList<Runnable>();

    @Override
    public boolean isFillHorizontal() {
        return this.fillHorizontal;
    }

    public void setFillHorizontal(boolean fillHorizontal) {
        this.fillHorizontal = fillHorizontal;
    }

    @Override
    public boolean isFillVertical() {
        return this.fillVertical;
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public Anchor getHorizontalAnchor() {
        return this.horizontalAnchor;
    }

    public void setHorizontalAnchor(Anchor horizontalAnchor) {
        this.horizontalAnchor = horizontalAnchor;
    }

    public Anchor getVerticalAnchor() {
        return this.verticalAnchor;
    }

    public void setVerticalAnchor(Anchor verticalAnchor) {
        this.verticalAnchor = verticalAnchor;
    }

    @Override
    public Anchor getAnchor() {
        return AnchorUtil.getAnchor(this.horizontalAnchor, this.verticalAnchor);
    }

    @Override
    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public void willActivate() {
        super.willActivate();
        if (this.formEnvironment != null) {
            for (Runnable runnable : this.deferredRunnables) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.deferredRunnables.clear();
        }
    }

    @Override
    public void setControlButtonEnabled(final ControlButtonType controlButtonType, final boolean enabled) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                ((FormComponent)((Object)controlButton)).setEnabled(enabled);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonEnabled(controlButtonType, enabled);
            }
        });
    }

    @Override
    public void setControlButtonVisible(final ControlButtonType controlButtonType, final boolean visible) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                ((FormComponent)((Object)controlButton)).setVisible(visible);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonVisible(controlButtonType, visible);
            }
        });
    }

    @Override
    public void setControlButtonText(final ControlButtonType controlButtonType, final String text) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                controlButton.setControlButtonText(text);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonText(controlButtonType, text);
            }
        });
    }

    @Override
    public void focusControlButton(final ControlButtonType controlButtonType) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                controlButton.focusControlButton();
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.focusControlButton(controlButtonType);
            }
        });
    }

    @Override
    public JComponent createComponent() {
        return this.formPanel;
    }

    @Override
    public void setStyleContext(StyleContext styleContext) {
        this.lastStyleContext = styleContext;
        if (this.formEnvironment != null) {
            this.setStyleContext();
        }
    }

    @Override
    public void setFormPanel(JPanel formPanel, FormEnvironment formEnvironment) {
        this.formPanel = formPanel;
        AnchorUtil.setAlignments(formPanel, this.getAnchor());
        this.formEnvironment = formEnvironment;
        if (this.lastStyleContext != null) {
            this.setStyleContext();
        }
    }

    private void setStyleContext() {
        if (this.lastStyleContext != null) {
            StyleContextReceiver[] styleContextReceivers;
            for (StyleContextReceiver styleContextReceiver : styleContextReceivers = this.formEnvironment.getFormComponents(StyleContextReceiver.class)) {
                styleContextReceiver.setStyleContext(this.lastStyleContext);
            }
        }
    }

    @Override
    public boolean isScrollFormPanel() {
        return false;
    }

    @Override
    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    private void visitControlButtons(final ControlButtonType controlButtonType, final ControlButtonVisitor visitor) {
        if (this.formEnvironment != null) {
            ControlButton[] formComponents;
            for (ControlButton controlButton : formComponents = this.formEnvironment.getFormComponents(ControlButton.class)) {
                if (controlButton.getControlButtonType() != controlButtonType) continue;
                visitor.visit(controlButton);
            }
        } else {
            this.deferredRunnables.add(new Runnable(){

                @Override
                public void run() {
                    FormStyle.this.visitControlButtons(controlButtonType, visitor);
                }
            });
        }
    }

    private void visitControlButtonContainers(final ControlButtonContainerVisitor visitor) {
        if (this.formEnvironment != null) {
            ControlButtonContainer[] formComponents;
            for (ControlButtonContainer controlButtonContainer : formComponents = this.formEnvironment.getFormComponents(ControlButtonContainer.class)) {
                visitor.visit(controlButtonContainer);
            }
        } else {
            this.deferredRunnables.add(new Runnable(){

                @Override
                public void run() {
                    FormStyle.this.visitControlButtonContainers(visitor);
                }
            });
        }
    }

    private static interface ControlButtonContainerVisitor {
        public void visit(ControlButtonContainer var1);
    }

    private static interface ControlButtonVisitor {
        public void visit(ControlButton var1);
    }
}

