/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) throws SSLException {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters.copyForConnection();
        if (!provTlsManager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    protected boolean allowCertificateStatus() {
        return false;
    }

    protected int getMaximumNegotiableCurveBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        return SupportedGroups.getServerMaximumNegotiableCurveBits(this.manager.getContextData().getContext().isFips(), nArray);
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        int n = SupportedGroups.getServerMaximumNegotiableFiniteFieldBits(this.manager.getContextData().getContext().isFips(), nArray);
        return n >= provEphemeralDHKeySize ? n : 0;
    }

    protected Vector getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    protected boolean preferLocalCipherSuites() {
        return this.sslParameters.getUseCipherSuitesOrder();
    }

    protected boolean selectCipherSuite(int n) throws IOException {
        TlsCredentials tlsCredentials = this.selectCredentials(n);
        if (null == tlsCredentials) {
            String string = ProvSSLContextSpi.getCipherSuiteName(n);
            LOG.finer("Server found no credentials for cipher suite: " + string);
            return false;
        }
        boolean bl = super.selectCipherSuite(n);
        if (bl) {
            this.credentials = tlsCredentials;
        }
        return bl;
    }

    protected int selectDH(int n) {
        n = Math.max(n, provEphemeralDHKeySize);
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectDHDefault(n);
        }
        return SupportedGroups.getServerSelectedFiniteField(this.getCrypto(), this.manager.getContextData().getContext().isFips(), n, nArray);
    }

    protected int selectDHDefault(int n) {
        return SupportedGroups.getServerDefaultDH(this.manager.getContextData().getContext().isFips(), n);
    }

    protected int selectECDH(int n) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectECDHDefault(n);
        }
        return SupportedGroups.getServerSelectedCurve(this.getCrypto(), this.manager.getContextData().getContext().isFips(), n, nArray);
    }

    protected int selectECDHDefault(int n) {
        return SupportedGroups.getServerDefaultECDH(this.manager.getContextData().getContext().isFips(), n);
    }

    protected ProtocolName selectProtocolName() throws IOException {
        if (null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector()) {
            return super.selectProtocolName();
        }
        List<String> list = JsseUtils.getProtocolNames(this.clientProtocolNames);
        String string = this.manager.selectApplicationProtocol(Collections.unmodifiableList(list));
        if (null == string) {
            throw new TlsFatalAlert(120);
        }
        if (string.length() < 1) {
            return null;
        }
        if (!list.contains(string)) {
            throw new TlsFatalAlert(120);
        }
        return ProtocolName.asUtf8Encoding(string);
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector();
    }

    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        List<SignatureSchemeInfo> list;
        boolean bl;
        boolean bl2 = bl = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!bl) {
            return null;
        }
        ContextData contextData = this.manager.getContextData();
        short[] sArray = new short[]{64, 1, 2};
        Vector<SignatureAndHashAlgorithm> vector = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
            list = contextData.getActiveSignatureSchemes(this.sslParameters, new ProtocolVersion[]{this.context.getServerVersion()});
            this.jsseSecurityParameters.localSigSchemes = list;
            this.jsseSecurityParameters.localSigSchemesCert = list;
            vector = contextData.getSignatureAndHashAlgorithms(list);
        }
        list = null;
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>();
        BCX509ExtendedTrustManager bCX509ExtendedTrustManager = contextData.getX509TrustManager();
        for (X509Certificate x509Certificate : bCX509ExtendedTrustManager.getAcceptedIssuers()) {
            hashSet.add(x509Certificate.getSubjectX500Principal());
        }
        if (!hashSet.isEmpty()) {
            list = new Vector<SignatureSchemeInfo>(hashSet.size());
            for (X500Principal x500Principal : hashSet) {
                ((Vector)list).addElement((SignatureSchemeInfo)X500Name.getInstance((Object)x500Principal.getEncoded()));
            }
        }
        return new CertificateRequest(sArray, vector, (Vector)list);
    }

    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    public int getSelectedCipherSuite() throws IOException {
        ContextData contextData = this.manager.getContextData();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Object object = contextData.getServerSessionContext();
        Object object2 = this.manager.getPeerHost();
        int n = this.manager.getPeerPort();
        ProvSSLSessionHandshake provSSLSessionHandshake = null == this.sslSession ? new ProvSSLSessionHandshake((ProvSSLSessionContext)object, (String)object2, n, securityParameters, this.jsseSecurityParameters) : new ProvSSLSessionResumed((ProvSSLSessionContext)object, (String)object2, n, securityParameters, this.jsseSecurityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(provSSLSessionHandshake);
        object = securityParameters.getClientSigAlgs();
        object2 = securityParameters.getClientSigAlgsCert();
        this.jsseSecurityParameters.peerSigSchemes = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object);
        List<SignatureSchemeInfo> list = this.jsseSecurityParameters.peerSigSchemesCert = object == object2 ? this.jsseSecurityParameters.peerSigSchemes : contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object2);
        if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
            throw new TlsFatalAlert(40);
        }
        this.keyManagerMissCache = new HashSet<String>();
        int n2 = super.getSelectedCipherSuite();
        this.keyManagerMissCache = null;
        object2 = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, n2);
        LOG.fine("Server selected cipher suite: " + (String)object2);
        return n2;
    }

    public Hashtable getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (null != this.matchedSNIServerName) {
            TlsExtensionsUtils.addServerNameExtensionServer(this.checkServerExtensions());
        }
        return this.serverExtensions;
    }

    public TlsSession getSessionToResume(byte[] byArray) {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        ProvSSLSession provSSLSession = provSSLSessionContext.getSessionImpl(byArray);
        if (null != provSSLSession && null != (tlsSession = provSSLSession.getTlsSession()) && this.isResumable(provSSLSession)) {
            this.sslSession = provSSLSession;
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion protocolVersion = super.getServerVersion();
        String string = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, protocolVersion);
        LOG.fine("Server selected protocol version: " + string);
        return protocolVersion;
    }

    public void notifyClientCertificate(Certificate certificate) throws IOException {
        if (!this.sslParameters.getNeedClientAuth() && !this.sslParameters.getWantClientAuth()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate || certificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                short s = TlsUtils.isTLSv13(this.context) ? (short)116 : 40;
                throw new TlsFatalAlert(s);
            }
        } else {
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(this.getCrypto(), certificate);
            TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
            short s = tlsCertificate.supportsSignatureAlgorithm((short)7) ? (short)7 : (tlsCertificate.supportsSignatureAlgorithm((short)8) ? (short)8 : tlsCertificate.getLegacySignatureAlgorithm());
            if (s < 0) {
                throw new TlsFatalAlert(43);
            }
            String string = JsseUtils.getAuthTypeClient(s);
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        Vector vector = this.context.getSecurityParametersHandshake().getClientServerNames();
        if (null != vector) {
            Collection<BCSNIMatcher> collection = this.sslParameters.getSNIMatchers();
            if (null == collection || collection.isEmpty()) {
                LOG.fine("Server ignored SNI (no matchers specified)");
            } else {
                this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(vector, collection);
                if (null == this.matchedSNIServerName) {
                    throw new TlsFatalAlert(112);
                }
                LOG.fine("Server accepted SNI: " + this.matchedSNIServerName);
            }
        }
    }

    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected boolean isResumable(ProvSSLSession provSSLSession) {
        return false;
    }

    protected TlsCredentials selectCredentials(int n) throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                Principal[] principalArray = null;
                if (1 == n2 || !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
                    return this.selectServerCredentialsLegacy(n2, principalArray);
                }
                return this.selectServerCredentials(n2, principalArray);
            }
        }
        return null;
    }

    protected TlsCredentials selectServerCredentials(int n, Principal[] principalArray) throws IOException {
        BCAlgorithmConstraints bCAlgorithmConstraints = this.sslParameters.getAlgorithmConstraints();
        short s = TlsUtils.getLegacySignatureAlgorithmServer(n);
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            short s2;
            String string;
            if (!TlsUtils.isValidSignatureSchemeForServerKeyExchange(signatureSchemeInfo.getSignatureScheme(), n) || this.keyManagerMissCache.contains(string = s == (s2 = signatureSchemeInfo.getSignatureAlgorithm()) ? JsseUtils.getKeyTypeLegacyServer(n) : JsseUtils.getKeyType(signatureSchemeInfo)) || !signatureSchemeInfo.isActive(bCAlgorithmConstraints)) continue;
            ProvX509Key provX509Key = this.manager.chooseServerKey(string, principalArray);
            if (null == provX509Key || !JsseUtils.isUsableKeyForServer(s2, provX509Key.getPrivateKey())) {
                this.keyManagerMissCache.add(string);
                continue;
            }
            return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), provX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm());
        }
        return null;
    }

    protected TlsCredentials selectServerCredentialsLegacy(int n, Principal[] principalArray) throws IOException {
        String string = JsseUtils.getKeyTypeLegacyServer(n);
        if (this.keyManagerMissCache.contains(string)) {
            return null;
        }
        ProvX509Key provX509Key = this.manager.chooseServerKey(string, principalArray);
        if (null == provX509Key || !JsseUtils.isUsableKeyForServerLegacy(n, provX509Key.getPrivateKey())) {
            this.keyManagerMissCache.add(string);
            return null;
        }
        if (1 == n) {
            return JsseUtils.createCredentialedDecryptor(this.getCrypto(), provX509Key);
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), provX509Key, null);
    }
}

