/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsSecret
extends AbstractTlsSecret {
    private static final byte[] SSL3_CONST = JceTlsSecret.generateSSL3Constants();
    protected final JcaTlsCrypto crypto;

    private static byte[] generateSSL3Constants() {
        int n = 15;
        byte[] byArray = new byte[n * (n + 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(65 + i);
            for (int j = 0; j <= i; ++j) {
                byArray[n2++] = by;
            }
        }
        return byArray;
    }

    public JceTlsSecret(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = jcaTlsCrypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        this.checkAlive();
        try {
            switch (n) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, (short)4, string, byArray, n2);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, (short)5, string, byArray, n2);
                }
            }
            return this.crypto.adoptLocalSecret(this.prf(n, string, byArray, n2));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected TlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected byte[] prf(int n, String string, byte[] byArray, int n2) throws GeneralSecurityException {
        KDFCalculator kDFCalculator;
        if (0 == n) {
            return this.prf_SSL(byArray, n2);
        }
        if (n == 1) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_1.using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else if (n == 2) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA256_HMAC).using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else if (n == 3) {
            kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(FipsKDF.TLS1_2.withPRF(FipsKDF.TLSPRF.SHA384_HMAC).using(this.data, string, (byte[][])new byte[][]{byArray}));
        } else {
            throw new IllegalStateException("unknown prf: " + n);
        }
        byte[] byArray2 = new byte[n2];
        kDFCalculator.generateBytes(byArray2);
        return byArray2;
    }

    protected byte[] prf_SSL(byte[] byArray, int n) throws GeneralSecurityException {
        MessageDigest messageDigest = this.crypto.getHelper().createDigest("MD5");
        MessageDigest messageDigest2 = this.crypto.getHelper().createDigest("SHA-1");
        int n2 = messageDigest.getDigestLength();
        int n3 = messageDigest2.getDigestLength();
        byte[] byArray2 = new byte[Math.max(n2, n3)];
        byte[] byArray3 = new byte[n];
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            messageDigest2.update(SSL3_CONST, n5, n4);
            n5 += n4++;
            messageDigest2.update(this.data, 0, this.data.length);
            messageDigest2.update(byArray, 0, byArray.length);
            messageDigest2.digest(byArray2, 0, n3);
            messageDigest.update(this.data, 0, this.data.length);
            messageDigest.update(byArray2, 0, n3);
            int n7 = n - n6;
            if (n7 < n2) {
                messageDigest.digest(byArray2, 0, n2);
                System.arraycopy(byArray2, 0, byArray3, n6, n7);
                n6 += n7;
                continue;
            }
            messageDigest.digest(byArray3, n6, n2);
            n6 += n2;
        }
        return byArray3;
    }
}

