/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net;

import com.jscape.util.aW;
import com.jscape.util.aa;
import com.jscape.util.eE;
import com.jscape.util.net.RawConnectionHandler;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncConnector;
import com.jscape.util.net.connection.AsyncRawConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.RawConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RawConnectionServer<C extends RawConnection>
extends eE<RawConnectionHandler<C>>
implements AsyncConnector.Listener<C>,
AsyncRawConnection.Listener {
    private final AsyncConnector<C> connector;
    private final String name;
    private final AtomicInteger totalConnectionCount;
    private final List<AsyncRawConnection> connections;
    private final Lock lock;
    private final Logger logger;
    private volatile boolean paused;
    private static final String[] d;

    public RawConnectionServer(AsyncConnector<C> asyncConnector, String string, Logger logger) {
        aW.a(asyncConnector);
        this.connector = asyncConnector;
        aW.a((Object)string);
        this.name = string;
        this.totalConnectionCount = new AtomicInteger(0);
        this.connections = new LinkedList<AsyncRawConnection>();
        this.lock = new ReentrantLock();
        aW.a(logger);
        this.logger = logger;
    }

    public TransportAddress boundAddress() {
        return this.connector.boundAddress();
    }

    public boolean paused() {
        return this.paused;
    }

    public int connectionCount() {
        this.lock.lock();
        try {
            int n2 = this.connections.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int totalConnectionCount() {
        return this.totalConnectionCount.get();
    }

    public Collection<AsyncRawConnection> connections() {
        this.lock.lock();
        try {
            ArrayList<AsyncRawConnection> arrayList = new ArrayList<AsyncRawConnection>(this.connections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onConnection(AsyncConnector<C> asyncConnector, C c10) {
        this.logIncomingConnection((Connection)c10);
        this.totalConnectionCount.incrementAndGet();
        try {
            AsyncRawConnection asyncRawConnection = ((RawConnectionHandler)this.b).onConnection(c10);
            this.add(asyncRawConnection);
            this.startConnection(asyncRawConnection);
        }
        catch (RawConnectionHandler.OperationException operationException) {
            c10.close();
        }
    }

    @Override
    public void onError(AsyncConnector<C> asyncConnector, Throwable throwable) {
        this.logConnectorError(throwable);
        this.a();
    }

    @Override
    public void onData(AsyncRawConnection asyncRawConnection, byte[] byArray, int n2, int n3) {
        ((RawConnectionHandler)this.b).onData(asyncRawConnection, byArray, n2, n3);
    }

    @Override
    public void onEof(AsyncRawConnection asyncRawConnection) {
        this.logConnectionEof(asyncRawConnection);
        ((RawConnectionHandler)this.b).close(asyncRawConnection);
    }

    @Override
    public void onIdle(AsyncRawConnection asyncRawConnection) {
        this.logConnectionIdle(asyncRawConnection);
        ((RawConnectionHandler)this.b).onIdle(asyncRawConnection);
    }

    @Override
    public void onError(AsyncRawConnection asyncRawConnection, Throwable throwable) {
        if (!(throwable instanceof Connection.ConnectionClosedException)) {
            this.logConnectionError(asyncRawConnection, throwable);
        }
        ((RawConnectionHandler)this.b).close(asyncRawConnection);
    }

    @Override
    public void onClosed(AsyncRawConnection asyncRawConnection) {
        this.logConnectionClosed(asyncRawConnection);
        this.remove(asyncRawConnection);
        ((RawConnectionHandler)this.b).onClosed(asyncRawConnection);
    }

    public synchronized void pause() throws aa {
        this.g();
        this.paused = true;
        this.logServicePaused();
    }

    public synchronized void resume() throws aa {
        this.g();
        this.paused = false;
        this.logServiceResumed();
    }

    @Override
    protected void actualStart() throws Exception {
        this.paused = false;
        this.connector.a(this);
        ((RawConnectionHandler)this.b).onServerStarted(this.connector.boundAddress());
        this.logServiceStarted();
    }

    @Override
    protected void actualStop() {
        this.connector.a();
        ((RawConnectionHandler)this.b).onServerStopped();
        this.logServiceStopped();
    }

    @Override
    protected void actualDispose() {
        this.connector.f();
        this.closeConnections();
        this.logServiceDisposed();
    }

    protected void closeConnections() {
        boolean bl2 = TransportAddress.c();
        for (AsyncRawConnection asyncRawConnection : this.connections()) {
            ((RawConnectionHandler)this.b).close(asyncRawConnection);
            if (bl2) continue;
        }
    }

    private void startConnection(AsyncRawConnection asyncRawConnection) {
        try {
            asyncRawConnection.start(this);
        }
        catch (Connection.ConnectionException connectionException) {
            this.logErrorStartingConnection(asyncRawConnection, connectionException);
            this.remove(asyncRawConnection);
            ((RawConnectionHandler)this.b).close(asyncRawConnection);
        }
    }

    private void add(AsyncRawConnection asyncRawConnection) {
        this.lock.lock();
        try {
            this.connections.add(asyncRawConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void remove(AsyncRawConnection asyncRawConnection) {
        this.lock.lock();
        try {
            this.connections.remove(asyncRawConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logServiceStarted() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[6], this.name, this.connector.boundAddress()));
        }
    }

    private void logServicePaused() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[8], this.name));
        }
    }

    private void logServiceResumed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[11], this.name));
        }
    }

    private void logServiceStopped() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[2], this.name));
        }
    }

    private void logServiceDisposed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[3], this.name));
        }
    }

    private void logIncomingConnection(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[1], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionEof(Connection connection) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, String.format(d[0], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectorError(Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[5], this.name), throwable);
        }
    }

    private void logConnectionIdle(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[9], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionError(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[7], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private void logConnectionClosed(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[4], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logErrorStartingConnection(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[10], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "\u0002\u000ep\u000e9%|B\u001e$\u00049%2b2\u0016Wv\u00107T]l@hk7T ~$n\u00133\u0002;\"|@]u\u001ev(}I\u00135\u000e\"\"}IGp6s82\u001bPnMs8O\t\u0012\u0002\u000ep>39dB\u000fp\u001e\"$bW\u00184C\u0013\u0002\u000ep>39dB\u000fp\t?8bH\u000e5\tx\"\u0002\u000ep\u000e9%|B\u001e$\u00049%2D\u0011?\u001e3/(\u0007&u\u001evw?\u0019]u\u001e\u000be\u0013\u0002\u000ep\u000e9%|B\u001e$\u0002$kwU\u000f?\u001fx\u001a\u0002\u000ep>39dB\u000fp\u001e\"*`S\u00184M7?2|X#0x!\u0002\u000ep\u000e9%|B\u001e$\u00049%2B\u000f\"\u0002$q2|X#Mjf,\u0007X#0x\u0011\u0002\u000ep>39dB\u000fp\u001d7>aB\u0019~ \u0002\u000ep\u000e9%|B\u001e$\u00049%2N\u0019<\blkI\u0002\u000epQ{u2\u0002\u000e\rC";
                var4_3 = "\u0002\u000ep\u000e9%|B\u001e$\u00049%2b2\u0016Wv\u00107T]l@hk7T ~$n\u00133\u0002;\"|@]u\u001ev(}I\u00135\u000e\"\"}IGp6s82\u001bPnMs8O\t\u0012\u0002\u000ep>39dB\u000fp\u001e\"$bW\u00184C\u0013\u0002\u000ep>39dB\u000fp\t?8bH\u000e5\tx\"\u0002\u000ep\u000e9%|B\u001e$\u00049%2D\u0011?\u001e3/(\u0007&u\u001evw?\u0019]u\u001e\u000be\u0013\u0002\u000ep\u000e9%|B\u001e$\u0002$kwU\u000f?\u001fx\u001a\u0002\u000ep>39dB\u000fp\u001e\"*`S\u00184M7?2|X#0x!\u0002\u000ep\u000e9%|B\u001e$\u00049%2B\u000f\"\u0002$q2|X#Mjf,\u0007X#0x\u0011\u0002\u000ep>39dB\u000fp\u001d7>aB\u0019~ \u0002\u000ep\u000e9%|B\u001e$\u00049%2N\u0019<\blkI\u0002\u000epQ{u2\u0002\u000e\rC".length();
                var1_4 = 31;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 54;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "5XuUs<6\u0004KuNhr\"P\u000ft\u001abs+\u001eOdNhs+J\n\\\u001fr<y]\u0014'\u001frAk\u0012UY'idn3\u0015X'Hdo0\u001dOc\u0014";
                    var4_3 = "5XuUs<6\u0004KuNhr\"P\u000ft\u001abs+\u001eOdNhs+J\n\\\u001fr<y]\u0014'\u001frAk\u0012UY'idn3\u0015X'Hdo0\u001dOc\u0014".length();
                    var1_4 = 42;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 17;
                            break;
                        }
                        case 1: {
                            v15 = 75;
                            break;
                        }
                        case 2: {
                            v15 = 102;
                            break;
                        }
                        case 3: {
                            v15 = 91;
                            break;
                        }
                        case 4: {
                            v15 = 96;
                            break;
                        }
                        case 5: {
                            v15 = 125;
                            break;
                        }
                        default: {
                            v15 = 36;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        RawConnectionServer.d = var5;
    }
}

