/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net;

import com.jscape.util.aW;
import com.jscape.util.aa;
import com.jscape.util.eE;
import com.jscape.util.net.MessageConnectionHandler;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncConnector;
import com.jscape.util.net.connection.AsyncMessageConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.RawConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageConnectionServer<C extends RawConnection, M>
extends eE<MessageConnectionHandler<C, M>>
implements AsyncConnector.Listener<C>,
AsyncMessageConnection.Listener<M> {
    private final AsyncConnector<C> connector;
    private final String name;
    private final AtomicInteger totalConnectionCount;
    private final List<AsyncMessageConnection<M>> connections;
    private final Lock lock;
    private final AtomicBoolean paused;
    private final AtomicReference<Throwable> error;
    private final Logger logger;
    private static final String[] d;

    public MessageConnectionServer(AsyncConnector<C> asyncConnector, String string, Logger logger) {
        aW.a(asyncConnector);
        boolean bl2 = TransportAddress.c();
        this.connector = asyncConnector;
        aW.a((Object)string);
        boolean bl3 = bl2;
        this.name = string;
        this.totalConnectionCount = new AtomicInteger(0);
        this.connections = new LinkedList<AsyncMessageConnection<M>>();
        this.lock = new ReentrantLock();
        this.paused = new AtomicBoolean(false);
        this.error = new AtomicReference();
        aW.a(logger);
        this.logger = logger;
        if (!bl3) {
            aW.b(aW.b());
        }
    }

    public TransportAddress boundAddress() {
        return this.connector.boundAddress();
    }

    public boolean paused() {
        return this.paused.get();
    }

    public int connectionCount() {
        this.lock.lock();
        try {
            int n2 = this.connections.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int totalConnectionCount() {
        return this.totalConnectionCount.get();
    }

    public Collection<AsyncMessageConnection<M>> connections() {
        this.lock.lock();
        try {
            ArrayList<AsyncMessageConnection<M>> arrayList = new ArrayList<AsyncMessageConnection<M>>(this.connections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onConnection(AsyncConnector<C> asyncConnector, C c10) {
        try {
            if (this.paused.get()) {
                c10.close();
                return;
            }
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            throw MessageConnectionServer.a(operationException);
        }
        this.logIncomingConnection((Connection)c10);
        this.totalConnectionCount.incrementAndGet();
        try {
            AsyncMessageConnection asyncMessageConnection = ((MessageConnectionHandler)this.b).onConnection(c10);
            this.add(asyncMessageConnection);
            this.startConnection(asyncMessageConnection);
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            c10.close();
        }
    }

    @Override
    public void onError(AsyncConnector<C> asyncConnector, Throwable throwable) {
        this.logConnectorError(throwable);
        this.error.set(throwable);
        this.a();
    }

    @Override
    public void onMessage(AsyncMessageConnection<M> asyncMessageConnection, M m10) {
        ((MessageConnectionHandler)this.b).onMessage(asyncMessageConnection, m10);
    }

    @Override
    public void onEof(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionEof(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onIdle(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionIdle(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onIdle(asyncMessageConnection);
    }

    @Override
    public void onError(AsyncMessageConnection<M> asyncMessageConnection, Throwable throwable) {
        if (!(throwable instanceof Connection.ConnectionClosedException)) {
            this.logConnectionError(asyncMessageConnection, throwable);
        }
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onClosed(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionClosed(asyncMessageConnection);
        this.remove(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onClosed(asyncMessageConnection);
    }

    public synchronized void pause() throws aa {
        this.g();
        this.paused.set(true);
        this.logServicePaused();
    }

    public synchronized void resume() throws aa {
        this.g();
        this.paused.set(false);
        this.logServiceResumed();
    }

    @Override
    protected void actualStart() throws Exception {
        this.paused.set(false);
        this.error.set(null);
        this.connector.a(this);
        this.assertNoErrors();
        ((MessageConnectionHandler)this.b).onServerStarted(this.connector.boundAddress());
        this.logServiceStarted();
    }

    @Override
    protected void actualStop() {
        this.connector.a();
        ((MessageConnectionHandler)this.b).onServerStopped();
        this.logServiceStopped();
    }

    @Override
    protected void actualDispose() {
        this.connector.f();
        this.closeConnections();
        this.logServiceDisposed();
    }

    private void assertNoErrors() throws Exception {
        Throwable throwable = this.error.get();
        try {
            if (throwable != null) {
                throw new Exception(throwable);
            }
        }
        catch (Exception exception) {
            throw MessageConnectionServer.a(exception);
        }
    }

    protected void closeConnections() {
        boolean bl2 = TransportAddress.b();
        for (AsyncMessageConnection<M> asyncMessageConnection : this.connections()) {
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
            if (!bl2) continue;
        }
    }

    private void startConnection(AsyncMessageConnection<M> asyncMessageConnection) {
        try {
            asyncMessageConnection.start(this);
        }
        catch (Connection.ConnectionException connectionException) {
            this.logErrorStartingConnection(asyncMessageConnection, connectionException);
            this.remove(asyncMessageConnection);
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
        }
    }

    private void add(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.add(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void remove(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.remove(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logServiceStarted() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[5], this.name, this.connector.boundAddress()));
        }
    }

    private void logServiceStopped() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[2], this.name));
        }
    }

    private void logServicePaused() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[10], this.name));
        }
    }

    private void logServiceResumed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[0], this.name));
        }
    }

    private void logServiceDisposed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[9], this.name));
        }
    }

    private void logIncomingConnection(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[6], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionEof(Connection connection) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, String.format(d[3], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectorError(Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[8], this.name), throwable);
        }
    }

    private void logConnectionIdle(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[11], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionError(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[1], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private void logConnectionClosed(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[4], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logErrorStartingConnection(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[7], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "Sf_\u0012\u0007Yl\u0013g_3\u0007Xo\u001bp\u001bo!Sf_\"\rEt\u0013v\u000b(\rE:\u0013g\r.\u0010\u0011:-0\fa^\u0006$V0\f\u001cL\u0012Sf_\u0012\u0007Yl\u0013g_2\u0016Dj\u0006p\u001bo\u001fSf_\"\rEt\u0013v\u000b(\rE:3Z9{Bp?\u00055Cl\\\u000b?\u0005HQ\"Sf_\"\rEt\u0013v\u000b(\rE:\u0015y\u00102\u0007O VNZ2B\u00177H5Z2?\u0005\u001aSf_\u0012\u0007Yl\u0013g_2\u0016Jh\u0002p\u001ba\u0003_:-0\f\u001cL$?{\u001c.\u000fBt\u00115Z2BHu\u0018{\u001a\"\u0016Bu\u0018/_\u001aGX:J8AaGXGX*3g\r.\u0010\u000bi\u0002t\r5\u000bE}V0\fa\u0001Dt\u0018p\u001c5\u000bDtL5$d\u0011\u000b&[+_d\u0011v4\u0013Sf_\"\rEt\u0013v\u000b.\u0010\u000b\u007f\u0004g\u00103L\u0013Sf_\u0012\u0007Yl\u0013g_%\u000bXj\u0019f\u001a%L";
                var4_3 = "Sf_\u0012\u0007Yl\u0013g_3\u0007Xo\u001bp\u001bo!Sf_\"\rEt\u0013v\u000b(\rE:\u0013g\r.\u0010\u0011:-0\fa^\u0006$V0\f\u001cL\u0012Sf_\u0012\u0007Yl\u0013g_2\u0016Dj\u0006p\u001bo\u001fSf_\"\rEt\u0013v\u000b(\rE:3Z9{Bp?\u00055Cl\\\u000b?\u0005HQ\"Sf_\"\rEt\u0013v\u000b(\rE:\u0015y\u00102\u0007O VNZ2B\u00177H5Z2?\u0005\u001aSf_\u0012\u0007Yl\u0013g_2\u0016Jh\u0002p\u001ba\u0003_:-0\f\u001cL$?{\u001c.\u000fBt\u00115Z2BHu\u0018{\u001a\"\u0016Bu\u0018/_\u001aGX:J8AaGXGX*3g\r.\u0010\u000bi\u0002t\r5\u000bE}V0\fa\u0001Dt\u0018p\u001c5\u000bDtL5$d\u0011\u000b&[+_d\u0011v4\u0013Sf_\"\rEt\u0013v\u000b.\u0010\u000b\u007f\u0004g\u00103L\u0013Sf_\u0012\u0007Yl\u0013g_%\u000bXj\u0019f\u001a%L".length();
                var1_4 = 18;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 125;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00036\u000fBW\t<C7\u000faS\u000e9C!\u0001 \u00036\u000fr]\u0015$C&[x]\u0015jO!Ct\b[\u0011\u00036\u000f-\u001fEj\u00036r?";
                    var4_3 = "\u00036\u000fBW\t<C7\u000faS\u000e9C!\u0001 \u00036\u000fr]\u0015$C&[x]\u0015jO!Ct\b[\u0011\u00036\u000f-\u001fEj\u00036r?".length();
                    var1_4 = 17;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 45;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 11;
                            break;
                        }
                        case 1: {
                            v15 = 104;
                            break;
                        }
                        case 2: {
                            v15 = 2;
                            break;
                        }
                        case 3: {
                            v15 = 60;
                            break;
                        }
                        case 4: {
                            v15 = 31;
                            break;
                        }
                        case 5: {
                            v15 = 86;
                            break;
                        }
                        default: {
                            v15 = 103;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        MessageConnectionServer.d = var5;
    }
}

