/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.util.StringTokenizer;

public class VersionCheck {
    public static boolean checkCompatible(String expectedLower, String expectedHigher) {
        expectedLower = VersionCheck.prepareForVersionComparison(expectedLower);
        expectedHigher = VersionCheck.prepareForVersionComparison(expectedHigher);
        StringTokenizer expectedLowerTokenizer = new StringTokenizer(expectedLower, ".");
        StringTokenizer expectedHigherTokenizer = new StringTokenizer(expectedHigher, ".");
        while (expectedLowerTokenizer.hasMoreTokens() || expectedHigherTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String[] stringArray2;
            if (expectedLowerTokenizer.hasMoreTokens()) {
                stringArray2 = VersionCheck.extractNumbers(expectedLowerTokenizer.nextToken());
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = "0";
            }
            String[] expectedLowerToken = stringArray2;
            if (expectedHigherTokenizer.hasMoreTokens()) {
                stringArray = VersionCheck.extractNumbers(expectedHigherTokenizer.nextToken());
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "";
                stringArray = stringArray4;
                stringArray4[1] = "0";
            }
            String[] expectedHigherToken = stringArray;
            if (expectedLowerToken[0].length() > 0 && expectedHigherToken[0].length() == 0) {
                return true;
            }
            if (expectedLowerToken[0].length() == 0 && expectedHigherToken[0].length() > 0) {
                return false;
            }
            int textComparison = expectedLowerToken[0].compareTo(expectedHigherToken[0]);
            if (textComparison != 0) {
                return textComparison < 0;
            }
            long expectedLowerVersionPart = Long.parseLong(expectedLowerToken[1]);
            long expectedHigherVersionPart = Long.parseLong(expectedHigherToken[1]);
            if (expectedHigherVersionPart == expectedLowerVersionPart) continue;
            return expectedHigherVersionPart > expectedLowerVersionPart;
        }
        return !expectedLowerTokenizer.hasMoreTokens();
    }

    private static String prepareForVersionComparison(String version) {
        StringBuilder comparableVersion = new StringBuilder();
        char previousCharacter = '\u0000';
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c)) {
                comparableVersion.append(c);
            } else if (c == '.' || c == '-' || c == '_') {
                if (previousCharacter != '.') {
                    comparableVersion.append(".");
                }
            } else {
                if (Character.isDigit(previousCharacter) || previousCharacter == '\u0000') {
                    comparableVersion.append(".");
                }
                comparableVersion.append(Character.toLowerCase(c));
            }
            previousCharacter = comparableVersion.charAt(comparableVersion.length() - 1);
        }
        return comparableVersion.toString();
    }

    private static String[] extractNumbers(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return new String[]{new String(chars, 0, i), new String(chars, i, chars.length - i)};
        }
        return new String[]{text, "0"};
    }
}

