/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.launcher.ErrorHandler;
import com.install4j.runtime.launcher.FirstRun;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherIntegration;
import com.install4j.runtime.launcher.LauncherVariables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class MacLauncher {
    private static boolean sandboxed;
    private static final String CONFIG_FILENAME = "/Contents/Resources/i4jlauncher.config";
    private static String exeBaseDir;

    public static void main(String[] args) {
        try {
            args = LauncherVariables.init(MacLauncher.class, args);
            String appPackageDir = System.getProperty("exe4j.moduleName");
            LauncherEngine.setProperties(MacLauncher.readProperties(appPackageDir + CONFIG_FILENAME));
            ErrorHandler.setIsGuiApplication(!LauncherEngine.getBooleanProperty(10007));
            boolean bl = sandboxed = System.getenv("APP_SANDBOX_CONTAINER_ID") != null;
            if (!sandboxed && !FirstRun.checkFirstRun()) {
                return;
            }
            LauncherIntegration.checkIntegrations();
            exeBaseDir = LauncherEngine.getBooleanProperty(10006) ? appPackageDir + "/Contents/Resources/app/" + LauncherEngine.getProperty(10001) : appPackageDir + "/../";
            if (!exeBaseDir.endsWith("/")) {
                exeBaseDir = exeBaseDir + "/";
            }
            String className = LauncherEngine.getProperty(122);
            String stdErrFile = MacLauncher.getRedirectionFileName(102, 103);
            String stdOutFile = MacLauncher.getRedirectionFileName(104, 105);
            boolean failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
            ClassLoader classLoader = Boolean.getBoolean("install4j.noDynamicClasspath") ? ClassLoader.getSystemClassLoader() : MacLauncher.getClassLoader();
            SplashEngine.setJavaSplashScreenConfig(new SplashScreenConfig().initFromLauncherEngine());
            Launcher.checkLegacySplashInterface();
            if (!LauncherEngine.getBooleanProperty(10007)) {
                SplashEngine.showSplashScreen(false);
            }
            LauncherEngine.launch(className, args, stdErrFile, stdOutFile, failOnMainMethodException, true, classLoader);
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(e.toString()).append('\n');
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                builder.append(stackTraceElement).append('\n');
            }
            ErrorHandler.reportError("error2: " + builder.toString());
            System.exit(1);
        }
    }

    private static String getRedirectionFileName(int propertyRedirect, int propertyFile) {
        String redirectionFile = "";
        if (LauncherEngine.getBooleanProperty(propertyRedirect)) {
            String file = LauncherVariables.replaceVariables(LauncherEngine.getProperty(propertyFile));
            if (!file.startsWith(File.separator)) {
                redirectionFile = exeBaseDir;
            }
            redirectionFile = redirectionFile + file;
        }
        return redirectionFile;
    }

    private static Properties readProperties(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        Properties properties = new Properties();
        properties.load(is);
        ((InputStream)is).close();
        return LauncherVariables.replaceVariables(properties);
    }

    /*
     * Unable to fully structure code
     */
    public static ClassLoader getClassLoader() throws IOException {
        java16 = System.getProperty("java.version").startsWith("1.6") != false || System.getProperty("java.version").startsWith("1.5") != false;
        urls = new ArrayList<URL>();
        tokenizer = new StringTokenizer(LauncherEngine.getProperty(121), ";");
        while (tokenizer.hasMoreTokens()) {
            currentEntry = tokenizer.nextToken();
            value = currentEntry.substring(2);
            failOnError = currentEntry.charAt(1) == '1';
            success = true;
            switch (currentEntry.charAt(0)) {
                case 'S': {
                    if (!java16 || value.startsWith("${")) break;
                    absoluteName = MacLauncher.getAbsoluteFile(value);
                    success = MacLauncher.addScanDir(urls, absoluteName, ".jar");
                    success |= MacLauncher.addScanDir(urls, absoluteName, ".zip");
                    break;
                }
                case 'E': {
                    try {
                        envVarContent = System.getenv().get(value);
                        if (envVarContent != null) {
                            envTokenizer = new StringTokenizer(envVarContent, ";:");
                            while (envTokenizer.hasMoreElements()) {
                                file = new File(envTokenizer.nextToken());
                                urls.add(file.toURI().toURL());
                                try {
                                    ClasspathModificator.addClassPath(file);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            success = true;
                            ** break;
                        }
                        if (failOnError) {
                            throw new FileNotFoundException("Environment variable " + value + " not found.");
                        }
lbl35:
                        // 3 sources

                        break;
                    }
                    catch (Throwable throwable) {
                        System.err.println(throwable.getMessage() + " for variable " + value);
                    }
                }
            }
            if (!failOnError || success) continue;
            throw new FileNotFoundException("File not found: " + value);
        }
        if (urls.isEmpty()) {
            return ClassLoader.getSystemClassLoader();
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    private static boolean addScanDir(List<URL> urls, String absoluteName, String suffix) throws MalformedURLException {
        File dir = new File(absoluteName);
        if (!dir.exists() && !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        HashSet<File> existingClassPathEntries = new HashSet<File>();
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tok.hasMoreElements()) {
            String entry = tok.nextToken();
            try {
                existingClassPathEntries.add(new File(entry).getCanonicalFile());
            }
            catch (Throwable t) {}
        }
        for (File file : files) {
            try {
                file = file.getCanonicalFile();
                if (!file.getAbsolutePath().endsWith(suffix) || existingClassPathEntries.contains(file)) continue;
                urls.add(file.toURI().toURL());
                try {
                    ClasspathModificator.addClassPath(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return true;
    }

    private static String getAbsoluteFile(String value) {
        if (new File(value).isAbsolute()) {
            return value;
        }
        return exeBaseDir + value;
    }
}

