/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.launcher.Variables;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.MacLauncher;
import com.install4j.runtime.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LauncherVariables {
    private static final String MISSING_REPLACEMENT = "null";

    public static String replaceVariables(String value) {
        value = StringUtil.replaceVariable(value, "${", "}", new StringUtil.ReplacementCallback(){

            @Override
            public String getReplacement(String token, Object memento) {
                if (token.startsWith("installer:")) {
                    return LauncherVariables.getInstallerVariable(token.substring("installer:".length()));
                }
                if (token.indexOf(58) == -1) {
                    return System.getenv().get(token);
                }
                return null;
            }
        });
        return value;
    }

    public static Properties replaceVariables(Properties properties) {
        Properties replacedProperties = new Properties();
        Iterator<Map.Entry<Object, Object>> i$ = properties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, Object> objectObjectEntry;
            Map.Entry<Object, Object> entry = objectObjectEntry = i$.next();
            String name = (String)entry.getKey();
            String value = LauncherVariables.replaceVariables((String)entry.getValue());
            replacedProperties.put(name, value);
        }
        return replacedProperties;
    }

    public static String[] init(Class mainClass, String[] args) {
        ArrayList<String> replacedArgs = null;
        if (args != null) {
            replacedArgs = new ArrayList<String>();
            String prefix = "${installer:";
            for (String arg : args) {
                if (arg.startsWith(prefix) && arg.indexOf(125) == arg.length() - 1) {
                    String variableName = arg.substring(prefix.length(), arg.length() - 1);
                    Object variableValue = Variables.getInstallerVariable(variableName);
                    if (variableValue instanceof Object[]) {
                        Object[] variableValues;
                        for (Object valueElement : variableValues = (Object[])variableValue) {
                            LauncherVariables.addIfNotEmpty(replacedArgs, LauncherVariables.replaceVariables(valueElement.toString()));
                        }
                        continue;
                    }
                    replacedArgs.add(LauncherVariables.replaceVariables(arg));
                    continue;
                }
                replacedArgs.add(LauncherVariables.replaceVariables(arg));
            }
        }
        LauncherVariables.replaceSystemProperties(mainClass);
        return replacedArgs == null ? null : replacedArgs.toArray(new String[replacedArgs.size()]);
    }

    private static void addIfNotEmpty(List<String> values, String value) {
        if (value != null && value.length() > 0) {
            values.add(value);
        }
    }

    private static String getInstallerVariable(String variableName) {
        Object value = Variables.getInstallerVariable(variableName);
        if (value == null) {
            return MISSING_REPLACEMENT;
        }
        return value.toString();
    }

    private static void replaceSystemProperties(Class mainClass) {
        Properties systemProperties = System.getProperties();
        ArrayList<String> keyNames = new ArrayList<String>(systemProperties.size());
        for (Object o : systemProperties.keySet()) {
            keyNames.add((String)o);
        }
        for (String keyName : keyNames) {
            String value = LauncherVariables.replaceVariables(System.getProperty(keyName));
            if (keyName.equals("java.library.path")) {
                if (mainClass == MacLauncher.class) {
                    String appPackage = System.getProperty("exe4j.moduleName");
                    if (appPackage != null) {
                        value = value.replaceAll(InstallerVariables.quoteRegexpSearch(appPackage + "/..//"), "/");
                        value = value.replaceAll(InstallerVariables.quoteRegexpSearch(appPackage + "/Contents/Resources/app//"), "/");
                    }
                } else if (mainClass == Launcher.class) {
                    String userDir = System.getProperty("user.dir");
                    value = value.replaceAll(InstallerVariables.quoteRegexpSearch(userDir + "//"), "/");
                }
            }
            System.setProperty(keyName, value);
        }
    }
}

