/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.versionspecific.NoHelper;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Set;
import sun.util.logging.PlatformLogger;

public class Java17Helper
extends NoHelper {
    private static Object prefsLogger;

    @Override
    public boolean isSymbolicLink(File file) {
        try {
            return Files.isSymbolicLink(file.toPath());
        }
        catch (InvalidPathException e) {
            return super.isSymbolicLink(file);
        }
    }

    @Override
    public File getSymbolicLinkTargetFile(File file) throws IOException {
        try {
            return Files.readSymbolicLink(file.toPath()).toFile();
        }
        catch (InvalidPathException e) {
            return super.getSymbolicLinkTargetFile(file);
        }
    }

    @Override
    public void createSymbolicLink(File symLink, File target) throws IOException {
        try {
            Files.createSymbolicLink(symLink.toPath(), target.toPath(), new FileAttribute[0]);
        }
        catch (InvalidPathException e) {
            super.createSymbolicLink(symLink, target);
        }
    }

    @Override
    public String getPosixFilePermissions(File file) throws IOException {
        try {
            return PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), LinkOption.NOFOLLOW_LINKS));
        }
        catch (InvalidPathException e) {
            return super.getPosixFilePermissions(file);
        }
    }

    @Override
    public void setPosixFilePermissions(File file, String mode) throws IOException {
        block6: {
            try {
                if (mode == null || mode.length() <= 0) break block6;
                if (Character.isDigit(mode.charAt(0))) {
                    mode = LegacyUnixFileSystem.toJavaTypeMode(mode);
                }
                Path path = file.toPath();
                try {
                    Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(mode));
                }
                catch (IOException e) {
                    if (!Files.isSymbolicLink(path)) {
                        throw e;
                    }
                }
            }
            catch (InvalidPathException e) {
                super.setPosixFilePermissions(file, mode);
            }
        }
    }

    @Override
    public void setOwner(File file, String userAndGroup) throws IOException {
        try {
            String user;
            int colonPos = userAndGroup.indexOf(58);
            String group = "";
            if (colonPos > -1) {
                user = userAndGroup.substring(0, colonPos);
                group = userAndGroup.substring(colonPos + 1);
            } else {
                user = userAndGroup;
            }
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            UserPrincipalLookupService principalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            if (user.length() > 0) {
                UserPrincipal userPrincipal = principalLookupService.lookupPrincipalByName(user);
                posixFileAttributeView.setOwner(userPrincipal);
            }
            if (group.length() > 0) {
                GroupPrincipal groupPrincipal = principalLookupService.lookupPrincipalByGroupName(group);
                posixFileAttributeView.setGroup(groupPrincipal);
            }
        }
        catch (InvalidPathException e) {
            super.setOwner(file, userAndGroup);
        }
    }

    @Override
    public UnixFileSystem.FileInformation getFileInformation(File file) throws IOException {
        try {
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            PosixFileAttributes attributes = posixFileAttributeView.readAttributes();
            int mode = LegacyUnixFileSystem.fromJavaTypeMode(PosixFilePermissions.toString(attributes.permissions()));
            String ownerInfo = attributes.owner().getName() + ":" + attributes.group().getName();
            String linkTarget = null;
            if (attributes.isSymbolicLink()) {
                linkTarget = this.getSymbolicLinkTargetFile(file).getPath();
            }
            return new LegacyUnixFileSystem.FileInformationImpl(mode, ownerInfo, attributes.isSymbolicLink(), linkTarget);
        }
        catch (InvalidPathException e) {
            return super.getFileInformation(file);
        }
    }

    @Override
    public void setPosixFilePermissionsRecursive(File dir, String mode) throws IOException {
        try {
            if (mode != null && mode.length() > 0) {
                if (Character.isDigit(mode.charAt(0))) {
                    mode = LegacyUnixFileSystem.toJavaTypeMode(mode);
                }
                final Set<PosixFilePermission> posixFilePermissions = PosixFilePermissions.fromString(mode);
                Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.setPosixFilePermissions(file, posixFilePermissions);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        Files.setPosixFilePermissions(dir, posixFilePermissions);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (InvalidPathException e) {
            super.setPosixFilePermissionsRecursive(dir, mode);
        }
    }

    @Override
    public void disablePreferencesLogging() {
        super.disablePreferencesLogging();
        try {
            PlatformLogger logger = PlatformLogger.getLogger("java.util.prefs");
            logger.setLevel(Integer.MAX_VALUE);
            prefsLogger = logger;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

