/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextRequestHandler
extends HttpRequestHandler {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*)");

    public TextRequestHandler(Context context) {
        super(context);
    }

    public TextRequestHandler(int mode) {
        super(null, mode);
    }

    public TextResponse getTextResponse() throws IOException, UserCanceledException {
        URLConnection connection = this.getConnection();
        String response = null;
        String contentType = connection.getContentType();
        if (this.isReadResponse() && (contentType == null || contentType.startsWith("text/") || contentType.contains("charset"))) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileUtil.pumpStream(connection.getInputStream(), out, new FileUtil.CopyProgressListener(){

                @Override
                public boolean progressPerformed(long val) {
                    return !TextRequestHandler.this.isCancelled();
                }
            });
            this.checkCancelled();
            response = new String(out.toByteArray(), this.getCharset(contentType));
        }
        int responseCode = 200;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            responseCode = httpURLConnection.getResponseCode();
        }
        return new TextResponse(response, responseCode, connection.getHeaderFields());
    }

    private void checkCancelled() throws UserCanceledException {
        if (this.isCancelled()) {
            Context context = this.getContext();
            ContextInt contextInt = ContextImpl.getContextInt(context);
            if (context != null && contextInt != null) {
                Logger.getInstance().info(contextInt.getEventSource(), "HTTP request was canceled by the user");
            }
            throw new UserCanceledException();
        }
    }

    private Charset getCharset(String contentType) {
        Matcher matcher;
        if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
            String charsetName = matcher.group(1);
            try {
                return Charset.forName(charsetName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Charset.forName("UTF-8");
    }

    @Override
    public TextRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return (TextRequestHandler)super.connect(urlString);
    }

    @Override
    public TextRequestHandler connect(String urlString, HttpRequestHandler.ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        return (TextRequestHandler)super.connect(urlString, connectionPreparer);
    }

    public class TextResponse {
        private String text;
        private int responseCode;
        private Map<String, List<String>> headerFields;

        public TextResponse(String text, int responseCode, Map<String, List<String>> headerFields) {
            this.text = text;
            this.responseCode = responseCode;
            this.headerFields = headerFields;
        }

        public String getText() {
            return this.text;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.headerFields;
        }
    }
}

