/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.context.LauncherType;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractNameAndIdConfig;
import org.w3c.dom.Element;

public class LauncherConfig
extends AbstractNameAndIdConfig {
    private String file = "";
    private LauncherType type;
    private boolean excludeFromMenu;
    private boolean uninstaller;
    private String menuName = "";

    public String getFile() {
        return this.file;
    }

    public LauncherType getType() {
        return this.type;
    }

    public boolean isExcludeFromMenu() {
        return this.excludeFromMenu;
    }

    public String getMenuName() {
        return InstallerVariables.replaceVariables(this.menuName);
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.menuName = LauncherConfig.readAttribute(element, "menuName", (String)null);
        if (this.menuName == null) {
            this.menuName = LauncherConfig.readAttribute(element, "name", (String)null);
        }
        this.file = LauncherConfig.readFileAttribute(element, "file");
        this.excludeFromMenu = LauncherConfig.readAttribute(element, "excludeFromMenu", this.excludeFromMenu);
        this.uninstaller = LauncherConfig.readAttribute(element, "uninstaller", this.uninstaller);
        String typeId = LauncherConfig.readAttribute(element, "type", "");
        if (typeId.equals("console")) {
            this.type = LauncherType.CONSOLE;
        } else if (typeId.equals("gui")) {
            this.type = LauncherType.GUI;
        } else if (typeId.equals("service")) {
            this.type = LauncherType.SERVICE;
        } else if (typeId.equals("external")) {
            this.type = LauncherType.EXTERNAL;
        } else if (typeId.equals("installerApplication")) {
            this.type = LauncherType.INSTALLER_APPLICATION;
        }
    }

    public boolean isUninstaller() {
        return this.uninstaller;
    }
}

