/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.CustomizableScreen;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;

public class CustomizableProgramGroupScreen
extends CustomizableScreen {
    private String variableName = "";
    private String initialProgramGroup = "";
    private boolean allUsers = false;
    private boolean showWarningIfExists = false;
    private String infoText = "";
    private ProgramGroupSelector programGroupSelector;
    private boolean initialized;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialProgramGroup() {
        return CustomizableProgramGroupScreen.replaceVariables(this.initialProgramGroup);
    }

    public void setInitialProgramGroup(String initialProgramGroup) {
        this.initialProgramGroup = initialProgramGroup;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    public boolean isShowWarningIfExists() {
        return this.showWarningIfExists;
    }

    public void setShowWarningIfExists(boolean showWarningIfExists) {
        this.showWarningIfExists = showWarningIfExists;
    }

    public String getInfoText() {
        return CustomizableProgramGroupScreen.replaceVariables(this.infoText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }

    @Override
    public boolean isHidden() {
        return !Util.isWindowsInstaller();
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.initProgramGroupSelector();
    }

    private void initProgramGroupSelector() {
        if (this.programGroupSelector == null) {
            this.programGroupSelector = new ProgramGroupSelector(this.allUsers, this.showWarningIfExists, this.getContext().getWizardContext());
        }
    }

    @Override
    public boolean handleUnattended() {
        this.initProgramGroupSelector();
        this.setVariable(this.getSelectedProgramGroupName());
        return true;
    }

    private String getUsedInitialProgramGroup() {
        Object value = this.getContext().getVariable(this.getVariableName());
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return this.getInitialProgramGroup();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String programGroup;
        if (!super.handleConsole(console)) {
            return false;
        }
        while (!ProgramGroupSelector.checkProgramGroup(programGroup = console.askString(null, this.getUsedInitialProgramGroup()), this.allUsers, this.showWarningIfExists, null)) {
        }
        this.setVariable(programGroup);
        return true;
    }

    @Override
    public void willActivate() {
        super.willActivate();
        this.initializeProgramGroupSelector();
    }

    @Override
    public boolean next() {
        this.setVariable(this.getSelectedProgramGroupName());
        return super.next();
    }

    @Override
    protected boolean checkCompleted() {
        return this.programGroupSelector.checkSelectedProgramGroup();
    }

    private void setVariable(String selectedProgramGroupName) {
        this.getContext().setVariable(this.getVariableName(), selectedProgramGroupName);
        this.getContext().registerResponseFileVariable(this.getVariableName());
    }

    private void initializeProgramGroupSelector() {
        if (!this.initialized) {
            this.programGroupSelector.setSelectedProgramGroup(this.getUsedInitialProgramGroup());
            this.initialized = true;
        }
    }

    private String getSelectedProgramGroupName() {
        this.initializeProgramGroupSelector();
        return this.programGroupSelector.getSelectedProgramGroup();
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        super.addScreenContent(panel, gc);
        String infoText = this.getInfoText();
        if (infoText.trim().length() > 0) {
            this.addDisplayTextArea(infoText, panel, gc);
        }
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add((Component)this.programGroupSelector, gc);
        ++gc.gridy;
    }
}

