/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import com.install4j.runtime.util.Base64;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class PasswordComponent
extends TextfieldComponent {
    private static final String ENCODING = "UTF-8";
    private boolean writeToResponseFile = false;

    @Override
    protected JTextComponent createTextComponent() {
        JPasswordField passwordField = new JPasswordField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.applyTextFieldProperties(passwordField);
        return passwordField;
    }

    public boolean isWriteToResponseFile() {
        return this.writeToResponseFile;
    }

    public void setWriteToResponseFile(boolean writeToResponseFile) {
        this.writeToResponseFile = writeToResponseFile;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JPasswordField.class;
    }

    @Override
    public boolean checkCompleted() {
        if (!super.checkCompleted()) {
            return false;
        }
        if (this.writeToResponseFile) {
            String encodedVariableName = this.getEncodedVariableName();
            try {
                byte[] bytes = this.getValue().toString().getBytes(ENCODING);
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(255 - bytes[i]);
                }
                this.getContext().setVariable(encodedVariableName, Base64.encode(bytes));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.getContext().registerResponseFileVariable(encodedVariableName);
        }
        return true;
    }

    private String getEncodedVariableName() {
        return this.getVariableName() + ".encoded";
    }

    @Override
    protected boolean isRegisterResponseFileVariable() {
        return false;
    }

    @Override
    protected void initText(JTextComponent textComponent) {
        super.initText(textComponent);
        this.getContext().registerHiddenVariable(this.getVariableName());
        String initValue = (String)this.getInitValue(null, this.getEncodedVariableName(), String.class);
        if (initValue != null) {
            try {
                byte[] bytes = Base64.decode(initValue);
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(255 - bytes[i]);
                }
                textComponent.setText(new String(bytes, ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Object getValue() {
        return this.getTextComponent().getText();
    }

    @Override
    protected String askString(Console console, String oldValue, String labelText) throws UserCanceledException {
        return console.askPassword(labelText, oldValue);
    }
}

