/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SpinnerComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class NumberSpinnerComponent
extends SpinnerComponent {
    private int minValue = 0;
    private int maxValue = 100;
    private int initialValue = 0;
    private int stepSize = 10;

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    protected SpinnerModel createSpinnerModel() {
        int initValue = (Integer)this.getInitValue(this.getInitialValue(), this.getVariableName(), Integer.class);
        return new SpinnerNumberModel(initValue, this.minValue, this.maxValue, this.stepSize);
    }

    @Override
    protected void initValue(SpinnerModel model) {
        model.setValue(this.getInitValue(this.getInitialValue(), this.getVariableName(), Integer.class));
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JSpinner spinner = this.getSpinner();
        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
        while (true) {
            String res = console.askString(this.getConsoleLabelText(false) + " [" + model.getMinimum() + "-" + model.getMaximum() + "]", String.valueOf(model.getValue()));
            try {
                Integer value = new Integer(res);
                if (value.compareTo((Integer)model.getMinimum()) < 0 || value.compareTo((Integer)model.getMaximum()) > 0) continue;
                model.setValue(value);
                return true;
            }
            catch (NumberFormatException nf) {
                continue;
            }
            break;
        }
    }
}

