/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.KeyValuePair;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestAction;
import com.install4j.runtime.beans.actions.net.HttpRequestMethod;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.TextRequestHandler;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class HttpRequestAction
extends AbstractHttpRequestAction {
    private HttpRequestMethod requestMethod = HttpRequestMethod.GET;
    private List<KeyValuePair> formData = new ArrayList<KeyValuePair>();
    private String responseVariableName = "";
    private String responseCodeVariableName = "";
    private String responseHeadersVariableName = "";
    private boolean performRollbackRequest = false;
    private String rollbackUrl = "";
    private HttpRequestMethod rollbackRequestMethod = HttpRequestMethod.GET;
    private List<KeyValuePair> rollbackFormData = new ArrayList<KeyValuePair>();

    public HttpRequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(HttpRequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public List<KeyValuePair> getFormData() {
        return this.formData;
    }

    public void setFormData(List<KeyValuePair> formData) {
        this.formData = formData;
    }

    public String getResponseVariableName() {
        return this.responseVariableName;
    }

    public void setResponseVariableName(String responseVariableName) {
        this.responseVariableName = responseVariableName;
    }

    public String getResponseCodeVariableName() {
        return this.responseCodeVariableName;
    }

    public void setResponseCodeVariableName(String responseCodeVariableName) {
        this.responseCodeVariableName = responseCodeVariableName;
    }

    public String getResponseHeadersVariableName() {
        return this.responseHeadersVariableName;
    }

    public void setResponseHeadersVariableName(String responseHeadersVariableName) {
        this.responseHeadersVariableName = responseHeadersVariableName;
    }

    public boolean isPerformRollbackRequest() {
        return this.performRollbackRequest;
    }

    public void setPerformRollbackRequest(boolean performRollbackRequest) {
        this.performRollbackRequest = performRollbackRequest;
    }

    public String getRollbackUrl() {
        return this.rollbackUrl;
    }

    public void setRollbackUrl(String rollbackUrl) {
        this.rollbackUrl = rollbackUrl;
    }

    public HttpRequestMethod getRollbackRequestMethod() {
        return this.rollbackRequestMethod;
    }

    public void setRollbackRequestMethod(HttpRequestMethod rollbackRequestMethod) {
        this.rollbackRequestMethod = rollbackRequestMethod;
    }

    public List<KeyValuePair> getRollbackFormData() {
        return this.rollbackFormData;
    }

    public void setRollbackFormData(List<KeyValuePair> rollbackFormData) {
        this.rollbackFormData = rollbackFormData;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            TextRequestHandler.TextResponse textResponse = this.performRequest(context, this.getUrl(), this.getRequestMethod(), this.getFormData());
            if (!this.responseVariableName.isEmpty()) {
                context.registerHiddenVariable(this.responseVariableName);
                context.setVariable(this.responseVariableName, textResponse.getText());
            }
            if (!this.responseCodeVariableName.isEmpty()) {
                context.setVariable(this.responseCodeVariableName, textResponse.getResponseCode());
            }
            if (!this.responseHeadersVariableName.isEmpty()) {
                context.registerHiddenVariable(this.responseHeadersVariableName);
                context.setVariable(this.responseHeadersVariableName, textResponse.getHeaderFields());
            }
            return textResponse.getResponseCode() / 200 == 1;
        }
        catch (UserCanceledException e) {
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
            return false;
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "HTTP request failed");
            Logger.getInstance().log(e);
            return false;
        }
    }

    private TextRequestHandler.TextResponse performRequest(Context context, String url, HttpRequestMethod requestMethod, List<KeyValuePair> formData) throws IOException, UserCanceledException {
        TextRequestHandler handler = new TextRequestHandler(context);
        this.applyCommonProperties(handler);
        HttpRequestAction.performRequest(handler, url, requestMethod, formData);
        return handler.getTextResponse();
    }

    private static void performRequest(TextRequestHandler handler, String url, final HttpRequestMethod requestMethod, final List<KeyValuePair> formData) throws IOException, UserCanceledException {
        handler.connect(HttpRequestAction.createConnectionUrl(url, requestMethod, formData), new HttpRequestHandler.ConnectionPreparer(){

            @Override
            public void prepare(URLConnection urlConnection) throws IOException {
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection connection = (HttpURLConnection)urlConnection;
                    connection.setRequestMethod(requestMethod.getMethodName());
                    if (requestMethod.isBodyFormData()) {
                        String requestData = HttpRequestAction.createRequestData(formData);
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        connection.setRequestProperty("Cache-Control", "no-cache");
                        connection.setRequestProperty("Content-Length", String.valueOf(requestData.length()));
                        connection.setDoOutput(true);
                        PrintStream out = new PrintStream(connection.getOutputStream());
                        out.print(requestData);
                        out.close();
                    }
                }
            }
        });
    }

    private static String createConnectionUrl(String url, HttpRequestMethod requestMethod, List<KeyValuePair> formData) {
        String requestData;
        StringBuilder buffer = new StringBuilder();
        buffer.append(url);
        if (!requestMethod.isBodyFormData() && !(requestData = HttpRequestAction.createRequestData(formData)).isEmpty()) {
            if (!url.contains("?")) {
                buffer.append('?');
            }
            if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '?') {
                buffer.append('&');
            }
            buffer.append(requestData);
        }
        return buffer.toString();
    }

    private static String createRequestData(List<KeyValuePair> formData) {
        StringBuilder buffer = new StringBuilder();
        for (KeyValuePair keyValuePair : formData) {
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            buffer.append(HttpRequestAction.replaceVariables(keyValuePair.getKey()));
            buffer.append("=");
            try {
                buffer.append(URLEncoder.encode(HttpRequestAction.replaceVariables(keyValuePair.getValue()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer.toString();
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        if (this.isPerformRollbackRequest()) {
            try {
                this.performRequest(context, this.getRollbackUrl(), this.getRollbackRequestMethod(), this.getRollbackFormData());
            }
            catch (IOException e) {
                Logger.getInstance().error(this, "HTTP rollback request failed");
                Logger.getInstance().log(e);
                e.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
        }
    }
}

