/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.net.DownloadAction;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.Md5Checker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DownloadFileAction
extends DownloadAction {
    private File targetFile;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean deleteOnExit = false;
    private boolean checkForMd5Sums = false;
    private String md5Url = "";
    private boolean dontAskForRetry = false;
    private boolean retryIfInterrupted = true;

    public boolean isCheckForMd5Sums() {
        return this.checkForMd5Sums;
    }

    public void setCheckForMd5Sums(boolean checkForMd5Sums) {
        this.checkForMd5Sums = checkForMd5Sums;
    }

    public String getMd5Url() {
        return this.md5Url;
    }

    public void setMd5Url(String md5Url) {
        this.md5Url = md5Url;
    }

    public boolean isDontAskForRetry() {
        return this.dontAskForRetry;
    }

    public void setDontAskForRetry(boolean dontAskForRetry) {
        this.dontAskForRetry = dontAskForRetry;
    }

    public boolean isRetryIfInterrupted() {
        return this.retryIfInterrupted;
    }

    public void setRetryIfInterrupted(boolean retryIfInterrupted) {
        this.retryIfInterrupted = retryIfInterrupted;
    }

    public File getTargetFile() {
        return DownloadFileAction.replaceVariables(this.targetFile);
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean bl;
        block12: {
            VariableResourceBundleWrapper messages = Messages.getMessages();
            File file = context.getDestinationFile(this.getTargetFile());
            ProgressInterface progressInterface = context.getProgressInterface();
            if (this.showProgress) {
                if (this.showFileName) {
                    String fileName = file.getName();
                    progressInterface.setStatusMessage("<html><nobr>" + Messages.format(messages.getString("DownloadingWithFileName"), "<b>" + fileName + "</b>") + "</nobr>");
                } else {
                    progressInterface.setStatusMessage(messages.getString("Downloading"));
                }
            } else {
                progressInterface = new NoPercentageProgressDelegate(progressInterface);
            }
            BackupFileForRollbackAction backupFileForRollbackAction = null;
            if (context instanceof InstallerContext && file.exists()) {
                backupFileForRollbackAction = new BackupFileForRollbackAction(file, true);
                backupFileForRollbackAction.install((InstallerContext)context);
                this.addRollbackAction(backupFileForRollbackAction);
            }
            try {
                Downloader downloader = this.createDownloader(context, this.showProgress ? progressInterface : null);
                bl = DownloadFileAction.doDownload(downloader, context, file, this.getUrl(), this.isAskForProxy(), this.isDeleteOnExit(), this.isRetryIfInterrupted(), this.isCheckForMd5Sums(), this.getMd5Url(), this.isDontAskForRetry());
                if (backupFileForRollbackAction == null) break block12;
            }
            catch (IOException e) {
                boolean bl2;
                block13: {
                    try {
                        if (this.isShowError()) {
                            Util.showErrorMessage(Messages.format(messages.getString("updater.DownloadError"), this.getUrl()));
                        }
                        Logger.getInstance().error(this, "Could not download file");
                        Logger.getInstance().log(e);
                        if (backupFileForRollbackAction != null) {
                            backupFileForRollbackAction.rollback((InstallerContext)context);
                            backupFileForRollbackAction = null;
                        }
                        bl2 = false;
                        if (backupFileForRollbackAction == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (backupFileForRollbackAction != null) {
                            this.addRollbackAction(backupFileForRollbackAction);
                        }
                        throw throwable;
                    }
                    this.addRollbackAction(backupFileForRollbackAction);
                }
                return bl2;
            }
            this.addRollbackAction(backupFileForRollbackAction);
        }
        return bl;
    }

    private static boolean doDownload(Downloader downloader, Context context, File file, String url, boolean askForProxy, boolean deleteOnExit, boolean retryIfInterrupted, boolean checkForMd5Sums, String md5Url, boolean dontAskForRetry) throws UserCanceledException, IOException {
        boolean success = true;
        String expectedMd5 = null;
        String realMd5 = null;
        while (true) {
            boolean retry = false;
            try {
                downloader.connect(url);
            }
            catch (UserCanceledException e) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                success = false;
            }
            if (success) {
                try {
                    downloader.download(file, -1L, deleteOnExit);
                    realMd5 = Md5Checker.getHexStringFromBytes(downloader.digest());
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (retryIfInterrupted) {
                        Logger.getInstance().error(DownloadFileAction.class, "Could not download file");
                        Logger.getInstance().log(e);
                        retry = success = DownloadFileAction.askRetry("DownloadInterrupted");
                    }
                    throw e;
                }
            }
            if (retry) continue;
            if (success) {
                if (expectedMd5 == null) {
                    if (checkForMd5Sums) {
                        String urlString = md5Url;
                        if (urlString == null || urlString.trim().length() == 0) {
                            urlString = Md5Checker.createMd5Url(url);
                        }
                        expectedMd5 = Md5Checker.getExpectedMd5(context, askForProxy, urlString, file.getName());
                    } else {
                        expectedMd5 = "";
                    }
                }
                if (!"".equals(expectedMd5)) {
                    Logger.getInstance().info(DownloadFileAction.class, "Expected md5 " + expectedMd5 + ", real md5 " + realMd5);
                    if (!expectedMd5.equals(realMd5)) {
                        downloader.resetLastTransfer();
                        success = dontAskForRetry ? false : DownloadFileAction.askRetry("DownloadFileCorrupt");
                    }
                }
            }
            if (!success || "".equals(expectedMd5) || realMd5.equals(expectedMd5)) break;
        }
        return success;
    }
}

