/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractJdbcAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    private String driverClassName = "";
    private String jdbcUrl = "";
    private String user = "";
    private String password = "";
    private Map<String, String> jdbcProperties = new LinkedHashMap<String, String>();

    public String getDriverClassName() {
        return AbstractJdbcAction.replaceVariables(this.driverClassName);
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return AbstractJdbcAction.replaceVariables(this.jdbcUrl);
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return AbstractJdbcAction.replaceVariables(this.user);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return AbstractJdbcAction.replaceVariables(this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            Class.forName(this.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().log(this, "Driver class " + this.getDriverClassName() + " was not found. Add the JAR file oo the \"Installer->Custom code & resources\" step.", false);
            return false;
        }
        catch (Throwable t) {
            Logger.getInstance().log(this, "Error initializing driver", false);
            Logger.getInstance().log(t);
            return false;
        }
        return this.executeJdbcCall(context);
    }

    protected abstract boolean executeJdbcCall(Context var1);

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (propertyName.equals("password") && !Boolean.getBoolean("install4j.logJdbcPassword")) {
            return "[logging of password is disabled]";
        }
        return propertyValue;
    }

    protected Connection createConnection() throws SQLException {
        Properties properties = new Properties();
        String user = this.getUser();
        String password = this.getPassword();
        if (!user.isEmpty()) {
            properties.put("user", user);
        }
        if (!password.isEmpty()) {
            properties.put("password", password);
        }
        properties.putAll(this.jdbcProperties);
        return DriverManager.getConnection(this.getJdbcUrl(), properties);
    }

    protected boolean withResultSet(final String sql, final ResultSetConsumer resultSetConsumer) {
        return this.withStatement(new StatementConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Statement statement) {
                ResultSet rs = null;
                try {
                    rs = statement.executeQuery(sql);
                    boolean bl = resultSetConsumer.run(rs);
                    return bl;
                }
                catch (SQLException e) {
                    AbstractJdbcAction.this.logError("Could not execute query: " + e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        });
    }

    protected boolean withStatement(final StatementConsumer statementConsumer) {
        return this.withConnection(new ConnectionConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Connection connection) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    boolean bl = statementConsumer.run(statement);
                    return bl;
                }
                catch (SQLException e) {
                    AbstractJdbcAction.this.logError("Could not create JDBC statement: " + e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean withConnection(ConnectionConsumer connectionConsumer) {
        Connection connection = null;
        try {
            connection = this.createConnection();
            boolean bl = connectionConsumer.run(connection);
            return bl;
        }
        catch (SQLException e) {
            this.logError("Could not create JDBC connection: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void logError(String message) {
        Logger.getInstance().log(this, message, false);
    }

    protected void logSuccess(String message) {
        Logger.getInstance().log(this, message, true);
    }

    public static interface ConnectionConsumer {
        public boolean run(Connection var1) throws SQLException;
    }

    public static interface ResultSetConsumer {
        public boolean run(ResultSet var1) throws SQLException;
    }

    public static interface StatementConsumer {
        public boolean run(Statement var1) throws SQLException;
    }
}

